/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ruta.RutaProcessRuntimeException;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.rule.AbstractRule;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.rule.RuleMatch;

public class RuleApply
extends ScriptApply {
    private List<AbstractRuleMatch<? extends AbstractRule>> list = new ArrayList<AbstractRuleMatch<? extends AbstractRule>>();
    protected int tried = 0;
    protected int applied = 0;
    private boolean acceptMatches;

    public RuleApply(RutaStatement tme, boolean remember) {
        super(tme);
        this.acceptMatches = remember;
    }

    public List<AbstractRuleMatch<? extends AbstractRule>> getList() {
        return this.list;
    }

    public void add(AbstractRuleMatch<? extends AbstractRule> match, RutaStream stream) {
        if (match.matchedCompletely()) {
            ++this.applied;
        }
        ++this.tried;
        if (this.acceptMatches) {
            this.list.add(match);
        }
        if ((long)this.tried > stream.getMaxRuleMatches()) {
            throw new RutaProcessRuntimeException("Rule exceeded the allowed amount of matches (" + stream.getMaxRuleMatches() + "): " + match.getRule().toString());
        }
    }

    public int getTried() {
        return this.tried;
    }

    public int getApplied() {
        return this.applied;
    }

    public boolean isAcceptMatches() {
        return this.acceptMatches;
    }

    public void setAcceptMatches(boolean acceptMatches) {
        this.acceptMatches = acceptMatches;
    }

    public void addAll(List<RuleMatch> matches, RutaStream stream) {
        for (RuleMatch ruleMatch : matches) {
            this.add(ruleMatch, stream);
        }
    }
}

