/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Collator;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.Platform;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.JavaExtensionFunctionFactory;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.java.JRegularExpression;
import net.sf.saxon.java.JavaCollationFactory;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.NamedCollation;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class JavaPlatform
implements Platform {
    private static JavaPlatform theInstance = new JavaPlatform();

    public static JavaPlatform getInstance() {
        return theInstance;
    }

    private JavaPlatform() {
    }

    public void initialize(Configuration configuration) {
        configuration.setExtensionFunctionFactory("java", new JavaExtensionFunctionFactory(configuration));
    }

    public boolean isJava() {
        return true;
    }

    public boolean isDotNet() {
        return false;
    }

    public URI makeAbsolute(String string, String string2) throws URISyntaxException {
        URI uRI;
        block9: {
            if (string == null) {
                URI uRI2 = new URI(ResolveURI.escapeSpaces(string2));
                if (!uRI2.isAbsolute()) {
                    throw new URISyntaxException(string2, "Relative URI not supplied, so base URI must be absolute");
                }
                return uRI2;
            }
            string = ResolveURI.escapeSpaces(string);
            string2 = ResolveURI.escapeSpaces(string2);
            try {
                if (string2 == null) {
                    String string3;
                    uRI = new URI(string);
                    if (!uRI.isAbsolute() && !(string3 = ResolveURI.tryToExpand(string2)).equals(string2)) {
                        return this.makeAbsolute(string, string3);
                    }
                    break block9;
                }
                if (string2 != null && string2.startsWith("jar:")) {
                    try {
                        URL uRL = new URL(string2);
                        URL uRL2 = new URL(uRL, string);
                        uRI = new URI(uRL2.toString());
                        break block9;
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new URISyntaxException(string2 + " " + string, malformedURLException.getMessage());
                    }
                }
                URI uRI3 = new URI(string2);
                new URI(string);
                uRI = string.length() == 0 ? uRI3 : uRI3.resolve(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new URISyntaxException(string, "Cannot resolve URI against base " + Err.wrap(string2));
            }
        }
        return uRI;
    }

    public String getPlatformVersion() {
        return "Java version " + System.getProperty("java.version");
    }

    public String getPlatformSuffix() {
        return "J";
    }

    public Source getParserSource(Configuration configuration, StreamSource streamSource, int n, boolean bl, int n2) {
        return streamSource;
    }

    public RegularExpression compileRegularExpression(CharSequence charSequence, boolean bl, CharSequence charSequence2) throws XPathException {
        int n = JRegularExpression.setFlags(charSequence2);
        return new JRegularExpression(charSequence, bl, n);
    }

    public StringCollator makeCollation(Configuration configuration, Properties properties, String string) throws XPathException {
        return JavaCollationFactory.makeCollation(configuration, string, properties);
    }

    public boolean canReturnCollationKeys(StringCollator stringCollator) {
        if (stringCollator instanceof Collator || stringCollator instanceof CodepointCollator) {
            return true;
        }
        if (stringCollator instanceof NamedCollation) {
            return ((NamedCollation)stringCollator).getCollation() instanceof Collator;
        }
        return false;
    }

    public Object getCollationKey(NamedCollation namedCollation, String string) {
        return ((Collator)namedCollation.getCollation()).getCollationKey(string);
    }

    public FunctionLibrary makeExtensionLibrary(Configuration configuration) {
        return new JavaExtensionLibrary(configuration);
    }

    public void addFunctionLibraries(FunctionLibraryList functionLibraryList, Configuration configuration) {
        functionLibraryList.addFunctionLibrary(configuration.getExtensionBinder());
    }

    public void declareJavaClass(FunctionLibrary functionLibrary, String string, Class clazz) {
        if (!(functionLibrary instanceof JavaExtensionLibrary)) {
            throw new IllegalStateException("saxon:script cannot be used with a custom extension library factory");
        }
        ((JavaExtensionLibrary)functionLibrary).declareJavaClass(string, clazz);
    }

    public SchemaType getExternalObjectType(Configuration configuration, String string, String string2) {
        throw new UnsupportedOperationException("getExternalObjectType for Java");
    }
}

