/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.LocalVariable;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class XSLVariable
extends XSLVariableDeclaration {
    private int state = 0;

    public void prepareAttributes() throws XPathException {
        if (this.state == 2) {
            return;
        }
        if (this.state == 1) {
            this.compileError("Circular reference to variable", "XTDE0640");
        }
        this.state = 1;
        super.prepareAttributes();
        this.state = 2;
    }

    public boolean isInstruction() {
        return true;
    }

    public SequenceType getRequiredType() {
        SequenceType sequenceType;
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        SequenceType sequenceType2 = sequenceType = this.requiredType == null ? SequenceType.ANY_SEQUENCE : this.requiredType;
        if (this.assignable) {
            return sequenceType;
        }
        if (this.requiredType != null) {
            return this.requiredType;
        }
        if (this.select != null) {
            if (Literal.isEmptySequence(this.select)) {
                return sequenceType;
            }
            try {
                return SequenceType.makeSequenceType(this.select.getItemType(typeHierarchy), this.select.getCardinality());
            }
            catch (Exception exception) {
                return sequenceType;
            }
        }
        if (this.hasChildNodes()) {
            return SequenceType.makeSequenceType(NodeKindTest.DOCUMENT, 16384);
        }
        return SequenceType.SINGLE_STRING;
    }

    public Expression compile(Executable executable) throws XPathException {
        if (this.references.size() == 0 && !this.assignable) {
            this.redundant = true;
        }
        if (!this.redundant) {
            if (this.global) {
                GlobalVariable globalVariable = new GlobalVariable();
                globalVariable.setExecutable(this.getExecutable());
                globalVariable.setHostLanguage(50);
                Expression.setParentExpression(this.select, globalVariable);
                this.initializeInstruction(executable, globalVariable);
                globalVariable.setVariableName(this.getVariableName());
                globalVariable.setSlotNumber(this.getSlotNumber());
                globalVariable.setRequiredType(this.getRequiredType());
                ExpressionTool.makeParentReferences(globalVariable);
                this.fixupBinding(globalVariable);
                globalVariable.setParentExpression(null);
                return globalVariable;
            }
            throw new AssertionError((Object)"Local variable found when compiling a global variable");
        }
        return null;
    }

    public Expression compileLocalVariable(Executable executable) throws XPathException {
        if (this.references.size() == 0 && !this.assignable) {
            this.redundant = true;
        }
        if (!this.redundant) {
            if (this.global) {
                throw new AssertionError((Object)"Global variable found when compiling local variable");
            }
            LocalVariable localVariable = new LocalVariable();
            Expression.setParentExpression(this.select, localVariable);
            this.initializeInstruction(executable, localVariable);
            localVariable.setVariableName(this.getVariableName());
            localVariable.setRequiredType(this.getRequiredType());
            ExpressionTool.makeParentReferences(localVariable);
            return localVariable;
        }
        return null;
    }
}

