/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.patterns.BacktrackingInfo;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Role;

public abstract class Statement
extends AstNode {
    private int _offset;
    public static final Statement NULL = new NullStatement(-34);

    protected Statement(int offset) {
        this._offset = offset;
    }

    @Override
    public Statement clone() {
        return (Statement)super.clone();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.STATEMENT;
    }

    public Role<? extends Statement> getRole() {
        return super.getRole();
    }

    public boolean isEmbeddable() {
        return false;
    }

    public final Statement getNextStatement() {
        AstNode next;
        for (next = this.getNextSibling(); next != null && !(next instanceof Statement); next = next.getNextSibling()) {
        }
        return (Statement)next;
    }

    public final Statement getPreviousStatement() {
        AstNode previous;
        for (previous = this.getPreviousSibling(); previous != null && !(previous instanceof Statement); previous = previous.getPreviousSibling()) {
        }
        return (Statement)previous;
    }

    public static Statement forPattern(Pattern pattern) {
        return new PatternPlaceholder(-34, (Pattern)VerifyArgument.notNull((Object)pattern, (String)"pattern"));
    }

    public int getOffset() {
        return this._offset;
    }

    private static final class PatternPlaceholder
    extends Statement {
        final Pattern child;

        PatternPlaceholder(int offset, Pattern child) {
            super(offset);
            this.child = child;
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.PATTERN;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return visitor.visitPatternPlaceholder(this, this.child, data);
        }

        @Override
        public boolean matchesCollection(Role role, INode position, Match match, BacktrackingInfo backtrackingInfo) {
            return this.child.matchesCollection(role, position, match, backtrackingInfo);
        }

        @Override
        public boolean matches(INode other, Match match) {
            return this.child.matches(other, match);
        }
    }

    private static final class NullStatement
    extends Statement {
        public NullStatement(int offset) {
            super(offset);
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

