/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.DoubleConsumer;
import java.util.stream.DoubleStream;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.DoubleArrayFSImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.CommonPrimitiveArray;
import org.apache.uima.jcas.cas.TOP;

public final class DoubleArray
extends TOP
implements CommonPrimitiveArray<Double>,
DoubleArrayFSImpl,
Iterable<Double> {
    public static final String _TypeName = "uima.cas.DoubleArray";
    public static final int typeIndexID;
    public static final int type;
    private final double[] theArray;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private DoubleArray() {
        this.theArray = null;
    }

    public DoubleArray(JCas jcas, int length) {
        super(jcas);
        this.theArray = new double[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2size_nonHeapStoredArrays();
        }
    }

    public DoubleArray(TypeImpl t, CASImpl c, int length) {
        super(t, c);
        this.theArray = new double[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2size_nonHeapStoredArrays();
        }
    }

    @Override
    public double get(int i) {
        return this.theArray[i];
    }

    @Override
    public void set(int i, double v) {
        this.theArray[i] = v;
        this._casView.maybeLogArrayUpdate(this, null, i);
    }

    @Override
    public void copyFromArray(double[] src, int srcPos, int destPos, int length) {
        System.arraycopy(src, srcPos, this.theArray, destPos, length);
    }

    @Override
    public void copyToArray(int srcPos, double[] dest, int destPos, int length) {
        System.arraycopy(this.theArray, srcPos, dest, destPos, length);
    }

    @Override
    public double[] toArray() {
        return Arrays.copyOf(this.theArray, this.theArray.length);
    }

    @Override
    public int size() {
        return this.theArray.length;
    }

    @Override
    public void copyToArray(int srcPos, String[] dest, int destPos, int length) {
        this._casView.checkArrayBounds(this.theArray.length, srcPos, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destPos] = Double.toString(this.theArray[i + srcPos]);
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcPos, int destPos, int length) {
        this._casView.checkArrayBounds(this.theArray.length, destPos, length);
        for (int i = 0; i < length; ++i) {
            this.theArray[i + destPos] = Double.parseDouble(src[i + srcPos]);
        }
    }

    public double[] _getTheArray() {
        return this.theArray;
    }

    @Override
    public void copyValuesFrom(CommonArrayFS v) {
        DoubleArray bv = (DoubleArray)v;
        System.arraycopy(bv.theArray, 0, this.theArray, 0, this.theArray.length);
    }

    @Override
    public void setArrayValueFromString(int i, String v) {
        this.set(i, Double.parseDouble(v));
    }

    public Spliterator.OfDouble spliterator() {
        return Arrays.spliterator(this.theArray);
    }

    public PrimitiveIterator.OfDouble iterator() {
        return new PrimitiveIterator.OfDouble(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < DoubleArray.this.size();
            }

            @Override
            public Double next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DoubleArray.this.get(this.i++);
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DoubleArray.this.get(this.i++);
            }
        };
    }

    public DoubleStream stream() {
        return Arrays.stream(this.theArray);
    }

    public static DoubleArray create(JCas jcas, double[] a) {
        DoubleArray doubleArray = new DoubleArray(jcas, a.length);
        doubleArray.copyFromArray(a, 0, 0, a.length);
        return doubleArray;
    }

    public void forEach(DoubleConsumer action) {
        for (double d : this.theArray) {
            action.accept(d);
        }
    }

    public boolean contains(double item) {
        for (double b : this.theArray) {
            if (b != item) continue;
            return true;
        }
        return false;
    }

    static {
        type = typeIndexID = JCasRegistry.register(DoubleArray.class);
    }
}

