/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.annotation.headers.BundleCategory;
import aQute.bnd.annotation.headers.BundleContributors;
import aQute.bnd.annotation.headers.BundleCopyright;
import aQute.bnd.annotation.headers.BundleDevelopers;
import aQute.bnd.annotation.headers.BundleDocURL;
import aQute.bnd.annotation.headers.BundleLicense;
import aQute.bnd.annotation.headers.Category;
import aQute.bnd.annotation.headers.ProvideCapability;
import aQute.bnd.annotation.headers.RequireCapability;
import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.Processor;
import aQute.lib.collections.MultiMap;
import aQute.lib.strings.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationHeaders
extends ClassDataCollector
implements Closeable {
    final Analyzer analyzer;
    final Set<Descriptors.TypeRef> interesting = new HashSet<Descriptors.TypeRef>();
    final Set<Descriptors.TypeRef> used = new HashSet<Descriptors.TypeRef>();
    final MultiMap<String, String> headers = new MultiMap();
    final Descriptors.TypeRef bundleLicenseRef;
    final Descriptors.TypeRef requireCapabilityRef;
    final Descriptors.TypeRef provideCapabilityRef;
    final Descriptors.TypeRef bundleCategoryRef;
    final Descriptors.TypeRef bundleDocURLRef;
    final Descriptors.TypeRef bundleDeveloperRef;
    final Descriptors.TypeRef bundleContributorRef;
    final Descriptors.TypeRef bundleCopyrightRef;
    Clazz current;
    boolean finalizing;

    AnnotationHeaders(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.bundleLicenseRef = analyzer.getTypeRefFromFQN(BundleLicense.class.getName());
        this.interesting.add(this.bundleLicenseRef);
        this.requireCapabilityRef = analyzer.getTypeRefFromFQN(RequireCapability.class.getName());
        this.interesting.add(this.requireCapabilityRef);
        this.provideCapabilityRef = analyzer.getTypeRefFromFQN(ProvideCapability.class.getName());
        this.interesting.add(this.provideCapabilityRef);
        this.bundleCategoryRef = analyzer.getTypeRefFromFQN(BundleCategory.class.getName());
        this.interesting.add(this.bundleCategoryRef);
        this.bundleDocURLRef = analyzer.getTypeRefFromFQN(BundleDocURL.class.getName());
        this.interesting.add(this.bundleDocURLRef);
        this.bundleDeveloperRef = analyzer.getTypeRefFromFQN(BundleDevelopers.class.getName());
        this.interesting.add(this.bundleDeveloperRef);
        this.bundleContributorRef = analyzer.getTypeRefFromFQN(BundleContributors.class.getName());
        this.interesting.add(this.bundleContributorRef);
        this.bundleCopyrightRef = analyzer.getTypeRefFromFQN(BundleCopyright.class.getName());
        this.interesting.add(this.bundleCopyrightRef);
    }

    @Override
    public boolean classStart(Clazz c) {
        if (this.finalizing) {
            this.current = c;
            return true;
        }
        this.current = null;
        if (!c.isAnnotation()) {
            if (c.annotations != null) {
                this.used.addAll(c.annotations);
            }
            if (c.annotations != null && this.containsAny(this.interesting, c.annotations)) {
                this.current = c;
                return true;
            }
        }
        return false;
    }

    @Override
    public void annotation(Annotation annotation) throws Exception {
        Descriptors.TypeRef name = annotation.getName();
        if (this.interesting.contains(name)) {
            if (name == this.bundleLicenseRef) {
                this.doLicense(annotation.getAnnotation(BundleLicense.class));
            } else if (name == this.requireCapabilityRef) {
                this.doRequireCapability(annotation.getAnnotation(RequireCapability.class));
            } else if (name == this.provideCapabilityRef) {
                this.doProvideCapability(annotation.getAnnotation(ProvideCapability.class));
            } else if (name == this.bundleCategoryRef) {
                this.doBundleCategory(annotation.getAnnotation(BundleCategory.class));
            } else if (name == this.bundleDocURLRef) {
                this.doBundleDocURL(annotation.getAnnotation(BundleDocURL.class));
            } else if (name == this.bundleDeveloperRef) {
                this.doBundleDevelopers(annotation.getAnnotation(BundleDevelopers.class));
            } else if (name == this.bundleContributorRef) {
                this.doBundleContributors(annotation.getAnnotation(BundleContributors.class));
            } else if (name == this.bundleCopyrightRef) {
                this.doBundeCopyright(annotation.getAnnotation(BundleCopyright.class));
            } else {
                this.analyzer.error("Unknon annotation %s on %s", name, this.current.getClassName());
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.finalizing = true;
        try {
            for (Descriptors.TypeRef typeRef : this.used) {
                Clazz c = this.analyzer.findClass(typeRef);
                if (c == null) continue;
                c.parseClassFileWithCollector(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void doBundleDevelopers(BundleDevelopers annotation) throws IOException {
        StringBuilder sb = new StringBuilder(annotation.value());
        if (annotation.name() != null) {
            sb.append(";name='");
            this.escape(sb, annotation.name());
            sb.append("'");
        }
        if (annotation.roles() != null) {
            sb.append(";roles='");
            this.escape(sb, annotation.roles());
            sb.append("'");
        }
        if (annotation.organizationUrl() != null) {
            sb.append(";organizationUrl='");
            this.escape(sb, annotation.organizationUrl());
            sb.append("'");
        }
        if (annotation.organization() != null) {
            sb.append(";organization='");
            this.escape(sb, annotation.organization());
            sb.append("'");
        }
        if (annotation.timezone() != 0) {
            sb.append(";timezone=").append(annotation.timezone());
        }
        this.add("Bundle-Developers", sb.toString());
    }

    private void doBundleContributors(BundleContributors annotation) throws IOException {
        StringBuilder sb = new StringBuilder(annotation.value());
        if (annotation.name() != null) {
            sb.append(";name='");
            this.escape(sb, annotation.name());
            sb.append("'");
        }
        if (annotation.roles() != null) {
            sb.append(";roles='");
            this.escape(sb, annotation.roles());
            sb.append("'");
        }
        if (annotation.organizationUrl() != null) {
            sb.append(";organizationUrl='");
            this.escape(sb, annotation.organizationUrl());
            sb.append("'");
        }
        if (annotation.organization() != null) {
            sb.append(";organization='");
            this.escape(sb, annotation.organization());
            sb.append("'");
        }
        if (annotation.timezone() != 0) {
            sb.append(";timezone=").append(annotation.timezone());
        }
        this.add("Bundle-Contributors", sb.toString());
    }

    private void doBundeCopyright(BundleCopyright annotation) {
        this.add("Bundle-Copyright", annotation.value());
    }

    private void doBundleDocURL(BundleDocURL annotation) {
        this.add("Bundle-DocURL", annotation.value());
    }

    private void doBundleCategory(BundleCategory annotation) {
        if (annotation.custom() != null) {
            for (String string : annotation.custom()) {
                this.add("Bundle-Category", string);
            }
        }
        if (annotation.value() != null) {
            for (Category category : annotation.value()) {
                this.add("Bundle-Category", ((Object)((Object)category)).toString());
            }
        }
    }

    private void doProvideCapability(ProvideCapability annotation) {
        StringBuilder sb = new StringBuilder(annotation.ns());
        if (annotation.name() != null) {
            sb.append(";").append(annotation.ns()).append("='").append(annotation.name()).append("'");
        }
        if (annotation.uses() != null) {
            sb.append(";").append("uses:='").append(Strings.join(",", annotation.uses())).append("'");
        }
        if (annotation.mandatory() != null) {
            sb.append(";").append("mandatory:='").append(Strings.join(",", annotation.mandatory())).append("'");
        }
        if (annotation.version() != null) {
            sb.append(";").append("version:Version='").append(annotation.version()).append("'");
        }
        if (annotation.value() != null) {
            sb.append(";").append(annotation.value());
        }
        if (annotation.effective() != null) {
            sb.append(";effective:='").append(annotation.effective()).append("'");
        }
        this.add("Provide-Capability", sb.toString());
    }

    private void doRequireCapability(RequireCapability annotation) {
        StringBuilder sb = new StringBuilder(annotation.ns());
        if (annotation.filter() != null) {
            sb.append(";filter:='").append(annotation.filter()).append("'");
        }
        if (annotation.effective() != null) {
            sb.append(";effective:='").append(annotation.effective()).append("'");
        }
        if (annotation.resolution() != null) {
            sb.append(";resolution:='").append((Object)annotation.resolution()).append("'");
        }
        if (annotation.value() != null) {
            sb.append(";").append(annotation.value());
        }
        this.add("Require-Capability", sb.toString());
    }

    private void doLicense(BundleLicense annotation) {
        StringBuilder sb = new StringBuilder(annotation.name());
        if (!annotation.description().equals("")) {
            sb.append(";description='").append(annotation.description().replaceAll("'", "\\'")).append("'");
        }
        if (!annotation.link().equals("")) {
            sb.append(";link='").append(annotation.link().replaceAll("'", "\\'")).append("'");
        }
        this.add("Bundle-License", sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String name, String value) {
        if (value == null) {
            return;
        }
        Processor next = new Processor(this.analyzer);
        next.setProperty("@class", this.current.getFQN());
        next.setProperty("@class-short", this.current.getClassName().getShortName());
        Descriptors.PackageRef pref = this.current.getClassName().getPackageRef();
        next.setProperty("@package", pref.getFQN());
        Attrs info = this.analyzer.getClasspathExports().get(pref);
        if (info == null) {
            info = this.analyzer.getContained().get(pref);
        }
        if (info != null && info.containsKey("version")) {
            next.setProperty("@version", info.get("version"));
        }
        Macro macro = next.getReplacer();
        boolean prev = macro.setNosystem(true);
        try {
            value = macro.process(value);
            this.headers.add(name, value);
            next.close();
        }
        finally {
            macro.setNosystem(prev);
        }
    }

    public String getHeader(String name) {
        String value = this.analyzer.getProperty(name);
        if (this.headers.containsKey(name)) {
            TreeSet set = new TreeSet((Collection)this.headers.get(name));
            String header = Strings.join(set);
            if (value == null) {
                return header;
            }
            return value + "," + header;
        }
        return value;
    }

    private <T> boolean containsAny(Set<T> a, Set<T> b) {
        for (T aa : a) {
            if (!b.contains(aa)) continue;
            return true;
        }
        return false;
    }

    private void escape(StringBuilder app, String[] s) throws IOException {
        String joined = Strings.join(s);
        this.escape(app, joined);
    }

    private void escape(StringBuilder app, String s) throws IOException {
        Processor.quote(app, s);
    }
}

