/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.recovery;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class RecoveryStats
implements ToXContentFragment,
Writeable {
    private final AtomicInteger currentAsSource = new AtomicInteger();
    private final AtomicInteger currentAsTarget = new AtomicInteger();
    private final AtomicLong throttleTimeInNanos = new AtomicLong();

    public RecoveryStats() {
    }

    public RecoveryStats(StreamInput in) throws IOException {
        this.currentAsSource.set(in.readVInt());
        this.currentAsTarget.set(in.readVInt());
        this.throttleTimeInNanos.set(in.readLong());
    }

    public void add(RecoveryStats recoveryStats) {
        if (recoveryStats != null) {
            this.currentAsSource.addAndGet(recoveryStats.currentAsSource());
            this.currentAsTarget.addAndGet(recoveryStats.currentAsTarget());
        }
        this.addTotals(recoveryStats);
    }

    public void addTotals(RecoveryStats recoveryStats) {
        if (recoveryStats != null) {
            this.throttleTimeInNanos.addAndGet(recoveryStats.throttleTime().nanos());
        }
    }

    public int currentAsSource() {
        return this.currentAsSource.get();
    }

    public int currentAsTarget() {
        return this.currentAsTarget.get();
    }

    public TimeValue throttleTime() {
        return TimeValue.timeValueNanos(this.throttleTimeInNanos.get());
    }

    public void incCurrentAsTarget() {
        this.currentAsTarget.incrementAndGet();
    }

    public void decCurrentAsTarget() {
        this.currentAsTarget.decrementAndGet();
    }

    public void incCurrentAsSource() {
        this.currentAsSource.incrementAndGet();
    }

    public void decCurrentAsSource() {
        this.currentAsSource.decrementAndGet();
    }

    public void addThrottleTime(long nanos) {
        this.throttleTimeInNanos.addAndGet(nanos);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("recovery");
        builder.field("current_as_source", this.currentAsSource());
        builder.field("current_as_target", this.currentAsTarget());
        builder.humanReadableField("throttle_time_in_millis", "throttle_time", this.throttleTime());
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.currentAsSource.get());
        out.writeVInt(this.currentAsTarget.get());
        out.writeLong(this.throttleTimeInNanos.get());
    }

    public String toString() {
        return "recoveryStats, currentAsSource [" + this.currentAsSource() + "],currentAsTarget [" + this.currentAsTarget() + "], throttle [" + this.throttleTime() + "]";
    }

    static final class Fields {
        static final String RECOVERY = "recovery";
        static final String CURRENT_AS_SOURCE = "current_as_source";
        static final String CURRENT_AS_TARGET = "current_as_target";
        static final String THROTTLE_TIME = "throttle_time";
        static final String THROTTLE_TIME_IN_MILLIS = "throttle_time_in_millis";

        Fields() {
        }
    }
}

