/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.main.lock.SimpleFileLock;
import org.apache.karaf.main.util.Utils;
import org.apache.karaf.util.config.PropertiesLoader;

public class ConfigProperties {
    public static final String PROP_KARAF_HOME = "karaf.home";
    public static final String PROP_KARAF_HOME_URI = "karaf.home.uri";
    public static final String ENV_KARAF_HOME = "KARAF_HOME";
    public static final String PROP_KARAF_BASE = "karaf.base";
    public static final String PROP_KARAF_BASE_URI = "karaf.base.uri";
    public static final String ENV_KARAF_BASE = "KARAF_BASE";
    public static final String PROP_KARAF_DATA = "karaf.data";
    public static final String PROP_KARAF_DATA_URI = "karaf.data.uri";
    public static final String ENV_KARAF_DATA = "KARAF_DATA";
    public static final String PROP_KARAF_ETC = "karaf.etc";
    public static final String PROP_KARAF_ETC_URI = "karaf.etc.uri";
    public static final String ENV_KARAF_ETC = "KARAF_ETC";
    public static final String PROP_KARAF_INSTANCES = "karaf.instances";
    public static final String PROP_KARAF_INSTANCES_URI = "karaf.instances.uri";
    public static final String ENV_KARAF_INSTANCES = "KARAF_INSTANCES";
    public static final String PROP_KARAF_VERSION = "karaf.version";
    private static final String CONFIG_PROPERTIES_FILE_NAME = "config.properties";
    public static final String SYSTEM_PROPERTIES_FILE_NAME = "system.properties";
    private static final String BUNDLE_LOCATIONS = "bundle.locations";
    private static final String PROPERTY_LOCK_CLASS = "karaf.lock.class";
    public static final String PROPERTY_LOCK_DELAY = "karaf.lock.delay";
    public static final String PROPERTY_LOCK_LOST_THRESHOLD = "karaf.lock.lostThreshold";
    private static final String PROPERTY_LOCK_LEVEL = "karaf.lock.level";
    private static final String PROPERTY_LOCK_SLAVE_BLOCK = "karaf.lock.slave.block";
    private static final String DEFAULT_REPO = "karaf.default.repository";
    private static final String KARAF_FRAMEWORK = "karaf.framework";
    private static final String KARAF_FRAMEWORK_FACTORY = "karaf.framework.factory";
    private static final String KARAF_SHUTDOWN_TIMEOUT = "karaf.shutdown.timeout";
    private static final String KARAF_SHUTDOWN_PORT = "karaf.shutdown.port";
    private static final String KARAF_SHUTDOWN_HOST = "karaf.shutdown.host";
    private static final String KARAF_SHUTDOWN_PORT_FILE = "karaf.shutdown.port.file";
    private static final String KARAF_SHUTDOWN_COMMAND = "karaf.shutdown.command";
    private static final String KARAF_SHUTDOWN_PID_FILE = "karaf.shutdown.pid.file";
    private static final String KARAF_PID_FILE = "karaf.pid.file";
    private static final String KARAF_STARTUP_MESSAGE = "karaf.startup.message";
    private static final String KARAF_DELAY_CONSOLE = "karaf.delay.console";
    private static final String KARAF_THREAD_MONITORING = "karaf.thread.monitoring";
    private static final String PROPERTY_LOCK_CLASS_DEFAULT = SimpleFileLock.class.getName();
    private static final String SECURITY_PROVIDERS = "org.apache.karaf.security.providers";
    public static final String DEFAULT_LOCK_DELAY = "1000";
    public static final String DEFAULT_LOCK_LOST_THRESHOLD = "0";
    private static final String PROPERTY_USE_LOCK = "karaf.lock";
    File karafHome = Utils.getKarafHome(ConfigProperties.class, "karaf.home", "KARAF_HOME");
    File karafBase = Utils.getKarafDirectory("karaf.base", "KARAF_BASE", this.karafHome, false, true);
    File karafData = Utils.getKarafDirectory("karaf.data", "KARAF_DATA", new File(this.karafBase, "data"), true, true);
    File karafEtc = Utils.getKarafDirectory("karaf.etc", "KARAF_ETC", new File(this.karafBase, "etc"), true, true);
    File karafInstances = Utils.getKarafDirectory("karaf.instances", "KARAF_INSTANCES", new File(this.karafHome, "instances"), false, false);
    Properties props;
    String[] securityProviders;
    int defaultStartLevel = 100;
    int lockStartLevel = 1;
    int lockDefaultBootLevel = 1;
    int lockDelay;
    int lockLostThreshold;
    boolean lockSlaveBlock = false;
    int shutdownTimeout = 300000;
    boolean useLock;
    String lockClass;
    String frameworkFactoryClass;
    URI frameworkBundle;
    String defaultRepo;
    String bundleLocations;
    int defaultBundleStartlevel;
    String pidFile;
    int shutdownPort;
    String shutdownHost;
    String portFile;
    String shutdownCommand;
    String startupMessage;
    boolean delayConsoleStart;
    boolean threadMonitoring;

    public ConfigProperties() throws Exception {
        Package p = Package.getPackage("org.apache.karaf.main");
        if (p != null && p.getImplementationVersion() != null) {
            System.setProperty(PROP_KARAF_VERSION, p.getImplementationVersion());
        }
        System.setProperty(PROP_KARAF_HOME, this.karafHome.getPath());
        System.setProperty(PROP_KARAF_BASE, this.karafBase.getPath());
        System.setProperty(PROP_KARAF_DATA, this.karafData.getPath());
        System.setProperty(PROP_KARAF_ETC, this.karafEtc.getPath());
        System.setProperty(PROP_KARAF_INSTANCES, this.karafInstances.getPath());
        System.setProperty(PROP_KARAF_HOME_URI, this.karafHome.toURI().toASCIIString());
        System.setProperty(PROP_KARAF_BASE_URI, this.karafBase.toURI().toASCIIString());
        System.setProperty(PROP_KARAF_DATA_URI, this.karafData.toURI().toASCIIString());
        System.setProperty(PROP_KARAF_ETC_URI, this.karafEtc.toURI().toASCIIString());
        System.setProperty(PROP_KARAF_INSTANCES_URI, this.karafInstances.toURI().toASCIIString());
        if (!this.karafEtc.exists()) {
            throw new FileNotFoundException("Karaf etc folder not found: " + this.karafEtc.getAbsolutePath());
        }
        this.configureSAAJForIBMJVM();
        PropertiesLoader.loadSystemProperties(new File(this.karafEtc, SYSTEM_PROPERTIES_FILE_NAME));
        this.props = PropertiesLoader.loadConfigProperties(new File(this.karafEtc, CONFIG_PROPERTIES_FILE_NAME));
        this.securityProviders = this.getSecurityProviders();
        this.defaultStartLevel = Integer.parseInt(this.props.getProperty("org.osgi.framework.startlevel.beginning"));
        System.setProperty("org.osgi.framework.startlevel.beginning", Integer.toString(this.defaultStartLevel));
        this.lockStartLevel = Integer.parseInt(this.props.getProperty(PROPERTY_LOCK_LEVEL, Integer.toString(this.lockStartLevel)));
        this.lockDelay = Integer.parseInt(this.props.getProperty(PROPERTY_LOCK_DELAY, DEFAULT_LOCK_DELAY));
        this.lockLostThreshold = Integer.parseInt(this.props.getProperty(PROPERTY_LOCK_LOST_THRESHOLD, DEFAULT_LOCK_LOST_THRESHOLD));
        this.lockSlaveBlock = Boolean.parseBoolean(this.props.getProperty(PROPERTY_LOCK_SLAVE_BLOCK, "false"));
        this.props.setProperty("org.osgi.framework.startlevel.beginning", Integer.toString(this.lockDefaultBootLevel));
        this.shutdownTimeout = Integer.parseInt(this.props.getProperty(KARAF_SHUTDOWN_TIMEOUT, Integer.toString(this.shutdownTimeout)));
        this.useLock = Boolean.parseBoolean(this.props.getProperty(PROPERTY_USE_LOCK, "true"));
        this.lockClass = this.props.getProperty(PROPERTY_LOCK_CLASS, PROPERTY_LOCK_CLASS_DEFAULT);
        this.frameworkFactoryClass = this.props.getProperty(KARAF_FRAMEWORK_FACTORY);
        this.frameworkBundle = this.getFramework();
        this.defaultRepo = System.getProperty(DEFAULT_REPO, "system");
        this.bundleLocations = this.props.getProperty(BUNDLE_LOCATIONS);
        this.defaultBundleStartlevel = this.getDefaultBundleStartLevel(60);
        this.pidFile = this.props.getProperty(KARAF_PID_FILE, this.props.getProperty(KARAF_SHUTDOWN_PID_FILE));
        this.shutdownPort = Integer.parseInt(this.props.getProperty(KARAF_SHUTDOWN_PORT, DEFAULT_LOCK_LOST_THRESHOLD));
        this.shutdownHost = this.props.getProperty(KARAF_SHUTDOWN_HOST, "localhost");
        this.portFile = this.props.getProperty(KARAF_SHUTDOWN_PORT_FILE);
        this.shutdownCommand = this.props.getProperty(KARAF_SHUTDOWN_COMMAND);
        this.startupMessage = this.props.getProperty(KARAF_STARTUP_MESSAGE, "Apache Karaf starting up. Press Enter to open the shell now...");
        this.delayConsoleStart = Boolean.parseBoolean(this.props.getProperty(KARAF_DELAY_CONSOLE, "false"));
        this.threadMonitoring = Boolean.parseBoolean(this.props.getProperty(KARAF_THREAD_MONITORING, "false"));
        System.setProperty(KARAF_DELAY_CONSOLE, Boolean.toString(this.delayConsoleStart));
    }

    public void performInit() throws Exception {
        File cleanAllIndicatorFile = new File(this.karafData, "clean_all");
        File cleanCacheIndicatorFile = new File(this.karafData, "clean_cache");
        if (Boolean.getBoolean("karaf.clean.all") || cleanAllIndicatorFile.exists()) {
            if (cleanAllIndicatorFile.exists()) {
                cleanAllIndicatorFile.delete();
            }
            Utils.deleteDirectory(this.karafData);
            this.karafData = Utils.getKarafDirectory(PROP_KARAF_DATA, ENV_KARAF_DATA, new File(this.karafBase, "data"), true, true);
        } else if (Boolean.getBoolean("karaf.clean.cache") || cleanCacheIndicatorFile.exists()) {
            if (cleanCacheIndicatorFile.exists()) {
                cleanCacheIndicatorFile.delete();
            }
            File karafCache = Utils.validateDirectoryExists(new File(this.karafData, "cache").getPath(), "Invalid cache directory", true, true);
            Utils.deleteDirectory(karafCache);
        }
        String frameworkStoragePath = this.props.getProperty("org.osgi.framework.storage");
        if (frameworkStoragePath == null) {
            File storage = new File(this.karafData.getPath(), "cache");
            try {
                storage.mkdirs();
            }
            catch (SecurityException se) {
                throw new Exception(se.getMessage());
            }
            this.props.setProperty("org.osgi.framework.storage", storage.getAbsolutePath());
        }
        if (this.shutdownCommand == null || this.shutdownCommand.isEmpty()) {
            try {
                this.shutdownCommand = UUID.randomUUID().toString();
                Properties temp = new Properties(new File(this.karafEtc, CONFIG_PROPERTIES_FILE_NAME));
                temp.put(KARAF_SHUTDOWN_COMMAND, Arrays.asList("", "#", "# Generated command shutdown", "#"), this.shutdownCommand);
                temp.save();
            }
            catch (IOException ioException) {
                System.err.println("WARN: can't update etc/config.properties with the generated command shutdown. We advise to manually add the karaf.shutdown.command property.");
            }
        }
        if (this.threadMonitoring) {
            ThreadMXBean threadsBean = ManagementFactory.getThreadMXBean();
            if (threadsBean.isThreadCpuTimeSupported()) {
                threadsBean.setThreadCpuTimeEnabled(true);
            }
            if (threadsBean.isThreadContentionMonitoringSupported()) {
                threadsBean.setThreadContentionMonitoringEnabled(true);
            }
        }
    }

    private String getPropertyOrFail(String propertyName) {
        String value = this.props.getProperty(propertyName);
        if (value == null) {
            throw new IllegalArgumentException("Property " + propertyName + " must be set in the etc/" + CONFIG_PROPERTIES_FILE_NAME + " configuration file");
        }
        return value;
    }

    private String[] getSecurityProviders() {
        String prop = this.props.getProperty(SECURITY_PROVIDERS);
        return prop != null ? prop.split(",") : new String[]{};
    }

    private URI getFramework() throws URISyntaxException {
        String framework = this.getPropertyOrFail(KARAF_FRAMEWORK);
        String frameworkBundleUri = this.getPropertyOrFail("karaf.framework." + framework);
        return new URI(frameworkBundleUri);
    }

    private int getDefaultBundleStartLevel(int ibsl) {
        try {
            String str = this.props.getProperty("karaf.startlevel.bundle");
            if (str != null) {
                ibsl = Integer.parseInt(str);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ibsl;
    }

    private void configureSAAJForIBMJVM() {
        if (System.getProperty("java.vendor").equals("IBM Corporation")) {
            System.setProperty("javax.xml.soap.MessageFactory", "com.sun.xml.internal.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl");
            System.setProperty("javax.xml.soap.SOAPFactory", "com.sun.xml.internal.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl");
            System.setProperty("javax.xml.soap.SOAPConnectionFactory", "com.sun.xml.internal.messaging.saaj.client.p2p.HttpSOAPConnectionFactory");
            System.setProperty("javax.xml.soap.MetaFactory", "com.sun.xml.internal.messaging.saaj.soap.SAAJMetaFactoryImpl");
        }
    }
}

