/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AtomicLongAddAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongAlterAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongApplyCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongCompareAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongDecrementAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndAddCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndIncrementCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongIncrementAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongSetCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IFunction;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.util.Preconditions;

public class ClientAtomicLongProxy
extends PartitionSpecificClientProxy
implements IAtomicLong {
    private static final ClientMessageDecoder ADD_AND_GET_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return AtomicLongAddAndGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder COMPARE_AND_SET_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return AtomicLongCompareAndSetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder DECREMENT_AND_GET_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return AtomicLongDecrementAndGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_AND_ADD_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return AtomicLongGetAndAddCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_AND_SET_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return AtomicLongGetAndSetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder INCREMENT_AND_GET_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return AtomicLongIncrementAndGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_AND_INCREMENT_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return AtomicLongGetAndIncrementCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder SET_ASYNC_DECODER = new ClientMessageDecoder(){

        public Void decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private static final ClientMessageDecoder ALTER_DECODER = new ClientMessageDecoder(){

        public Void decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private static final ClientMessageDecoder GET_AND_ALTER_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return AtomicLongGetAndAlterCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder ALTER_AND_GET_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return AtomicLongAlterAndGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder APPLY_DECODER = new ClientMessageDecoder(){

        public <V> V decodeClientMessage(ClientMessage clientMessage) {
            return (V)AtomicLongApplyCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return AtomicLongGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };

    public ClientAtomicLongProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    @Override
    public <R> R apply(IFunction<Long, R> function) {
        return (R)this.applyAsync((IFunction)function).join();
    }

    @Override
    public void alter(IFunction<Long, Long> function) {
        this.alterAsync((IFunction)function).join();
    }

    @Override
    public long alterAndGet(IFunction<Long, Long> function) {
        return (Long)this.alterAndGetAsync((IFunction)function).join();
    }

    @Override
    public long getAndAlter(IFunction<Long, Long> function) {
        return (Long)this.getAndAlterAsync((IFunction)function).join();
    }

    @Override
    public long addAndGet(long delta) {
        return (Long)this.addAndGetAsync(delta).join();
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        return (Boolean)this.compareAndSetAsync(expect, update).join();
    }

    @Override
    public long decrementAndGet() {
        return (Long)this.decrementAndGetAsync().join();
    }

    @Override
    public long get() {
        return (Long)this.getAsync().join();
    }

    @Override
    public long getAndAdd(long delta) {
        return (Long)this.getAndAddAsync(delta).join();
    }

    @Override
    public long getAndSet(long newValue) {
        return (Long)this.getAndSetAsync(newValue).join();
    }

    @Override
    public long incrementAndGet() {
        return (Long)this.incrementAndGetAsync().join();
    }

    @Override
    public long getAndIncrement() {
        return (Long)this.getAndIncrementAsync().join();
    }

    @Override
    public void set(long newValue) {
        this.setAsync(newValue).join();
    }

    public InternalCompletableFuture<Long> addAndGetAsync(long delta) {
        ClientMessage request = AtomicLongAddAndGetCodec.encodeRequest(this.name, delta);
        return this.invokeOnPartitionAsync(request, ADD_AND_GET_DECODER);
    }

    public InternalCompletableFuture<Boolean> compareAndSetAsync(long expect, long update) {
        ClientMessage request = AtomicLongCompareAndSetCodec.encodeRequest(this.name, expect, update);
        return this.invokeOnPartitionAsync(request, COMPARE_AND_SET_DECODER);
    }

    public InternalCompletableFuture<Long> decrementAndGetAsync() {
        ClientMessage request = AtomicLongDecrementAndGetCodec.encodeRequest(this.name);
        return this.invokeOnPartitionAsync(request, DECREMENT_AND_GET_DECODER);
    }

    public InternalCompletableFuture<Long> getAsync() {
        ClientMessage request = AtomicLongGetCodec.encodeRequest(this.name);
        return this.invokeOnPartitionAsync(request, GET_DECODER);
    }

    public InternalCompletableFuture<Long> getAndAddAsync(long delta) {
        ClientMessage request = AtomicLongGetAndAddCodec.encodeRequest(this.name, delta);
        return this.invokeOnPartitionAsync(request, GET_AND_ADD_DECODER);
    }

    public InternalCompletableFuture<Long> getAndSetAsync(long newValue) {
        ClientMessage request = AtomicLongGetAndSetCodec.encodeRequest(this.name, newValue);
        return this.invokeOnPartitionAsync(request, GET_AND_SET_DECODER);
    }

    public InternalCompletableFuture<Long> incrementAndGetAsync() {
        ClientMessage request = AtomicLongIncrementAndGetCodec.encodeRequest(this.name);
        return this.invokeOnPartitionAsync(request, INCREMENT_AND_GET_DECODER);
    }

    public InternalCompletableFuture<Long> getAndIncrementAsync() {
        ClientMessage request = AtomicLongGetAndIncrementCodec.encodeRequest(this.name);
        return this.invokeOnPartitionAsync(request, GET_AND_INCREMENT_DECODER);
    }

    public InternalCompletableFuture<Void> setAsync(long newValue) {
        ClientMessage request = AtomicLongSetCodec.encodeRequest(this.name, newValue);
        return this.invokeOnPartitionAsync(request, SET_ASYNC_DECODER);
    }

    public InternalCompletableFuture<Void> alterAsync(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, "function");
        ClientMessage request = AtomicLongAlterCodec.encodeRequest(this.name, this.toData(function));
        return this.invokeOnPartitionAsync(request, ALTER_DECODER);
    }

    public InternalCompletableFuture<Long> alterAndGetAsync(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, "function");
        ClientMessage request = AtomicLongAlterAndGetCodec.encodeRequest(this.name, this.toData(function));
        return this.invokeOnPartitionAsync(request, ALTER_AND_GET_DECODER);
    }

    public InternalCompletableFuture<Long> getAndAlterAsync(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, "function");
        ClientMessage request = AtomicLongGetAndAlterCodec.encodeRequest(this.name, this.toData(function));
        return this.invokeOnPartitionAsync(request, GET_AND_ALTER_DECODER);
    }

    public <R> InternalCompletableFuture<R> applyAsync(IFunction<Long, R> function) {
        Preconditions.isNotNull(function, "function");
        ClientMessage request = AtomicLongApplyCodec.encodeRequest(this.name, this.toData(function));
        return this.invokeOnPartitionAsync(request, APPLY_DECODER);
    }

    public String toString() {
        return "IAtomicLong{name='" + this.name + '\'' + '}';
    }
}

