/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.bundle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.cellar.bundle.BundleState;
import org.apache.karaf.cellar.bundle.BundleSupport;
import org.apache.karaf.cellar.bundle.ClusterBundleEvent;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.Synchronizer;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.core.utils.CellarUtils;
import org.apache.karaf.features.BootFinished;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleSynchronizer
extends BundleSupport
implements Synchronizer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(BundleSynchronizer.class);
    private EventProducer eventProducer;

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public void init(BundleContext bundleContext) {
        ServiceTracker tracker = new ServiceTracker(bundleContext, BootFinished.class, null);
        try {
            tracker.waitForService(120000L);
        }
        catch (Exception e) {
            LOGGER.warn("Can't start BootFinished service tracker", (Throwable)e);
        }
        if (this.groupManager == null) {
            return;
        }
        Set groups = this.groupManager.listLocalGroups();
        if (groups != null && !groups.isEmpty()) {
            for (Group group : groups) {
                this.sync(group);
            }
        }
    }

    public void destroy() {
    }

    public void sync(Group group) {
        String policy = this.getSyncPolicy(group);
        if (policy == null) {
            LOGGER.warn("CELLAR BUNDLE: sync policy is not defined for cluster group {}", (Object)group.getName());
        } else if (policy.equalsIgnoreCase("cluster")) {
            LOGGER.debug("CELLAR BUNDLE: sync policy set as 'cluster' for cluster group {}", (Object)group.getName());
            LOGGER.debug("CELLAR BUNDLE: updating node from the cluster (pull first)");
            this.pull(group);
            LOGGER.debug("CELLAR BUNDLE: node is the only one in the cluster group, no pull");
            LOGGER.debug("CELLAR BUNDLE: updating cluster from the local node (push after)");
            this.push(group);
        } else if (policy.equalsIgnoreCase("node")) {
            LOGGER.debug("CELLAR BUNDLE: sync policy set as 'node' for cluster group {}", (Object)group.getName());
            LOGGER.debug("CELLAR BUNDLE: updating cluster from the local node (push first)");
            this.push(group);
            LOGGER.debug("CELLAR BUNDLE: updating node from the cluster (pull after)");
            this.pull(group);
        } else if (policy.equalsIgnoreCase("clusterOnly")) {
            LOGGER.debug("CELLAR BUNDLE: sync policy set as 'clusterOnly' for cluster group " + group.getName());
            LOGGER.debug("CELLAR BUNDLE: updating node from the cluster (pull only)");
            this.pull(group);
            LOGGER.debug("CELLAR BUNDLE: node is the only one in the cluster group, no pull");
        } else if (policy.equalsIgnoreCase("nodeOnly")) {
            LOGGER.debug("CELLAR BUNDLE: sync policy set as 'nodeOnly' for cluster group " + group.getName());
            LOGGER.debug("CELLAR BUNDLE: updating cluster from the local node (push only)");
            this.push(group);
        } else {
            LOGGER.debug("CELLAR BUNDLE: sync policy set as 'disabled' for cluster group " + group.getName());
            LOGGER.debug("CELLAR BUNDLE: no sync");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pull(Group group) {
        if (group != null) {
            String groupName = group.getName();
            LOGGER.debug("CELLAR BUNDLE: pulling bundles from cluster group {}", (Object)groupName);
            Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + groupName);
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                ArrayList<String> bundleToStart = new ArrayList<String>();
                for (Map.Entry entry : clusterBundles.entrySet()) {
                    String id = (String)entry.getKey();
                    BundleState bundleState = (BundleState)entry.getValue();
                    String[] tokens = id.split("/");
                    if (tokens.length != 2) continue;
                    String symbolicName = tokens[0];
                    String version = tokens[1];
                    if (bundleState == null) continue;
                    String bundleLocation = bundleState.getLocation();
                    if (this.isAllowed(group, "bundle", bundleLocation, EventType.INBOUND).booleanValue()) {
                        try {
                            Bundle b;
                            if (bundleState.getStatus() == 2) {
                                if (!this.isInstalled(bundleState.getLocation())) {
                                    LOGGER.debug("CELLAR BUNDLE: installing bundle located {} on node", (Object)bundleState.getLocation());
                                    this.installBundleFromLocation(bundleState.getLocation(), bundleState.getStartLevel());
                                    continue;
                                }
                                LOGGER.debug("CELLAR BUNDLE: bundle located {} already installed on node", (Object)bundleState.getLocation());
                                continue;
                            }
                            if (bundleState.getStatus() == 32) {
                                if (!this.isInstalled(bundleState.getLocation())) {
                                    LOGGER.debug("CELLAR BUNDLE: installing bundle located {} on node", (Object)bundleState.getLocation());
                                    this.installBundleFromLocation(bundleState.getLocation(), bundleState.getStartLevel());
                                }
                                if (!this.isStarted(bundleState.getLocation())) {
                                    bundleToStart.add(id);
                                    continue;
                                }
                                LOGGER.debug("CELLAR BUNDLE: bundle located {} already started on node", (Object)bundleState.getLocation());
                                continue;
                            }
                            if (bundleState.getStatus() != 4) continue;
                            if (!this.isInstalled(bundleState.getLocation())) {
                                LOGGER.debug("CELLAR BUNDLE: installing bundle located {} on node", (Object)bundleState.getLocation());
                                this.installBundleFromLocation(bundleState.getLocation(), bundleState.getStartLevel());
                            }
                            if ((b = this.findBundle(bundleState.getLocation())) != null) {
                                if (b.getState() == 32) {
                                    LOGGER.debug("CELLAR BUNDLE: stopping bundle {}/{} on node", (Object)symbolicName, (Object)version);
                                    this.stopBundle(symbolicName, version);
                                    continue;
                                }
                                if (b.getState() != 2) continue;
                                LOGGER.debug("CELLAR BUNDLE: resolving bundle {}/{} on node", (Object)symbolicName, (Object)version);
                                ((FrameworkWiring)this.getBundleContext().getBundle(0L).adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(b));
                                continue;
                            }
                            LOGGER.warn("CELLAR BUNDLE: unable to find bundle located {} on node", (Object)bundleState.getLocation());
                        }
                        catch (BundleException e) {
                            this.resolveBundleException(id, e);
                        }
                        continue;
                    }
                    LOGGER.trace("CELLAR BUNDLE: bundle {} is marked BLOCKED INBOUND for cluster group {}", (Object)bundleLocation, (Object)groupName);
                }
                for (String id : bundleToStart) {
                    String[] tokens = id.split("/");
                    String string = tokens[0];
                    String version = tokens[1];
                    try {
                        LOGGER.debug("CELLAR BUNDLE: starting bundle {}/{} on node", (Object)string, (Object)version);
                        this.startBundle(string, version);
                    }
                    catch (BundleException e) {
                        this.resolveBundleException(id, e);
                    }
                }
                if (CellarUtils.doCleanupResourcesNotPresentInCluster((ConfigurationAdmin)this.configurationAdmin) && this.getSynchronizerMap().containsKey("org.apache.karaf.cellar.bundle.map." + groupName)) {
                    for (Iterator iterator : this.bundleContext.getBundles()) {
                        String id = this.getId((Bundle)iterator);
                        if (clusterBundles.containsKey(id) || !this.isAllowed(group, "bundle", iterator.getLocation(), EventType.INBOUND).booleanValue()) continue;
                        try {
                            LOGGER.debug("CELLAR BUNDLE: uninstalling local bundle {} which is not present in cluster", (Object)id);
                            iterator.uninstall();
                        }
                        catch (Exception e) {
                            LOGGER.warn("Can't uninstall {}", (Object)id, (Object)e);
                        }
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Group group) {
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.warn("CELLAR BUNDLE: cluster event producer is OFF");
            return;
        }
        if (group != null) {
            String groupName = group.getName();
            LOGGER.debug("CELLAR BUNDLE: pushing bundles to cluster group {}", (Object)groupName);
            Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + groupName);
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                BundleContext bundleContext = ((BundleReference)((Object)((Object)this)).getClass().getClassLoader()).getBundle().getBundleContext();
                Bundle[] bundles = bundleContext.getBundles();
                for (Bundle bundle : bundles) {
                    long bundleId = bundle.getBundleId();
                    String symbolicName = bundle.getSymbolicName();
                    String version = (String)bundle.getHeaders().get("Bundle-Version");
                    String bundleLocation = bundle.getLocation();
                    int status = bundle.getState();
                    int level = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
                    String id = this.getId(bundle);
                    if (this.isAllowed(group, "bundle", bundleLocation, EventType.OUTBOUND).booleanValue()) {
                        BundleState bundleState;
                        if (!clusterBundles.containsKey(id)) {
                            LOGGER.debug("CELLAR BUNDLE: deploying bundle {} on the cluster", (Object)id);
                            bundleState = new BundleState();
                            String name = (String)bundle.getHeaders().get("Bundle-Name");
                            name = name == null ? symbolicName : name;
                            name = name == null ? bundle.getLocation() : name;
                            bundleState.setId(bundleId);
                            bundleState.setName(name);
                            bundleState.setStartLevel(level);
                            bundleState.setSymbolicName(symbolicName);
                            bundleState.setVersion(version);
                            bundleState.setLocation(bundleLocation);
                            bundleState.setStatus(status);
                            clusterBundles.put(id, bundleState);
                            ClusterBundleEvent clusterEvent = new ClusterBundleEvent(symbolicName, version, bundleLocation, level, status);
                            clusterEvent.setSourceGroup(group);
                            clusterEvent.setSourceNode(this.clusterManager.getNode());
                            clusterEvent.setLocal(this.clusterManager.getNode());
                            this.eventProducer.produce((Event)clusterEvent);
                            continue;
                        }
                        bundleState = (BundleState)clusterBundles.get(id);
                        if (bundleState.getStatus() == status) continue;
                        LOGGER.debug("CELLAR BUNDLE: updating bundle id: {}, name: {}, location: {} status: {} on the cluster", new Object[]{id, symbolicName, bundleLocation, status});
                        bundleState.setStatus(status);
                        clusterBundles.put(id, bundleState);
                        ClusterBundleEvent clusterEvent = new ClusterBundleEvent(symbolicName, version, bundleLocation, level, status);
                        clusterEvent.setSourceGroup(group);
                        clusterEvent.setSourceNode(this.clusterManager.getNode());
                        clusterEvent.setLocal(this.clusterManager.getNode());
                        this.eventProducer.produce((Event)clusterEvent);
                        continue;
                    }
                    LOGGER.trace("CELLAR BUNDLE: bundle {} is marked BLOCKED OUTBOUND for cluster group {}", (Object)bundleLocation, (Object)groupName);
                }
                for (Map.Entry entry : clusterBundles.entrySet()) {
                    String id = (String)entry.getKey();
                    BundleState state = (BundleState)entry.getValue();
                    if (state == null || !this.isAllowed(group, "bundle", state.getLocation(), EventType.OUTBOUND).booleanValue()) continue;
                    boolean found = false;
                    for (Bundle bundle : bundleContext.getBundles()) {
                        String localBundleId = this.getId(bundle);
                        if (!id.equals(localBundleId)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    clusterBundles.remove(id);
                }
                this.getSynchronizerMap().putIfAbsent("org.apache.karaf.cellar.bundle.map." + groupName, true);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    private String getId(Bundle bundle) {
        String symbolicName = bundle.getSymbolicName();
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        return symbolicName + "/" + version;
    }

    public String getSyncPolicy(Group group) {
        String groupName = group.getName();
        try {
            String propertyKey;
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.groups", null);
            Dictionary properties = configuration.getProperties();
            if (properties != null && properties.get(propertyKey = groupName + "." + "bundle" + "." + "sync") != null) {
                return properties.get(propertyKey).toString();
            }
        }
        catch (IOException e) {
            LOGGER.error("CELLAR BUNDLE: error while retrieving the sync policy", (Throwable)e);
        }
        return null;
    }

    private void resolveBundleException(String id, BundleException e) {
        if (4 == e.getType()) {
            LOGGER.warn("CELLAR BUNDLE: Bundle {} has unresolved dependencies and won't be started now", (Object)id);
            LOGGER.debug("CELLAR BUNDLE: Error while starting bundle {}.", (Object)id, (Object)e);
        } else {
            LOGGER.error("CELLAR BUNDLE: failed to pull bundle {}", (Object)id, (Object)e);
        }
    }
}

