/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.concurrent.atomic.AtomicLong;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import org.javamoney.moneta.function.ExtractorMajorPartOperator;
import org.javamoney.moneta.function.ExtractorMajorPartQuery;
import org.javamoney.moneta.function.ExtractorMinorPartOperator;
import org.javamoney.moneta.function.ExtractorMinorPartQuery;
import org.javamoney.moneta.function.PercentOperator;
import org.javamoney.moneta.function.PermilOperator;
import org.javamoney.moneta.function.ReciprocalOperator;

@Deprecated
public final class MonetaryUtil {
    private static final MathContext DEFAULT_MATH_CONTEXT = MonetaryUtil.initDefaultMathContext();
    private static final ReciprocalOperator RECIPROCAL = new ReciprocalOperator();
    private static final ExtractorMinorPartOperator MINORPART = new ExtractorMinorPartOperator();
    private static final ExtractorMinorPartQuery MINORUNITS = new ExtractorMinorPartQuery();
    private static final ExtractorMajorPartOperator MAJORPART = new ExtractorMajorPartOperator();
    private static final ExtractorMajorPartQuery MAJORUNITS = new ExtractorMajorPartQuery();

    private MonetaryUtil() {
    }

    private static MathContext initDefaultMathContext() {
        return MathContext.DECIMAL64;
    }

    public static MonetaryOperator reciprocal() {
        return RECIPROCAL;
    }

    public static MonetaryOperator permil(BigDecimal decimal) {
        return new PermilOperator(decimal);
    }

    public static MonetaryOperator permil(Number number) {
        return MonetaryUtil.permil(number, DEFAULT_MATH_CONTEXT);
    }

    public static MonetaryOperator permil(Number number, MathContext mathContext) {
        return new PermilOperator(MonetaryUtil.getBigDecimal(number, mathContext));
    }

    public static MonetaryOperator percent(BigDecimal decimal) {
        return new PercentOperator(decimal);
    }

    public static MonetaryOperator percent(Number number) {
        return MonetaryUtil.percent(MonetaryUtil.getBigDecimal(number, DEFAULT_MATH_CONTEXT));
    }

    public static MonetaryOperator minorPart() {
        return MINORPART;
    }

    public static MonetaryOperator majorPart() {
        return MAJORPART;
    }

    public static MonetaryQuery<Long> minorUnits() {
        return MINORUNITS;
    }

    public static MonetaryQuery<Long> majorUnits() {
        return MAJORUNITS;
    }

    private static BigDecimal getBigDecimal(Number num, MathContext mathContext) {
        if (num instanceof BigDecimal) {
            return (BigDecimal)num;
        }
        if (num instanceof Long || num instanceof Integer || num instanceof Byte || num instanceof AtomicLong) {
            return BigDecimal.valueOf(num.longValue());
        }
        if (num instanceof Float || num instanceof Double) {
            return new BigDecimal(num.toString());
        }
        try {
            return new BigDecimal(num.toString(), mathContext);
        }
        catch (NumberFormatException numberFormatException) {
            return BigDecimal.valueOf(num.doubleValue());
        }
    }
}

