/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject.field;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.felix.scr.impl.inject.BindParameters;
import org.apache.felix.scr.impl.inject.ClassUtils;
import org.apache.felix.scr.impl.inject.InitReferenceMethod;
import org.apache.felix.scr.impl.inject.MethodResult;
import org.apache.felix.scr.impl.inject.ReferenceMethod;
import org.apache.felix.scr.impl.inject.ValueUtils;
import org.apache.felix.scr.impl.inject.field.FieldUtils;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.osgi.framework.BundleContext;

public class FieldHandler {
    private final ReferenceMetadata metadata;
    private final Class<?> componentClass;
    private volatile Field field;
    private volatile ValueUtils.ValueType valueType;
    private volatile State state;

    public FieldHandler(ReferenceMetadata metadata, Class<?> componentClass) {
        this.metadata = metadata;
        this.componentClass = componentClass;
        this.state = NotResolved.INSTANCE;
    }

    private boolean initField(Object componentInstance, ComponentLogger logger) {
        if (this.valueType == ValueUtils.ValueType.ignore) {
            return true;
        }
        try {
            if (this.metadata.isMultiple()) {
                if (this.metadata.isReplace()) {
                    this.setFieldValue(componentInstance, new CopyOnWriteArrayList());
                } else {
                    Class<?> fieldType = this.field.getType();
                    Object providedImpl = this.getFieldValue(componentInstance);
                    if (providedImpl == null) {
                        if (Modifier.isFinal(this.field.getModifiers())) {
                            logger.log(1, "Field {0} in class {1} must not be declared as final", null, this.metadata.getField(), this.componentClass);
                            this.valueType = ValueUtils.ValueType.ignore;
                            return true;
                        }
                        if (fieldType != ClassUtils.LIST_CLASS && fieldType != ClassUtils.COLLECTION_CLASS) {
                            logger.log(1, "Field {0} in class {1} has unsupported type {2}. It must be one of java.util.Collection or java.util.List.", null, this.metadata.getField(), this.componentClass, fieldType.getName());
                            this.valueType = ValueUtils.ValueType.ignore;
                            return true;
                        }
                        if (fieldType == ClassUtils.LIST_CLASS) {
                            this.setFieldValue(componentInstance, new CopyOnWriteArrayList());
                        } else {
                            this.setFieldValue(componentInstance, new CopyOnWriteArraySet());
                        }
                    }
                }
            } else if (this.metadata.isOptional()) {
                this.setFieldValue(componentInstance, null);
            }
        }
        catch (InvocationTargetException ite) {
            this.valueType = ValueUtils.ValueType.ignore;
            logger.log(1, "Field {0} in class {1} can't be initialized.", ite, this.metadata.getField(), this.componentClass);
            return false;
        }
        return true;
    }

    private Collection<Object> getReplaceCollection(BindParameters bp) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object val : bp.getComponentContext().getBoundValues(this.metadata.getName()).values()) {
            objects.add(val);
        }
        return objects;
    }

    private MethodResult updateField(METHOD_TYPE mType, Object componentInstance, BindParameters bp) throws InvocationTargetException {
        ComponentContextImpl<?> key = bp.getComponentContext();
        RefPair refPair = bp.getRefPair();
        if (!this.metadata.isMultiple()) {
            if (mType == METHOD_TYPE.UNBIND) {
                if (this.metadata.isOptional() && !this.metadata.isStatic() && bp.getComponentContext().getBoundValues(this.metadata.getName()).size() == 1) {
                    this.setFieldValue(componentInstance, null);
                }
                bp.getComponentContext().getBoundValues(this.metadata.getName()).remove(refPair);
            } else if (mType == METHOD_TYPE.UPDATED) {
                if (this.valueType == ValueUtils.ValueType.ref_map || this.valueType == ValueUtils.ValueType.ref_tuple) {
                    if (this.metadata.isStatic()) {
                        return MethodResult.REACTIVATE;
                    }
                    Object obj = ValueUtils.getValue(componentInstance.getClass().getName(), this.valueType, this.field.getType(), key, refPair);
                    this.setFieldValue(componentInstance, obj);
                    bp.getComponentContext().getBoundValues(this.metadata.getName()).put(refPair, obj);
                }
            } else {
                Object obj = ValueUtils.getValue(componentInstance.getClass().getName(), this.valueType, this.field.getType(), key, refPair);
                this.setFieldValue(componentInstance, obj);
                bp.getComponentContext().getBoundValues(this.metadata.getName()).put(refPair, obj);
            }
        } else if (mType == METHOD_TYPE.BIND) {
            Object obj = ValueUtils.getValue(componentInstance.getClass().getName(), this.valueType, this.field.getType(), key, refPair);
            bp.getComponentContext().getBoundValues(this.metadata.getName()).put(refPair, obj);
            if (this.metadata.isReplace()) {
                this.setFieldValue(componentInstance, this.getReplaceCollection(bp));
            } else {
                Collection col = (Collection)this.getFieldValue(componentInstance);
                col.add(obj);
            }
        } else if (mType == METHOD_TYPE.UNBIND) {
            if (!this.metadata.isStatic()) {
                Object obj = bp.getComponentContext().getBoundValues(this.metadata.getName()).remove(refPair);
                if (this.metadata.isReplace()) {
                    this.setFieldValue(componentInstance, this.getReplaceCollection(bp));
                } else {
                    Collection col = (Collection)this.getFieldValue(componentInstance);
                    col.remove(obj);
                }
            }
        } else if (mType == METHOD_TYPE.UPDATED && (this.valueType == ValueUtils.ValueType.ref_map || this.valueType == ValueUtils.ValueType.ref_tuple)) {
            if (!this.metadata.isStatic()) {
                Object obj = ValueUtils.getValue(componentInstance.getClass().getName(), this.valueType, this.field.getType(), key, refPair);
                Object oldObj = bp.getComponentContext().getBoundValues(this.metadata.getName()).put(refPair, obj);
                if (this.metadata.isReplace()) {
                    this.setFieldValue(componentInstance, this.getReplaceCollection(bp));
                } else {
                    Collection col = (Collection)this.getFieldValue(componentInstance);
                    col.add(obj);
                    col.remove(oldObj);
                }
            } else {
                return MethodResult.REACTIVATE;
            }
        }
        return MethodResult.VOID;
    }

    private void setFieldValue(Object componentInstance, Object value) throws InvocationTargetException {
        try {
            this.field.set(componentInstance, value);
        }
        catch (IllegalArgumentException iae) {
            throw new InvocationTargetException(iae);
        }
        catch (IllegalAccessException iae) {
            throw new InvocationTargetException(iae);
        }
    }

    private Object getFieldValue(Object componentInstance) throws InvocationTargetException {
        try {
            return this.field.get(componentInstance);
        }
        catch (IllegalArgumentException iae) {
            throw new InvocationTargetException(iae);
        }
        catch (IllegalAccessException iae) {
            throw new InvocationTargetException(iae);
        }
    }

    public boolean fieldExists(ComponentLogger logger) {
        return this.state.fieldExists(this, logger);
    }

    synchronized void setSearchResult(FieldUtils.FieldSearchResult result, ComponentLogger logger) {
        if (result == null) {
            this.field = null;
            this.valueType = null;
            this.state = NotFound.INSTANCE;
            logger.log(1, "Field [{0}] not found; Component will fail", null, this.metadata.getField());
        } else {
            this.field = result.field;
            this.valueType = !result.usable ? ValueUtils.ValueType.ignore : ValueUtils.getReferenceValueType(this.componentClass, this.metadata, result.field.getType(), result.field, logger);
            this.state = Resolved.INSTANCE;
            logger.log(4, "Found field: {0}", null, result.field);
        }
    }

    public ReferenceMethod getBind() {
        return new ReferenceMethodImpl(METHOD_TYPE.BIND, this);
    }

    public ReferenceMethod getUnbind() {
        return new ReferenceMethodImpl(METHOD_TYPE.UNBIND, this);
    }

    public ReferenceMethod getUpdated() {
        return new ReferenceMethodImpl(METHOD_TYPE.UPDATED, this);
    }

    public InitReferenceMethod getInit() {
        if (this.valueType == ValueUtils.ValueType.ignore) {
            return null;
        }
        return new InitReferenceMethod(){

            @Override
            public boolean init(Object componentInstance, ComponentLogger logger) {
                if (FieldHandler.this.fieldExists(logger)) {
                    return FieldHandler.this.initField(componentInstance, logger);
                }
                return false;
            }
        };
    }

    public static final class ReferenceMethodImpl
    implements ReferenceMethod {
        private final METHOD_TYPE methodType;
        private final FieldHandler handler;

        public ReferenceMethodImpl(METHOD_TYPE mt, FieldHandler handler) {
            this.methodType = mt;
            this.handler = handler;
        }

        @Override
        public <S, T> MethodResult invoke(Object componentInstance, BindParameters rawParameter, MethodResult methodCallFailureResult) {
            if (this.handler.valueType == ValueUtils.ValueType.ignore) {
                return MethodResult.VOID;
            }
            try {
                return this.handler.state.invoke(this.handler, this.methodType, componentInstance, rawParameter);
            }
            catch (InvocationTargetException ite) {
                rawParameter.getComponentContext().getLogger().log(1, "The {0} field has thrown an exception", null, this.handler.metadata.getField());
                return methodCallFailureResult;
            }
        }

        @Override
        public <S, T> boolean getServiceObject(BindParameters rawParameter, BundleContext context) {
            if (this.methodType != METHOD_TYPE.UNBIND && rawParameter.getServiceObject() == null && this.handler.fieldExists(rawParameter.getComponentContext().getLogger()) && (this.handler.valueType == ValueUtils.ValueType.ref_serviceType || this.handler.valueType == ValueUtils.ValueType.ref_tuple || this.handler.valueType == ValueUtils.ValueType.ref_logger || this.handler.valueType == ValueUtils.ValueType.ref_formatterLogger)) {
                return rawParameter.getServiceObject(context);
            }
            return true;
        }
    }

    private static class Resolved
    implements State {
        private static final State INSTANCE = new Resolved();

        private Resolved() {
        }

        @Override
        public MethodResult invoke(FieldHandler handler, METHOD_TYPE mType, Object componentInstance, BindParameters rawParameter) throws InvocationTargetException {
            return handler.updateField(mType, componentInstance, rawParameter);
        }

        @Override
        public boolean fieldExists(FieldHandler handler, ComponentLogger logger) {
            return true;
        }
    }

    private static class NotFound
    implements State {
        private static final State INSTANCE = new NotFound();

        private NotFound() {
        }

        @Override
        public MethodResult invoke(FieldHandler handler, METHOD_TYPE mType, Object componentInstance, BindParameters rawParameter) {
            rawParameter.getComponentContext().getLogger().log(1, "Field [{0}] not found", null, handler.metadata.getField());
            return null;
        }

        @Override
        public boolean fieldExists(FieldHandler handler, ComponentLogger logger) {
            return false;
        }
    }

    private static class NotResolved
    implements State {
        private static final State INSTANCE = new NotResolved();

        private NotResolved() {
        }

        private void resolve(FieldHandler handler, ComponentLogger logger) {
            logger.log(4, "getting field: {0}", null, handler.metadata.getField());
            FieldUtils.FieldSearchResult result = FieldUtils.searchField(handler.componentClass, handler.metadata.getField(), logger);
            handler.setSearchResult(result, logger);
        }

        @Override
        public MethodResult invoke(FieldHandler handler, METHOD_TYPE mType, Object componentInstance, BindParameters rawParameter) throws InvocationTargetException {
            this.resolve(handler, rawParameter.getComponentContext().getLogger());
            return handler.state.invoke(handler, mType, componentInstance, rawParameter);
        }

        @Override
        public boolean fieldExists(FieldHandler handler, ComponentLogger logger) {
            this.resolve(handler, logger);
            return handler.state.fieldExists(handler, logger);
        }
    }

    private static interface State {
        public MethodResult invoke(FieldHandler var1, METHOD_TYPE var2, Object var3, BindParameters var4) throws InvocationTargetException;

        public boolean fieldExists(FieldHandler var1, ComponentLogger var2);
    }

    private static enum METHOD_TYPE {
        BIND,
        UNBIND,
        UPDATED;

    }
}

