/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Field;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.ParameterConfiguration;
import org.apache.camel.impl.UriComponentConfiguration;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class UriEndpointComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(UriEndpointComponent.class);
    private Class<? extends Endpoint> endpointClass;
    private SortedMap<String, ParameterConfiguration> parameterConfigurationMap;

    public UriEndpointComponent(Class<? extends Endpoint> endpointClass) {
        this.endpointClass = endpointClass;
    }

    public UriEndpointComponent(CamelContext context, Class<? extends Endpoint> endpointClass) {
        super(context);
        this.endpointClass = endpointClass;
    }

    public void setEndpointClass(Class<? extends Endpoint> endpointClass) {
        this.endpointClass = endpointClass;
    }

    @Override
    public ComponentConfiguration createComponentConfiguration() {
        return new UriComponentConfiguration(this);
    }

    public static SortedMap<String, ParameterConfiguration> createParameterConfigurationMap(Class<? extends Endpoint> endpointClass) {
        TreeMap<String, ParameterConfiguration> answer = new TreeMap<String, ParameterConfiguration>();
        UriEndpointComponent.populateParameterConfigurationMap(answer, endpointClass, "");
        return answer;
    }

    protected static void populateParameterConfigurationMap(final SortedMap<String, ParameterConfiguration> parameterMap, Class<?> aClass, final String prefix) {
        ReflectionHelper.doWithFields(aClass, new ReflectionHelper.FieldCallback(){

            @Override
            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                UriParam uriParam = field.getAnnotation(UriParam.class);
                if (uriParam != null) {
                    String name = uriParam.name();
                    if (ObjectHelper.isEmpty(name)) {
                        name = field.getName();
                    }
                    String propertyName = prefix + name;
                    Class<?> fieldType = field.getType();
                    UriParams uriParams = fieldType.getAnnotation(UriParams.class);
                    if (uriParams != null) {
                        String nestedPrefix = uriParams.prefix();
                        if (nestedPrefix == null) {
                            nestedPrefix = "";
                        }
                        nestedPrefix = (prefix + nestedPrefix).trim();
                        UriEndpointComponent.populateParameterConfigurationMap(parameterMap, fieldType, nestedPrefix);
                    } else if (parameterMap.containsKey(propertyName)) {
                        LOG.warn("Duplicate property name " + propertyName + " defined on field " + field);
                    } else {
                        parameterMap.put(propertyName, ParameterConfiguration.newInstance(propertyName, field, uriParam));
                    }
                }
            }
        });
    }

    public Class<? extends Endpoint> getEndpointClass() {
        return this.endpointClass;
    }

    public SortedMap<String, ParameterConfiguration> getParameterConfigurationMap() {
        if (this.parameterConfigurationMap == null) {
            this.parameterConfigurationMap = UriEndpointComponent.createParameterConfigurationMap(this.getEndpointClass());
        }
        return new TreeMap<String, ParameterConfiguration>(this.parameterConfigurationMap);
    }
}

