/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.services;

import java.util.List;
import java.util.UUID;
import org.apache.unomi.api.Item;
import org.apache.unomi.router.api.ExportConfiguration;
import org.apache.unomi.router.api.IRouterCamelContext;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;
import org.apache.unomi.router.services.AbstractConfigurationServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportConfigurationServiceImpl
extends AbstractConfigurationServiceImpl
implements ImportExportConfigurationService<ExportConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger((String)ExportConfigurationServiceImpl.class.getName());

    public ExportConfigurationServiceImpl() {
        logger.info("Initializing export configuration service...");
    }

    public List<ExportConfiguration> getAll() {
        return this.persistenceService.getAllItems(ExportConfiguration.class);
    }

    public ExportConfiguration load(String configId) {
        return (ExportConfiguration)this.persistenceService.load(configId, ExportConfiguration.class);
    }

    public ExportConfiguration save(ExportConfiguration exportConfiguration, boolean updateRunningRoute) {
        if (exportConfiguration.getItemId() == null) {
            exportConfiguration.setItemId(UUID.randomUUID().toString());
        }
        if (updateRunningRoute) {
            try {
                this.routerCamelContext.updateProfileReaderRoute((Object)exportConfiguration, true);
            }
            catch (Exception e) {
                logger.error("Error when trying to save/update running Apache Camel Route: {}", (Object)exportConfiguration.getItemId());
            }
        }
        this.persistenceService.save((Item)exportConfiguration);
        return (ExportConfiguration)this.persistenceService.load(exportConfiguration.getItemId(), ExportConfiguration.class);
    }

    public void delete(String configId) {
        try {
            this.routerCamelContext.killExistingRoute(configId, true);
        }
        catch (Exception e) {
            logger.error("Error when trying to delete running Apache Camel Route: {}", (Object)configId);
        }
        this.persistenceService.remove(configId, ExportConfiguration.class);
    }

    @Override
    public void setRouterCamelContext(IRouterCamelContext routerCamelContext) {
        super.setRouterCamelContext(routerCamelContext);
    }
}

