/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.api.services.RulesService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;

@Command(scope="unomi", name="rule-view", description="This will allows to view a rule in the Apache Unomi Context Server")
@Service
public class RuleView
implements Action {
    @Reference
    RulesService rulesService;
    @Argument(index=0, name="rule", description="The identifier for the rule", required=true, multiValued=false)
    String ruleIdentifier;

    public Object execute() throws Exception {
        Rule rule = this.rulesService.getRule(this.ruleIdentifier);
        if (rule == null) {
            System.out.println("Couldn't find a rule with id=" + this.ruleIdentifier);
            return null;
        }
        String jsonRule = CustomObjectMapper.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)rule);
        System.out.println(jsonRule);
        return null;
    }
}

