/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.personalization;

import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlGroup {
    private static final Logger logger = LoggerFactory.getLogger((String)ControlGroup.class.getName());
    String id;
    String displayName;
    String path;
    Date timeStamp;

    public ControlGroup(String id, String displayName, String path, Date timeStamp) {
        this.id = id;
        this.displayName = displayName;
        this.path = path;
        this.timeStamp = timeStamp;
    }

    public static ControlGroup fromMap(Map<String, Object> map) {
        String id = (String)map.get("id");
        String displayName = (String)map.get("displayName");
        String path = (String)map.get("path");
        String dateStr = (String)map.get("timeStamp");
        Date date = null;
        try {
            date = CustomObjectMapper.getObjectMapper().getDateFormat().parse(dateStr);
        }
        catch (ParseException e) {
            logger.error("Error parsing control group date", (Throwable)e);
        }
        return new ControlGroup(id, displayName, path, date);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("id", this.id);
        result.put("displayName", this.displayName);
        result.put("path", this.path);
        result.put("timeStamp", CustomObjectMapper.getObjectMapper().getDateFormat().format(this.timeStamp));
        return result;
    }
}

