/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.ContentTypes;
import groovyx.net.http.FromServer;
import groovyx.net.http.HttpConfig;
import groovyx.net.http.HttpVerb;
import groovyx.net.http.NativeHandlers;
import groovyx.net.http.Safe;
import groovyx.net.http.ToServer;
import groovyx.net.http.TransportingException;
import groovyx.net.http.UriBuilder;
import groovyx.net.http.optional.Csv;
import groovyx.net.http.optional.Html;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class HttpConfigs {
    private static final ThreadSafeHttpConfig root = (ThreadSafeHttpConfig)new ThreadSafeHttpConfig(null).configure();

    public static ChainedHttpConfig root() {
        return root;
    }

    public static ChainedHttpConfig threadSafe(ChainedHttpConfig parent) {
        return new ThreadSafeHttpConfig(parent);
    }

    public static ChainedHttpConfig classLevel(boolean threadSafe) {
        return threadSafe ? HttpConfigs.threadSafe(root) : HttpConfigs.basic(root);
    }

    public static ChainedHttpConfig basic(ChainedHttpConfig parent) {
        return new BasicHttpConfig(parent);
    }

    public static BasicHttpConfig requestLevel(ChainedHttpConfig parent) {
        return new BasicHttpConfig(parent);
    }

    static {
        Safe.register((HttpConfig)root, Safe.ifClassIsLoaded("org.cyberneko.html.parsers.SAXParser"), "text/html", () -> NativeHandlers.Encoders::xml, Html.neckoParserSupplier);
        Safe.register((HttpConfig)root, Safe.ifClassIsLoaded("org.jsoup.Jsoup"), "text/html", Html.jsoupEncoderSupplier, Html.jsoupParserSupplier);
        if (Safe.register((HttpConfig)root, Safe.ifClassIsLoaded("com.opencsv.CSVReader"), "text/csv", Csv.encoderSupplier, Csv.parserSupplier)) {
            root.context("text/csv", (Object)"3DOJ0FPjyD4GwLmpMjrCYnNJK60=", (Object)Csv.Context.DEFAULT_CSV);
        }
        if (Safe.register((HttpConfig)root, Safe.ifClassIsLoaded("com.opencsv.CSVReader"), "text/tab-separated-values", Csv.encoderSupplier, Csv.parserSupplier)) {
            root.context("text/tab-separated-values", (Object)"3DOJ0FPjyD4GwLmpMjrCYnNJK60=", (Object)Csv.Context.DEFAULT_TSV);
        }
    }

    public static class BasicHttpConfig
    extends BaseHttpConfig {
        private final BasicRequest request;
        private final BasicResponse response;
        private final Map<Map.Entry<String, Object>, Object> contextMap = new LinkedHashMap<Map.Entry<String, Object>, Object>(1);

        public BasicHttpConfig(ChainedHttpConfig parent) {
            super(parent);
            if (parent == null) {
                this.request = new BasicRequest(null);
                this.response = new BasicResponse(null);
            } else {
                this.request = new BasicRequest(parent.getChainedRequest());
                this.response = new BasicResponse(parent.getChainedResponse());
            }
        }

        @Override
        public BasicRequest getRequest() {
            return this.request;
        }

        @Override
        public BasicResponse getResponse() {
            return this.response;
        }

        @Override
        public BasicRequest getChainedRequest() {
            return this.request;
        }

        @Override
        public BasicResponse getChainedResponse() {
            return this.response;
        }

        @Override
        public Map<Map.Entry<String, Object>, Object> getContextMap() {
            return this.contextMap;
        }
    }

    public static class ThreadSafeHttpConfig
    extends BaseHttpConfig {
        private final ThreadSafeRequest request;
        private final ThreadSafeResponse response;
        private final ConcurrentMap<Map.Entry<String, Object>, Object> contextMap = new ConcurrentHashMap<Map.Entry<String, Object>, Object>();

        public ThreadSafeHttpConfig(ChainedHttpConfig parent) {
            super(parent);
            if (parent == null) {
                this.request = new ThreadSafeRequest(null);
                this.response = new ThreadSafeResponse(null);
            } else {
                this.request = new ThreadSafeRequest(parent.getChainedRequest());
                this.response = new ThreadSafeResponse(parent.getChainedResponse());
            }
        }

        @Override
        public HttpConfig.Request getRequest() {
            return this.request;
        }

        @Override
        public HttpConfig.Response getResponse() {
            return this.response;
        }

        @Override
        public ChainedHttpConfig.ChainedRequest getChainedRequest() {
            return this.request;
        }

        @Override
        public ChainedHttpConfig.ChainedResponse getChainedResponse() {
            return this.response;
        }

        @Override
        public Map<Map.Entry<String, Object>, Object> getContextMap() {
            return this.contextMap;
        }
    }

    public static abstract class BaseHttpConfig
    implements ChainedHttpConfig {
        private final ChainedHttpConfig parent;

        public BaseHttpConfig(ChainedHttpConfig parent) {
            this.parent = parent;
        }

        @Override
        public ChainedHttpConfig getParent() {
            return this.parent;
        }

        public ChainedHttpConfig configure() {
            this.getRequest().setCharset(StandardCharsets.UTF_8);
            this.getRequest().encoder(ContentTypes.BINARY, NativeHandlers.Encoders::binary);
            this.getRequest().encoder(ContentTypes.TEXT, (f, s) -> {
                try {
                    NativeHandlers.Encoders.text(f, s);
                }
                catch (IOException e) {
                    throw new TransportingException(e);
                }
            });
            this.getRequest().encoder(ContentTypes.URLENC, NativeHandlers.Encoders::form);
            this.getRequest().encoder(ContentTypes.XML, NativeHandlers.Encoders::xml);
            this.getRequest().encoder(ContentTypes.JSON, NativeHandlers.Encoders::json);
            this.getResponse().success(NativeHandlers::success);
            this.getResponse().failure(NativeHandlers::failure);
            this.getResponse().exception(NativeHandlers::exception);
            this.getResponse().parser(ContentTypes.BINARY, NativeHandlers.Parsers::streamToBytes);
            this.getResponse().parser(ContentTypes.TEXT, NativeHandlers.Parsers::textToString);
            this.getResponse().parser(ContentTypes.URLENC, NativeHandlers.Parsers::form);
            this.getResponse().parser(ContentTypes.XML, NativeHandlers.Parsers::xml);
            this.getResponse().parser(ContentTypes.JSON, NativeHandlers.Parsers::json);
            return this;
        }

        @Override
        public void context(String contentType, Object id, Object obj) {
            this.getContextMap().put(new AbstractMap.SimpleImmutableEntry<String, Object>(contentType, id), obj);
        }
    }

    public static class ThreadSafeResponse
    extends BaseResponse {
        private final ConcurrentMap<String, BiFunction<ChainedHttpConfig, FromServer, Object>> parserMap = new ConcurrentHashMap<String, BiFunction<ChainedHttpConfig, FromServer, Object>>();
        private final ConcurrentMap<Integer, BiFunction<FromServer, Object, ?>> byCode = new ConcurrentHashMap();
        private volatile BiFunction<FromServer, Object, ?> successHandler;
        private volatile BiFunction<FromServer, Object, ?> failureHandler;
        private volatile Function<Throwable, ?> exceptionHandler;
        private volatile Class<?> type = Object.class;

        public ThreadSafeResponse(ChainedHttpConfig.ChainedResponse parent) {
            super(parent);
        }

        @Override
        protected Map<String, BiFunction<ChainedHttpConfig, FromServer, Object>> getParserMap() {
            return this.parserMap;
        }

        @Override
        protected Map<Integer, BiFunction<FromServer, Object, ?>> getByCode() {
            return this.byCode;
        }

        @Override
        protected BiFunction<FromServer, Object, ?> getSuccess() {
            return this.successHandler;
        }

        @Override
        protected BiFunction<FromServer, Object, ?> getFailure() {
            return this.failureHandler;
        }

        @Override
        public Function<Throwable, ?> getException() {
            return this.exceptionHandler;
        }

        @Override
        public void success(BiFunction<FromServer, Object, ?> val) {
            this.successHandler = val;
        }

        @Override
        public void failure(BiFunction<FromServer, Object, ?> val) {
            this.failureHandler = val;
        }

        @Override
        public void exception(Function<Throwable, ?> val) {
            this.exceptionHandler = val;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public void setType(Class<?> val) {
            this.type = val;
        }
    }

    public static class BasicResponse
    extends BaseResponse {
        private final Map<Integer, BiFunction<FromServer, Object, ?>> byCode = new LinkedHashMap();
        private BiFunction<FromServer, Object, ?> successHandler;
        private BiFunction<FromServer, Object, ?> failureHandler;
        private Function<Throwable, ?> exceptionHandler;
        private final Map<String, BiFunction<ChainedHttpConfig, FromServer, Object>> parserMap = new LinkedHashMap<String, BiFunction<ChainedHttpConfig, FromServer, Object>>();
        private Class<?> type = Object.class;

        protected BasicResponse(ChainedHttpConfig.ChainedResponse parent) {
            super(parent);
        }

        @Override
        public Map<String, BiFunction<ChainedHttpConfig, FromServer, Object>> getParserMap() {
            return this.parserMap;
        }

        @Override
        protected Map<Integer, BiFunction<FromServer, Object, ?>> getByCode() {
            return this.byCode;
        }

        @Override
        protected BiFunction<FromServer, Object, ?> getSuccess() {
            return this.successHandler;
        }

        @Override
        protected BiFunction<FromServer, Object, ?> getFailure() {
            return this.failureHandler;
        }

        @Override
        public Function<Throwable, ?> getException() {
            return this.exceptionHandler;
        }

        @Override
        public void success(BiFunction<FromServer, Object, ?> val) {
            this.successHandler = val;
        }

        @Override
        public void failure(BiFunction<FromServer, Object, ?> val) {
            this.failureHandler = val;
        }

        @Override
        public void exception(Function<Throwable, ?> val) {
            this.exceptionHandler = val;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public void setType(Class<?> val) {
            this.type = val;
        }
    }

    public static abstract class BaseResponse
    implements ChainedHttpConfig.ChainedResponse {
        private final ChainedHttpConfig.ChainedResponse parent;

        protected abstract Map<Integer, BiFunction<FromServer, Object, ?>> getByCode();

        protected abstract BiFunction<FromServer, Object, ?> getSuccess();

        protected abstract BiFunction<FromServer, Object, ?> getFailure();

        protected abstract Map<String, BiFunction<ChainedHttpConfig, FromServer, Object>> getParserMap();

        @Override
        public ChainedHttpConfig.ChainedResponse getParent() {
            return this.parent;
        }

        protected BaseResponse(ChainedHttpConfig.ChainedResponse parent) {
            this.parent = parent;
        }

        @Override
        public void when(String code, BiFunction<FromServer, Object, ?> closure) {
            this.when(Integer.valueOf(code), closure);
        }

        @Override
        public void when(Integer code, BiFunction<FromServer, Object, ?> closure) {
            this.getByCode().put(code, closure);
        }

        @Override
        public void when(HttpConfig.Status status, BiFunction<FromServer, Object, ?> closure) {
            if (status == HttpConfig.Status.SUCCESS) {
                this.success(closure);
            } else {
                this.failure(closure);
            }
        }

        @Override
        public BiFunction<FromServer, Object, ?> when(Integer code) {
            if (this.getByCode().containsKey(code)) {
                return this.getByCode().get(code);
            }
            if (code < 400 && this.getSuccess() != null) {
                return this.getSuccess();
            }
            if (code >= 400 && this.getFailure() != null) {
                return this.getFailure();
            }
            return null;
        }

        @Override
        public BiFunction<ChainedHttpConfig, FromServer, Object> parser(String contentType) {
            BiFunction<ChainedHttpConfig, FromServer, Object> p = this.getParserMap().get(contentType);
            return p != null ? p : null;
        }

        @Override
        public void parser(String contentType, BiFunction<ChainedHttpConfig, FromServer, Object> val) {
            this.getParserMap().put(contentType, val);
        }

        @Override
        public void parser(Iterable<String> contentTypes, BiFunction<ChainedHttpConfig, FromServer, Object> val) {
            for (String contentType : contentTypes) {
                this.parser(contentType, val);
            }
        }

        public abstract void setType(Class<?> var1);
    }

    public static class ThreadSafeRequest
    extends BaseRequest {
        private volatile String contentType;
        private volatile Charset charset;
        private volatile UriBuilder uriBuilder;
        private final ConcurrentMap<String, CharSequence> headers = new ConcurrentHashMap<String, CharSequence>();
        private volatile Object body;
        private final ConcurrentMap<String, BiConsumer<ChainedHttpConfig, ToServer>> encoderMap = new ConcurrentHashMap<String, BiConsumer<ChainedHttpConfig, ToServer>>();
        private final ThreadSafeAuth auth;
        private final List<HttpCookie> cookies = new CopyOnWriteArrayList<HttpCookie>();

        public ThreadSafeRequest(ChainedHttpConfig.ChainedRequest parent) {
            super(parent);
            this.auth = new ThreadSafeAuth();
            this.uriBuilder = parent == null ? UriBuilder.threadSafe(null) : UriBuilder.threadSafe(parent.getUri());
        }

        @Override
        public List<HttpCookie> getCookies() {
            return this.cookies;
        }

        @Override
        public Map<String, BiConsumer<ChainedHttpConfig, ToServer>> getEncoderMap() {
            return this.encoderMap;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public void setContentType(String val) {
            this.contentType = val;
        }

        @Override
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        public void setCharset(Charset val) {
            this.charset = val;
        }

        @Override
        public UriBuilder getUri() {
            return this.uriBuilder;
        }

        @Override
        public Map<String, CharSequence> getHeaders() {
            return this.headers;
        }

        @Override
        public Object getBody() {
            return this.body;
        }

        @Override
        public void setBody(Object val) {
            this.body = val;
        }

        @Override
        public ThreadSafeAuth getAuth() {
            return this.auth;
        }
    }

    public static class BasicRequest
    extends BaseRequest {
        private String contentType;
        private Charset charset;
        private UriBuilder uriBuilder;
        private final Map<String, CharSequence> headers = new LinkedHashMap<String, CharSequence>();
        private Object body;
        private final Map<String, BiConsumer<ChainedHttpConfig, ToServer>> encoderMap = new LinkedHashMap<String, BiConsumer<ChainedHttpConfig, ToServer>>();
        private BasicAuth auth = new BasicAuth();
        private List<HttpCookie> cookies = new ArrayList<HttpCookie>(1);

        protected BasicRequest(ChainedHttpConfig.ChainedRequest parent) {
            super(parent);
            this.uriBuilder = parent == null ? UriBuilder.basic(null) : UriBuilder.basic(parent.getUri());
        }

        @Override
        public Map<String, BiConsumer<ChainedHttpConfig, ToServer>> getEncoderMap() {
            return this.encoderMap;
        }

        @Override
        public List<HttpCookie> getCookies() {
            return this.cookies;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public void setContentType(String val) {
            this.contentType = val;
        }

        @Override
        public void setCharset(Charset val) {
            this.charset = val;
        }

        @Override
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        public UriBuilder getUri() {
            return this.uriBuilder;
        }

        @Override
        public Map<String, CharSequence> getHeaders() {
            return this.headers;
        }

        @Override
        public Object getBody() {
            return this.body;
        }

        @Override
        public void setBody(Object val) {
            this.body = val;
        }

        @Override
        public BasicAuth getAuth() {
            return this.auth;
        }
    }

    public static abstract class BaseRequest
    implements ChainedHttpConfig.ChainedRequest {
        final ChainedHttpConfig.ChainedRequest parent;
        HttpVerb verb;

        public BaseRequest(ChainedHttpConfig.ChainedRequest parent) {
            this.parent = parent;
        }

        @Override
        public ChainedHttpConfig.ChainedRequest getParent() {
            return this.parent;
        }

        @Override
        public void setCharset(String val) {
            this.setCharset(Charset.forName(val));
        }

        @Override
        public void setUri(String val) {
            this.getUri().setFull(val);
        }

        @Override
        public void setRaw(String val) {
            UriBuilder uriBuilder = this.getUri();
            uriBuilder.setUseRawValues(true);
            uriBuilder.setFull(val);
        }

        @Override
        public void setUri(URI val) {
            this.getUri().setFull(val);
        }

        @Override
        public void setUri(URL val) throws URISyntaxException {
            this.getUri().setFull(val.toURI());
        }

        @Override
        public BiConsumer<ChainedHttpConfig, ToServer> encoder(String contentType) {
            BiConsumer<ChainedHttpConfig, ToServer> enc = this.getEncoderMap().get(contentType);
            return enc != null ? enc : null;
        }

        @Override
        public void encoder(String contentType, BiConsumer<ChainedHttpConfig, ToServer> val) {
            this.getEncoderMap().put(contentType, val);
        }

        @Override
        public void encoder(Iterable<String> contentTypes, BiConsumer<ChainedHttpConfig, ToServer> val) {
            for (String contentType : contentTypes) {
                this.encoder(contentType, val);
            }
        }

        @Override
        public void setAccept(String[] values) {
            this.getHeaders().put("Accept", String.join((CharSequence)";", values));
        }

        @Override
        public void setAccept(Iterable<String> values) {
            this.getHeaders().put("Accept", String.join((CharSequence)";", values));
        }

        @Override
        public void setHeaders(Map<String, CharSequence> toAdd) {
            Map<String, CharSequence> h = this.getHeaders();
            if (toAdd != null) {
                for (Map.Entry<String, CharSequence> entry : toAdd.entrySet()) {
                    h.put(entry.getKey(), entry.getValue());
                }
            }
        }

        public void cookie(String name, String value, Instant instant) {
            HttpCookie cookie = new HttpCookie(name, value);
            cookie.setPath("/");
            Instant now = Instant.now();
            if (instant != null && now.isBefore(instant)) {
                cookie.setMaxAge(instant.getEpochSecond() - now.getEpochSecond());
            }
            this.getCookies().add(cookie);
        }

        @Override
        public void cookie(String name, String value, Date date) {
            this.cookie(name, value, date == null ? (Instant)null : date.toInstant());
        }

        @Override
        public void cookie(String name, String value, LocalDateTime dateTime) {
            this.cookie(name, value, dateTime == null ? (Instant)null : dateTime.atZone(ZoneId.systemDefault()).toInstant());
        }

        @Override
        public HttpVerb getVerb() {
            return this.verb;
        }

        @Override
        public void setVerb(HttpVerb verb) {
            this.verb = verb;
        }
    }

    public static class ThreadSafeAuth
    implements HttpConfig.Auth {
        volatile String user;
        volatile String password;
        volatile boolean preemptive;
        volatile HttpConfig.AuthType authType;

        public ThreadSafeAuth() {
        }

        public ThreadSafeAuth(BasicAuth toCopy) {
            this.user = toCopy.user;
            this.password = toCopy.password;
            this.preemptive = toCopy.preemptive;
            this.authType = toCopy.authType;
        }

        @Override
        public void basic(String user, String password, boolean preemptive) {
            this.user = user;
            this.password = password;
            this.preemptive = preemptive;
            this.authType = HttpConfig.AuthType.BASIC;
        }

        @Override
        public void digest(String user, String password, boolean preemptive) {
            this.basic(user, password, preemptive);
            this.authType = HttpConfig.AuthType.DIGEST;
        }

        @Override
        public String getUser() {
            return this.user;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public HttpConfig.AuthType getAuthType() {
            return this.authType;
        }
    }

    public static class BasicAuth
    implements HttpConfig.Auth {
        private String user;
        private String password;
        private boolean preemptive;
        private HttpConfig.AuthType authType;

        @Override
        public void basic(String user, String password, boolean preemptive) {
            this.user = user;
            this.password = password;
            this.preemptive = preemptive;
            this.authType = HttpConfig.AuthType.BASIC;
        }

        @Override
        public void digest(String user, String password, boolean preemptive) {
            this.basic(user, password, preemptive);
            this.authType = HttpConfig.AuthType.DIGEST;
        }

        @Override
        public String getUser() {
            return this.user;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public HttpConfig.AuthType getAuthType() {
            return this.authType;
        }
    }
}

