/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotUtils;

public class RestoreService
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(RestoreService.class);
    private static final Set<String> UNMODIFIABLE_SETTINGS = Collections.unmodifiableSet(Sets.newHashSet("index.number_of_shards", "index.version.created", "index.uuid", "index.creation_date", IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey()));
    private static final Set<String> UNREMOVABLE_SETTINGS;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final AllocationService allocationService;
    private final MetaDataCreateIndexService createIndexService;
    private final MetaDataIndexUpgradeService metaDataIndexUpgradeService;
    private final ClusterSettings clusterSettings;
    private final CleanRestoreStateTaskExecutor cleanRestoreStateTaskExecutor;

    public RestoreService(ClusterService clusterService, RepositoriesService repositoriesService, AllocationService allocationService, MetaDataCreateIndexService createIndexService, MetaDataIndexUpgradeService metaDataIndexUpgradeService, ClusterSettings clusterSettings) {
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.metaDataIndexUpgradeService = metaDataIndexUpgradeService;
        clusterService.addStateApplier(this);
        this.clusterSettings = clusterSettings;
        this.cleanRestoreStateTaskExecutor = new CleanRestoreStateTaskExecutor(logger);
    }

    public void restoreSnapshot(final RestoreSnapshotRequest request, final ActionListener<RestoreCompletionResponse> listener) {
        try {
            String repositoryName = request.repository();
            Repository repository = this.repositoriesService.repository(repositoryName);
            RepositoryData repositoryData = repository.getRepositoryData();
            String snapshotName = request.snapshot();
            Optional<SnapshotId> matchingSnapshotId = repositoryData.getSnapshotIds().stream().filter(s -> snapshotName.equals(s.getName())).findFirst();
            if (!matchingSnapshotId.isPresent()) {
                throw new SnapshotRestoreException(repositoryName, snapshotName, "snapshot does not exist");
            }
            final SnapshotId snapshotId = matchingSnapshotId.get();
            final SnapshotInfo snapshotInfo = repository.getSnapshotInfo(snapshotId);
            final Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
            this.validateSnapshotRestorable(repositoryName, snapshotInfo);
            List<String> indicesInSnapshot = SnapshotUtils.filterIndices(snapshotInfo.indices(), request.indices(), request.indicesOptions());
            MetaData.Builder metaDataBuilder = request.includeGlobalState() ? MetaData.builder(repository.getSnapshotGlobalMetaData(snapshotId)) : MetaData.builder();
            List<IndexId> indexIdsInSnapshot = repositoryData.resolveIndices(indicesInSnapshot);
            for (IndexId indexId : indexIdsInSnapshot) {
                metaDataBuilder.put(repository.getSnapshotIndexMetaData(snapshotId, indexId), false);
            }
            final MetaData metaData = metaDataBuilder.build();
            final Map<String, String> indices = this.renamedIndices(request, indicesInSnapshot);
            this.clusterService.submitStateUpdateTask("restore_snapshot[" + snapshotName + ']', new ClusterStateUpdateTask(){
                String restoreUUID = UUIDs.randomBase64UUID();
                RestoreInfo restoreInfo = null;

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards;
                    RestoreInProgress restoreInProgress = (RestoreInProgress)currentState.custom("restore");
                    if (currentState.getNodes().getMinNodeVersion().before(Version.V_7_0_0) && restoreInProgress != null && !restoreInProgress.isEmpty()) {
                        throw new ConcurrentSnapshotExecutionException(snapshot, "Restore process is already running in this cluster");
                    }
                    SnapshotDeletionsInProgress deletionsInProgress = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
                    if (deletionsInProgress != null && deletionsInProgress.hasDeletionsInProgress()) {
                        throw new ConcurrentSnapshotExecutionException(snapshot, "cannot restore a snapshot while a snapshot deletion is in-progress [" + deletionsInProgress.getEntries().get(0).getSnapshot() + "]");
                    }
                    ClusterState.Builder builder = ClusterState.builder(currentState);
                    MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
                    HashSet<String> aliases = new HashSet<String>();
                    if (!indices.isEmpty()) {
                        ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder();
                        Version minIndexCompatibilityVersion = currentState.getNodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
                        for (Map.Entry indexEntry : indices.entrySet()) {
                            Index renamedIndex;
                            IndexMetaData updatedIndexMetaData;
                            IndexMetaData.Builder indexMdBuilder;
                            String index = (String)indexEntry.getValue();
                            boolean partial = this.checkPartial(index);
                            RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(this.restoreUUID, snapshot, snapshotInfo.version(), index);
                            String renamedIndexName = (String)indexEntry.getKey();
                            IndexMetaData snapshotIndexMetaData = metaData.index(index);
                            snapshotIndexMetaData = this.updateIndexSettings(snapshotIndexMetaData, request.indexSettings(), request.ignoreIndexSettings());
                            try {
                                snapshotIndexMetaData = RestoreService.this.metaDataIndexUpgradeService.upgradeIndexMetaData(snapshotIndexMetaData, minIndexCompatibilityVersion);
                            }
                            catch (Exception ex) {
                                throw new SnapshotRestoreException(snapshot, "cannot restore index [" + index + "] because it cannot be upgraded", ex);
                            }
                            IndexMetaData currentIndexMetaData = currentState.metaData().index(renamedIndexName);
                            IntHashSet ignoreShards = new IntHashSet();
                            if (currentIndexMetaData == null) {
                                MetaDataCreateIndexService.validateIndexName(renamedIndexName, currentState);
                                RestoreService.this.createIndexService.validateIndexSettings(renamedIndexName, snapshotIndexMetaData.getSettings(), false);
                                indexMdBuilder = IndexMetaData.builder(snapshotIndexMetaData).state(IndexMetaData.State.OPEN).index(renamedIndexName);
                                indexMdBuilder.settings(Settings.builder().put(snapshotIndexMetaData.getSettings()).put("index.uuid", UUIDs.randomBase64UUID()));
                                MetaDataCreateIndexService.checkShardLimit(snapshotIndexMetaData.getSettings(), currentState);
                                if (!request.includeAliases() && !snapshotIndexMetaData.getAliases().isEmpty()) {
                                    indexMdBuilder.removeAllAliases();
                                } else {
                                    for (ObjectCursor alias : snapshotIndexMetaData.getAliases().keys()) {
                                        aliases.add((String)alias.value);
                                    }
                                }
                                updatedIndexMetaData = indexMdBuilder.build();
                                if (partial) {
                                    this.populateIgnoredShards(index, (IntSet)ignoreShards);
                                }
                                rtBuilder.addAsNewRestore(updatedIndexMetaData, recoverySource, (IntSet)ignoreShards);
                                blocks.addBlocks(updatedIndexMetaData);
                                mdBuilder.put(updatedIndexMetaData, true);
                                renamedIndex = updatedIndexMetaData.getIndex();
                            } else {
                                this.validateExistingIndex(currentIndexMetaData, snapshotIndexMetaData, renamedIndexName, partial);
                                indexMdBuilder = IndexMetaData.builder(snapshotIndexMetaData).state(IndexMetaData.State.OPEN);
                                indexMdBuilder.version(Math.max(snapshotIndexMetaData.getVersion(), 1L + currentIndexMetaData.getVersion()));
                                indexMdBuilder.mappingVersion(Math.max(snapshotIndexMetaData.getMappingVersion(), 1L + currentIndexMetaData.getMappingVersion()));
                                indexMdBuilder.settingsVersion(Math.max(snapshotIndexMetaData.getSettingsVersion(), 1L + currentIndexMetaData.getSettingsVersion()));
                                indexMdBuilder.aliasesVersion(Math.max(snapshotIndexMetaData.getAliasesVersion(), 1L + currentIndexMetaData.getAliasesVersion()));
                                for (int shard = 0; shard < snapshotIndexMetaData.getNumberOfShards(); ++shard) {
                                    indexMdBuilder.primaryTerm(shard, Math.max(snapshotIndexMetaData.primaryTerm(shard), currentIndexMetaData.primaryTerm(shard)));
                                }
                                if (!request.includeAliases()) {
                                    if (!snapshotIndexMetaData.getAliases().isEmpty()) {
                                        indexMdBuilder.removeAllAliases();
                                    }
                                    for (ObjectCursor alias : currentIndexMetaData.getAliases().values()) {
                                        indexMdBuilder.putAlias((AliasMetaData)alias.value);
                                    }
                                } else {
                                    for (ObjectCursor alias : snapshotIndexMetaData.getAliases().keys()) {
                                        aliases.add((String)alias.value);
                                    }
                                }
                                indexMdBuilder.settings(Settings.builder().put(snapshotIndexMetaData.getSettings()).put("index.uuid", currentIndexMetaData.getIndexUUID()));
                                updatedIndexMetaData = indexMdBuilder.index(renamedIndexName).build();
                                rtBuilder.addAsRestore(updatedIndexMetaData, recoverySource);
                                blocks.updateBlocks(updatedIndexMetaData);
                                mdBuilder.put(updatedIndexMetaData, true);
                                renamedIndex = updatedIndexMetaData.getIndex();
                            }
                            for (int shard = 0; shard < snapshotIndexMetaData.getNumberOfShards(); ++shard) {
                                if (!ignoreShards.contains(shard)) {
                                    shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId()));
                                    continue;
                                }
                                shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId(), RestoreInProgress.State.FAILURE));
                            }
                        }
                        shards = shardsBuilder.build();
                        RestoreInProgress.Entry restoreEntry = new RestoreInProgress.Entry(this.restoreUUID, snapshot, RestoreService.overallState(RestoreInProgress.State.INIT, shards), Collections.unmodifiableList(new ArrayList(indices.keySet())), shards);
                        RestoreInProgress.Builder restoreInProgressBuilder = restoreInProgress != null ? new RestoreInProgress.Builder(restoreInProgress) : new RestoreInProgress.Builder();
                        builder.putCustom("restore", restoreInProgressBuilder.add(restoreEntry).build());
                    } else {
                        shards = ImmutableOpenMap.of();
                    }
                    this.checkAliasNameConflicts(indices, aliases);
                    if (request.includeGlobalState()) {
                        if (metaData.persistentSettings() != null) {
                            Iterator<ObjectObjectCursor<String, MetaData.Custom>> settings = metaData.persistentSettings();
                            RestoreService.this.clusterSettings.validateUpdate((Settings)((Object)settings));
                            mdBuilder.persistentSettings((Settings)((Object)settings));
                        }
                        if (metaData.templates() != null) {
                            for (ObjectObjectCursor<String, MetaData.Custom> cursor : metaData.templates().values()) {
                                mdBuilder.put((IndexTemplateMetaData)cursor.value);
                            }
                        }
                        if (metaData.customs() != null) {
                            for (ObjectObjectCursor<String, MetaData.Custom> cursor : metaData.customs()) {
                                if ("repositories".equals(cursor.key)) continue;
                                mdBuilder.putCustom((String)cursor.key, (MetaData.Custom)cursor.value);
                            }
                        }
                    }
                    if (RestoreService.completed(shards)) {
                        this.restoreInfo = new RestoreInfo(snapshotId.getName(), Collections.unmodifiableList(new ArrayList(indices.keySet())), shards.size(), shards.size() - RestoreService.failedShards(shards));
                    }
                    RoutingTable rt = rtBuilder.build();
                    ClusterState updatedState = builder.metaData(mdBuilder).blocks(blocks).routingTable(rt).build();
                    return RestoreService.this.allocationService.reroute(updatedState, "restored snapshot [" + snapshot + "]");
                }

                private void checkAliasNameConflicts(Map<String, String> renamedIndices, Set<String> aliases) {
                    for (Map.Entry<String, String> renamedIndex : renamedIndices.entrySet()) {
                        if (!aliases.contains(renamedIndex.getKey())) continue;
                        throw new SnapshotRestoreException(snapshot, "cannot rename index [" + renamedIndex.getValue() + "] into [" + renamedIndex.getKey() + "] because of conflict with an alias with the same name");
                    }
                }

                private void populateIgnoredShards(String index, IntSet ignoreShards) {
                    for (SnapshotShardFailure failure : snapshotInfo.shardFailures()) {
                        if (!index.equals(failure.index())) continue;
                        ignoreShards.add(failure.shardId());
                    }
                }

                private boolean checkPartial(String index) {
                    if (RestoreService.this.failed(snapshotInfo, index)) {
                        if (request.partial()) {
                            return true;
                        }
                        throw new SnapshotRestoreException(snapshot, "index [" + index + "] wasn't fully snapshotted - cannot restore");
                    }
                    return false;
                }

                private void validateExistingIndex(IndexMetaData currentIndexMetaData, IndexMetaData snapshotIndexMetaData, String renamedIndex, boolean partial) {
                    if (currentIndexMetaData.getState() != IndexMetaData.State.CLOSE) {
                        throw new SnapshotRestoreException(snapshot, "cannot restore index [" + renamedIndex + "] because an open index with same name already exists in the cluster. Either close or delete the existing index or restore the index under a different name by providing a rename pattern and replacement name");
                    }
                    if (partial) {
                        throw new SnapshotRestoreException(snapshot, "cannot restore partial index [" + renamedIndex + "] because such index already exists");
                    }
                    if (currentIndexMetaData.getNumberOfShards() != snapshotIndexMetaData.getNumberOfShards()) {
                        throw new SnapshotRestoreException(snapshot, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetaData.getNumberOfShards() + "] shards from a snapshot of index [" + snapshotIndexMetaData.getIndex().getName() + "] with [" + snapshotIndexMetaData.getNumberOfShards() + "] shards");
                    }
                }

                private IndexMetaData updateIndexSettings(IndexMetaData indexMetaData, Settings changeSettings, String[] ignoreSettings) {
                    Settings normalizedChangeSettings = Settings.builder().put(changeSettings).normalizePrefix("index.").build();
                    IndexMetaData.Builder builder = IndexMetaData.builder(indexMetaData);
                    Settings settings = indexMetaData.getSettings();
                    HashSet<String> keyFilters = new HashSet<String>();
                    ArrayList<String> simpleMatchPatterns = new ArrayList<String>();
                    for (String ignoredSetting : ignoreSettings) {
                        if (!Regex.isSimpleMatchPattern(ignoredSetting)) {
                            if (UNREMOVABLE_SETTINGS.contains(ignoredSetting)) {
                                throw new SnapshotRestoreException(snapshot, "cannot remove setting [" + ignoredSetting + "] on restore");
                            }
                            keyFilters.add(ignoredSetting);
                            continue;
                        }
                        simpleMatchPatterns.add(ignoredSetting);
                    }
                    Predicate<String> settingsFilter = k -> {
                        if (!UNREMOVABLE_SETTINGS.contains(k)) {
                            for (String filterKey : keyFilters) {
                                if (!k.equals(filterKey)) continue;
                                return false;
                            }
                            for (String pattern : simpleMatchPatterns) {
                                if (!Regex.simpleMatch(pattern, k)) continue;
                                return false;
                            }
                        }
                        return true;
                    };
                    Settings.Builder settingsBuilder = Settings.builder().put(settings.filter(settingsFilter)).put(normalizedChangeSettings.filter(k -> {
                        if (UNMODIFIABLE_SETTINGS.contains(k)) {
                            throw new SnapshotRestoreException(snapshot, "cannot modify setting [" + k + "] on restore");
                        }
                        return true;
                    }));
                    settingsBuilder.remove(MetaDataIndexStateService.VERIFIED_BEFORE_CLOSE_SETTING.getKey());
                    return builder.settings(settingsBuilder).build();
                }

                @Override
                public void onFailure(String source, Exception e) {
                    logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)snapshotId), (Throwable)e);
                    listener.onFailure(e);
                }

                @Override
                public TimeValue timeout() {
                    return request.masterNodeTimeout();
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    listener.onResponse(new RestoreCompletionResponse(this.restoreUUID, snapshot, this.restoreInfo));
                }
            });
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)(request.repository() + ":" + request.snapshot())), (Throwable)e);
            listener.onFailure(e);
        }
    }

    public static RestoreInProgress updateRestoreStateWithDeletedIndices(RestoreInProgress oldRestore, Set<Index> deletedIndices) {
        boolean changesMade = false;
        RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
        for (RestoreInProgress.Entry entry : oldRestore) {
            ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = null;
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                ShardId shardId = (ShardId)objectObjectCursor.key;
                if (!deletedIndices.contains(shardId.getIndex())) continue;
                changesMade = true;
                if (shardsBuilder == null) {
                    shardsBuilder = ImmutableOpenMap.builder(entry.shards());
                }
                shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "index was deleted"));
            }
            if (shardsBuilder != null) {
                ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), RestoreService.overallState(RestoreInProgress.State.STARTED, shards), entry.indices(), shards));
                continue;
            }
            builder.add(entry);
        }
        if (changesMade) {
            return builder.build();
        }
        return oldRestore;
    }

    public static RestoreInProgress.Entry restoreInProgress(ClusterState state, String restoreUUID) {
        RestoreInProgress restoreInProgress = (RestoreInProgress)state.custom("restore");
        if (restoreInProgress != null) {
            return restoreInProgress.get(restoreUUID);
        }
        return null;
    }

    private void cleanupRestoreState(ClusterChangedEvent event) {
        ClusterState state = event.state();
        RestoreInProgress restoreInProgress = (RestoreInProgress)state.custom("restore");
        if (restoreInProgress != null) {
            for (RestoreInProgress.Entry entry : restoreInProgress) {
                if (!entry.state().completed()) continue;
                assert (RestoreService.completed(entry.shards())) : "state says completed but restore entries are not";
                this.clusterService.submitStateUpdateTask("clean up snapshot restore state", new CleanRestoreStateTaskExecutor.Task(entry.uuid()), ClusterStateTaskConfig.build(Priority.URGENT), this.cleanRestoreStateTaskExecutor, this.cleanRestoreStateTaskExecutor);
            }
        }
    }

    public static RestoreInProgress.State overallState(RestoreInProgress.State nonCompletedState, ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        boolean hasFailed = false;
        for (ObjectCursor status : shards.values()) {
            if (!((RestoreInProgress.ShardRestoreStatus)status.value).state().completed()) {
                return nonCompletedState;
            }
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state() != RestoreInProgress.State.FAILURE) continue;
            hasFailed = true;
        }
        if (hasFailed) {
            return RestoreInProgress.State.FAILURE;
        }
        return RestoreInProgress.State.SUCCESS;
    }

    public static boolean completed(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        for (ObjectCursor status : shards.values()) {
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state().completed()) continue;
            return false;
        }
        return true;
    }

    public static int failedShards(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        int failedShards = 0;
        for (ObjectCursor status : shards.values()) {
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state() != RestoreInProgress.State.FAILURE) continue;
            ++failedShards;
        }
        return failedShards;
    }

    private Map<String, String> renamedIndices(RestoreSnapshotRequest request, List<String> filteredIndices) {
        HashMap<String, String> renamedIndices = new HashMap<String, String>();
        Iterator<String> iterator = filteredIndices.iterator();
        while (iterator.hasNext()) {
            String previousIndex;
            String index;
            String renamedIndex = index = iterator.next();
            if (request.renameReplacement() != null && request.renamePattern() != null) {
                renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
            }
            if ((previousIndex = renamedIndices.put(renamedIndex, index)) == null) continue;
            throw new SnapshotRestoreException(request.repository(), request.snapshot(), "indices [" + index + "] and [" + previousIndex + "] are renamed into the same index [" + renamedIndex + "]");
        }
        return Collections.unmodifiableMap(renamedIndices);
    }

    private void validateSnapshotRestorable(String repository, SnapshotInfo snapshotInfo) {
        if (!snapshotInfo.state().restorable()) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "unsupported snapshot state [" + (Object)((Object)snapshotInfo.state()) + "]");
        }
        if (Version.CURRENT.before(snapshotInfo.version())) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "the snapshot was created with Elasticsearch version [" + snapshotInfo.version() + "] which is higher than the version of this node [" + Version.CURRENT + "]");
        }
    }

    private boolean failed(SnapshotInfo snapshot, String index) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index())) continue;
            return true;
        }
        return false;
    }

    public static Set<Index> restoringIndices(ClusterState currentState, Set<Index> indicesToCheck) {
        RestoreInProgress restore = (RestoreInProgress)currentState.custom("restore");
        if (restore == null) {
            return Collections.emptySet();
        }
        HashSet<Index> indices = new HashSet<Index>();
        for (RestoreInProgress.Entry entry : restore) {
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                Index index = ((ShardId)objectObjectCursor.key).getIndex();
                if (!indicesToCheck.contains(index) || ((RestoreInProgress.ShardRestoreStatus)objectObjectCursor.value).state().completed() || currentState.getMetaData().index(index) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster()) {
                this.cleanupRestoreState(event);
            }
        }
        catch (Exception t) {
            logger.warn("Failed to update restore state ", (Throwable)t);
        }
    }

    public static boolean isRepositoryInUse(ClusterState clusterState, String repository) {
        RestoreInProgress restoreInProgress = (RestoreInProgress)clusterState.custom("restore");
        if (restoreInProgress != null) {
            for (RestoreInProgress.Entry entry : restoreInProgress) {
                if (!repository.equals(entry.snapshot().getRepository())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        HashSet<String> unremovable = new HashSet<String>(UNMODIFIABLE_SETTINGS.size() + 4);
        unremovable.addAll(UNMODIFIABLE_SETTINGS);
        unremovable.add("index.number_of_replicas");
        unremovable.add("index.auto_expand_replicas");
        unremovable.add("index.version.upgraded");
        UNREMOVABLE_SETTINGS = Collections.unmodifiableSet(unremovable);
    }

    static class CleanRestoreStateTaskExecutor
    implements ClusterStateTaskExecutor<Task>,
    ClusterStateTaskListener {
        private final Logger logger;

        CleanRestoreStateTaskExecutor(Logger logger) {
            this.logger = logger;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<Task> execute(ClusterState currentState, List<Task> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<Task> resultBuilder = ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks);
            Set completedRestores = tasks.stream().map(e -> e.uuid).collect(Collectors.toSet());
            RestoreInProgress.Builder restoreInProgressBuilder = new RestoreInProgress.Builder();
            RestoreInProgress restoreInProgress = (RestoreInProgress)currentState.custom("restore");
            boolean changed = false;
            if (restoreInProgress != null) {
                for (RestoreInProgress.Entry entry : restoreInProgress) {
                    if (completedRestores.contains(entry.uuid())) {
                        changed = true;
                        continue;
                    }
                    restoreInProgressBuilder.add(entry);
                }
            }
            if (!changed) {
                return resultBuilder.build(currentState);
            }
            ImmutableOpenMap.Builder<String, ClusterState.Custom> builder = ImmutableOpenMap.builder(currentState.getCustoms());
            builder.put("restore", restoreInProgressBuilder.build());
            ImmutableOpenMap<String, ClusterState.Custom> customs = builder.build();
            return resultBuilder.build(ClusterState.builder(currentState).customs(customs).build());
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        }

        @Override
        public void onNoLongerMaster(String source) {
            this.logger.debug("no longer master while processing restore state update [{}]", (Object)source);
        }

        static class Task {
            final String uuid;

            Task(String uuid) {
                this.uuid = uuid;
            }

            public String toString() {
                return "clean restore state for restore " + this.uuid;
            }
        }
    }

    public static class RestoreInProgressUpdater
    extends RoutingChangesObserver.AbstractRoutingChangesObserver {
        private final Map<String, Updates> shardChanges = new HashMap<String, Updates>();

        @Override
        public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
            RecoverySource recoverySource;
            if (initializingShard.primary() && (recoverySource = initializingShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT) {
                this.changes(recoverySource).shards.put(initializingShard.shardId(), new RestoreInProgress.ShardRestoreStatus(initializingShard.currentNodeId(), RestoreInProgress.State.SUCCESS));
            }
        }

        @Override
        public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
            RecoverySource recoverySource;
            if (failedShard.primary() && failedShard.initializing() && (recoverySource = failedShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT && unassignedInfo.getFailure() != null && Lucene.isCorruptionException(unassignedInfo.getFailure().getCause())) {
                this.changes(recoverySource).shards.put(failedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(failedShard.currentNodeId(), RestoreInProgress.State.FAILURE, unassignedInfo.getFailure().getCause().getMessage()));
            }
        }

        @Override
        public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
            if (unassignedShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && initializedShard.recoverySource().getType() != RecoverySource.Type.SNAPSHOT) {
                this.changes(unassignedShard.recoverySource()).shards.put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "recovery source type changed from snapshot to " + initializedShard.recoverySource()));
            }
        }

        @Override
        public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
            RecoverySource recoverySource = unassignedShard.recoverySource();
            if (recoverySource.getType() == RecoverySource.Type.SNAPSHOT && newUnassignedInfo.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO) {
                String reason = "shard could not be allocated to any of the nodes";
                this.changes(recoverySource).shards.put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(unassignedShard.currentNodeId(), RestoreInProgress.State.FAILURE, reason));
            }
        }

        private Updates changes(RecoverySource recoverySource) {
            assert (recoverySource.getType() == RecoverySource.Type.SNAPSHOT);
            return this.shardChanges.computeIfAbsent(((RecoverySource.SnapshotRecoverySource)recoverySource).restoreUUID(), k -> new Updates());
        }

        public RestoreInProgress applyChanges(RestoreInProgress oldRestore) {
            if (!this.shardChanges.isEmpty()) {
                RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
                for (RestoreInProgress.Entry entry : oldRestore) {
                    Updates updates = this.shardChanges.get(entry.uuid());
                    ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shardStates = entry.shards();
                    if (updates != null && !updates.shards.isEmpty()) {
                        ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder(shardStates);
                        for (Map.Entry shard : updates.shards.entrySet()) {
                            ShardId shardId = (ShardId)shard.getKey();
                            RestoreInProgress.ShardRestoreStatus status = shardStates.get(shardId);
                            if (status != null && status.state().completed()) continue;
                            shardsBuilder.put(shardId, (RestoreInProgress.ShardRestoreStatus)shard.getValue());
                        }
                        ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                        RestoreInProgress.State newState = RestoreService.overallState(RestoreInProgress.State.STARTED, shards);
                        builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), newState, entry.indices(), shards));
                        continue;
                    }
                    builder.add(entry);
                }
                return builder.build();
            }
            return oldRestore;
        }

        private static class Updates {
            private Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards = new HashMap<ShardId, RestoreInProgress.ShardRestoreStatus>();

            private Updates() {
            }
        }
    }

    public static final class RestoreCompletionResponse {
        private final String uuid;
        private final Snapshot snapshot;
        private final RestoreInfo restoreInfo;

        private RestoreCompletionResponse(String uuid, Snapshot snapshot, RestoreInfo restoreInfo) {
            this.uuid = uuid;
            this.snapshot = snapshot;
            this.restoreInfo = restoreInfo;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }
    }
}

