/*
 * Decompiled with CFR 0.152.
 */
package javax.money.spi;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.money.CurrencyUnit;
import javax.money.MonetaryException;
import javax.money.MonetaryRounding;
import javax.money.RoundingQuery;
import javax.money.RoundingQueryBuilder;

public interface MonetaryRoundingsSingletonSpi {
    public Set<String> getRoundingNames(String ... var1);

    public Set<String> getProviderNames();

    public List<String> getDefaultProviderChain();

    public Collection<MonetaryRounding> getRoundings(RoundingQuery var1);

    public MonetaryRounding getDefaultRounding();

    default public MonetaryRounding getRounding(CurrencyUnit currencyUnit, String ... providers) {
        MonetaryRounding op = this.getRounding(((RoundingQueryBuilder)RoundingQueryBuilder.of().setProviderNames(providers)).setCurrency(currencyUnit).build());
        return Optional.ofNullable(op).orElseThrow(() -> new MonetaryException("No rounding provided for CurrencyUnit: " + currencyUnit.getCurrencyCode()));
    }

    default public MonetaryRounding getRounding(String roundingName, String ... providers) {
        MonetaryRounding op = this.getRounding(((RoundingQueryBuilder)RoundingQueryBuilder.of().setProviderNames(providers)).setRoundingName(roundingName).build());
        return Optional.ofNullable(op).orElseThrow(() -> new MonetaryException("No rounding provided with rounding name: " + roundingName));
    }

    default public MonetaryRounding getRounding(RoundingQuery query) {
        Collection<MonetaryRounding> roundings = this.getRoundings(query);
        if (roundings.isEmpty()) {
            return null;
        }
        return roundings.iterator().next();
    }

    default public boolean isRoundingAvailable(RoundingQuery query) {
        return !this.getRoundings(query).isEmpty();
    }

    default public boolean isRoundingAvailable(String roundingId, String ... providers) {
        return this.isRoundingAvailable(((RoundingQueryBuilder)RoundingQueryBuilder.of().setProviderNames(providers)).setRoundingName(roundingId).build());
    }

    default public boolean isRoundingAvailable(CurrencyUnit currencyUnit, String ... providers) {
        return this.isRoundingAvailable(((RoundingQueryBuilder)RoundingQueryBuilder.of().setProviderNames(providers)).setCurrency(currencyUnit).build());
    }
}

