/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.control;

import org.apache.karaf.cellar.core.command.CommandHandler;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.ShutdownCommand;
import org.apache.karaf.cellar.core.control.ShutdownResult;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.features.FeaturesService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ShutdownCommandHandler
extends CommandHandler<ShutdownCommand, ShutdownResult> {
    public static final String SWITCH_ID = "org.apache.karaf.cellar.command.shutdown.switch";
    private final Switch commandSwitch = new BasicSwitch("org.apache.karaf.cellar.command.shutdown.switch");
    private BundleContext bundleContext;

    @Override
    public ShutdownResult execute(ShutdownCommand command) {
        try {
            if (command.isHalt()) {
                this.bundleContext.getBundle(0L).stop();
            } else {
                ServiceReference ref = this.bundleContext.getServiceReference(FeaturesService.class);
                FeaturesService featuresService = (FeaturesService)this.bundleContext.getService(ref);
                featuresService.uninstallFeature("cellar");
                this.bundleContext.ungetService(ref);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ShutdownResult(command.getId());
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public Class<ShutdownCommand> getType() {
        return ShutdownCommand.class;
    }

    @Override
    public Switch getSwitch() {
        return this.commandSwitch;
    }
}

