/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.metrics.commands;

import java.util.ArrayList;
import java.util.Map;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;
import org.apache.unomi.common.DataTable;
import org.apache.unomi.metrics.Metric;
import org.apache.unomi.metrics.commands.MetricsCommandSupport;

@Command(scope="metrics", name="list", description="This will list all the metrics")
public class ListCommand
extends MetricsCommandSupport {
    @Option(name="--csv", description="Output table in CSV format", required=false, multiValued=false)
    boolean csv;

    protected Object doExecute() throws Exception {
        System.out.println("Metrics service status: " + (this.metricsService.isActivated() ? "active" : "inactive"));
        Map<String, Metric> metrics = this.metricsService.getMetrics();
        String[] headers = new String[]{"Name", "Callers", "Count", "Time [ms]"};
        DataTable dataTable = new DataTable();
        for (Map.Entry<String, Metric> metricEntry : metrics.entrySet()) {
            Metric metric = metricEntry.getValue();
            dataTable.addRow(new Comparable[]{metric.getName(), Integer.valueOf(metric.getCallerCounts().size()), Long.valueOf(metric.getTotalCount()), Long.valueOf(metric.getTotalTime())});
        }
        dataTable.sort(new DataTable.SortCriteria[]{new DataTable.SortCriteria(Integer.valueOf(3), DataTable.SortOrder.DESCENDING), new DataTable.SortCriteria(Integer.valueOf(2), DataTable.SortOrder.DESCENDING), new DataTable.SortCriteria(Integer.valueOf(0), DataTable.SortOrder.ASCENDING)});
        if (this.csv) {
            System.out.println(dataTable.toCSV(headers));
            return null;
        }
        ShellTable shellTable = new ShellTable();
        for (String header : headers) {
            shellTable.column(header);
        }
        for (DataTable.Row dataTableRow : dataTable.getRows()) {
            ArrayList<Comparable> rowData = new ArrayList<Comparable>();
            rowData.add(dataTableRow.getData(0));
            rowData.add(dataTableRow.getData(1));
            rowData.add(dataTableRow.getData(2));
            rowData.add(dataTableRow.getData(3));
            Row row = shellTable.addRow();
            row.addContent(rowData);
        }
        shellTable.print(System.out);
        return null;
    }
}

