/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.channel.ChannelListenerManager;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.throttle.ChannelStreamPacketWriterResolverManager;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.forward.ForwardingFilterFactory;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.io.IoServiceEventListenerManager;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.kex.KexFactoryManager;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.ReservedSessionMessagesManager;
import org.apache.sshd.common.session.SessionDisconnectHandlerManager;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.common.session.SessionListenerManager;
import org.apache.sshd.common.session.UnknownChannelReferenceHandlerManager;
import org.apache.sshd.server.forward.AgentForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.forward.TcpForwardingFilter;
import org.apache.sshd.server.forward.X11ForwardingFilter;

public interface FactoryManager
extends KexFactoryManager,
SessionListenerManager,
ReservedSessionMessagesManager,
SessionDisconnectHandlerManager,
ChannelListenerManager,
ChannelStreamPacketWriterResolverManager,
UnknownChannelReferenceHandlerManager,
PortForwardingEventListenerManager,
IoServiceEventListenerManager,
AttributeStore,
SessionHeartbeatController {
    public static final String WINDOW_SIZE = "window-size";
    public static final long DEFAULT_WINDOW_SIZE = 0x200000L;
    public static final String WINDOW_TIMEOUT = "window-timeout";
    public static final long DEFAULT_WINDOW_TIMEOUT = 0L;
    public static final String MAX_PACKET_SIZE = "packet-size";
    public static final long DEFAULT_MAX_PACKET_SIZE = 32768L;
    public static final String LIMIT_PACKET_SIZE = "max-packet-size";
    public static final long DEFAULT_LIMIT_PACKET_SIZE = 0x1FFFFFFFL;
    public static final String NIO_WORKERS = "nio-workers";
    public static final int DEFAULT_NIO_WORKERS = Runtime.getRuntime().availableProcessors() + 1;
    public static final String AUTH_TIMEOUT = "auth-timeout";
    public static final long DEFAULT_AUTH_TIMEOUT = TimeUnit.MINUTES.toMillis(2L);
    public static final String IDLE_TIMEOUT = "idle-timeout";
    public static final long DEFAULT_IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    public static final String NIO2_READ_TIMEOUT = "nio2-read-timeout";
    public static final long DEFAULT_NIO2_READ_TIMEOUT = DEFAULT_IDLE_TIMEOUT + TimeUnit.SECONDS.toMillis(15L);
    public static final String NIO2_MIN_WRITE_TIMEOUT = "nio2-min-write-timeout";
    public static final long DEFAULT_NIO2_MIN_WRITE_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    public static final String DISCONNECT_TIMEOUT = "disconnect-timeout";
    public static final long DEFAULT_DISCONNECT_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    public static final String CHANNEL_CLOSE_TIMEOUT = "channel-close-timeout";
    public static final long DEFAULT_CHANNEL_CLOSE_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    public static final String STOP_WAIT_TIME = "stop-wait-time";
    public static final long DEFAULT_STOP_WAIT_TIME = TimeUnit.MINUTES.toMillis(1L);
    public static final String SOCKET_BACKLOG = "socket-backlog";
    public static final String SOCKET_KEEPALIVE = "socket-keepalive";
    public static final String SOCKET_SNDBUF = "socket-sndbuf";
    public static final String SOCKET_RCVBUF = "socket-rcvbuf";
    public static final String SOCKET_REUSEADDR = "socket-reuseaddr";
    public static final String SOCKET_LINGER = "socket-linger";
    public static final String TCP_NODELAY = "tcp-nodelay";
    public static final String NIO2_READ_BUFFER_SIZE = "nio2-read-buf-size";
    public static final String DEFAULT_VERSION = "SSHD-UNKNOWN";
    public static final String MAX_IDENTIFICATION_SIZE = "max-identification-size";
    public static final int DEFAULT_MAX_IDENTIFICATION_SIZE = 16384;
    public static final String REKEY_BYTES_LIMIT = "rekey-bytes-limit";
    public static final long DEFAULT_REKEY_BYTES_LIMIT = 0x40000000L;
    public static final String REKEY_TIME_LIMIT = "rekey-time-limit";
    public static final long DEFAULT_REKEY_TIME_LIMIT = 3600000L;
    public static final String REKEY_PACKETS_LIMIT = "rekey-packets-limit";
    public static final long DEFAULT_REKEY_PACKETS_LIMIT = 0x80000000L;
    public static final String REKEY_BLOCKS_LIMIT = "rekey-blocks-limit";
    public static final String IGNORE_MESSAGE_FREQUENCY = "ignore-message-frequency";
    public static final long DEFAULT_IGNORE_MESSAGE_FREQUENCY = 1024L;
    public static final String IGNORE_MESSAGE_VARIANCE = "ignore-message-variance";
    public static final int DEFAULT_IGNORE_MESSAGE_VARIANCE = 32;
    public static final String IGNORE_MESSAGE_SIZE = "ignore-message-size";
    public static final int DEFAULT_IGNORE_MESSAGE_SIZE = 16;
    public static final String AGENT_FORWARDING_TYPE = "agent-fw-auth-type";
    public static final String AGENT_FORWARDING_TYPE_IETF = "auth-agent-req";
    public static final String AGENT_FORWARDING_TYPE_OPENSSH = "auth-agent-req@openssh.com";

    public String getVersion();

    public IoServiceFactory getIoServiceFactory();

    public Factory<Random> getRandomFactory();

    public List<ChannelFactory> getChannelFactories();

    public SshAgentFactory getAgentFactory();

    public ScheduledExecutorService getScheduledExecutorService();

    public ForwardingFilter getForwardingFilter();

    default public TcpForwardingFilter getTcpForwardingFilter() {
        return this.getForwardingFilter();
    }

    default public AgentForwardingFilter getAgentForwardingFilter() {
        return this.getForwardingFilter();
    }

    default public X11ForwardingFilter getX11ForwardingFilter() {
        return this.getForwardingFilter();
    }

    public ForwardingFilterFactory getForwarderFactory();

    public FileSystemFactory getFileSystemFactory();

    public List<ServiceFactory> getServiceFactories();

    public List<RequestHandler<ConnectionService>> getGlobalRequestHandlers();

    @Override
    default public <T> T resolveAttribute(AttributeRepository.AttributeKey<T> key) {
        return FactoryManager.resolveAttribute(this, key);
    }

    public static <T> T resolveAttribute(FactoryManager manager, AttributeRepository.AttributeKey<T> key) {
        Objects.requireNonNull(key, "No key");
        return manager == null ? null : (T)manager.getAttribute(key);
    }
}

