/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch.conditions;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionContextHelper;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilder;
import org.apache.unomi.scripting.ScriptExecutor;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionESQueryBuilderDispatcher {
    private static final Logger logger = LoggerFactory.getLogger((String)ConditionESQueryBuilderDispatcher.class.getName());
    private Map<String, ConditionESQueryBuilder> queryBuilders = new ConcurrentHashMap<String, ConditionESQueryBuilder>();
    private ScriptExecutor scriptExecutor;

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public void addQueryBuilder(String name, ConditionESQueryBuilder evaluator) {
        this.queryBuilders.put(name, evaluator);
    }

    public void removeQueryBuilder(String name) {
        this.queryBuilders.remove(name);
    }

    public String getQuery(Condition condition) {
        return "{\"query\": " + this.getQueryBuilder(condition).toString() + "}";
    }

    public QueryBuilder getQueryBuilder(Condition condition) {
        return QueryBuilders.boolQuery().must(QueryBuilders.matchAllQuery()).filter(this.buildFilter(condition));
    }

    public QueryBuilder buildFilter(Condition condition) {
        return this.buildFilter(condition, new HashMap<String, Object>());
    }

    public QueryBuilder buildFilter(Condition condition, Map<String, Object> context) {
        if (condition == null || condition.getConditionType() == null) {
            throw new IllegalArgumentException("Condition is null or doesn't have type, impossible to build filter");
        }
        String queryBuilderKey = condition.getConditionType().getQueryBuilder();
        if (queryBuilderKey == null && condition.getConditionType().getParentCondition() != null) {
            context.putAll(condition.getParameterValues());
            return this.buildFilter(condition.getConditionType().getParentCondition(), context);
        }
        if (queryBuilderKey == null) {
            throw new UnsupportedOperationException("No query builder defined for : " + condition.getConditionTypeId());
        }
        if (this.queryBuilders.containsKey(queryBuilderKey)) {
            ConditionESQueryBuilder queryBuilder = this.queryBuilders.get(queryBuilderKey);
            Condition contextualCondition = ConditionContextHelper.getContextualCondition(condition, context, this.scriptExecutor);
            if (contextualCondition != null) {
                return queryBuilder.buildQuery(contextualCondition, context, this);
            }
        }
        logger.warn("No matching query builder. See debug log level for more information");
        if (logger.isDebugEnabled()) {
            logger.debug("No matching query builder for condition {} and context {}", (Object)condition, context);
        }
        return QueryBuilders.matchAllQuery();
    }

    public long count(Condition condition) {
        return this.count(condition, new HashMap<String, Object>());
    }

    public long count(Condition condition, Map<String, Object> context) {
        if (condition == null || condition.getConditionType() == null) {
            throw new IllegalArgumentException("Condition is null or doesn't have type, impossible to build filter");
        }
        String queryBuilderKey = condition.getConditionType().getQueryBuilder();
        if (queryBuilderKey == null && condition.getConditionType().getParentCondition() != null) {
            context.putAll(condition.getParameterValues());
            return this.count(condition.getConditionType().getParentCondition(), context);
        }
        if (queryBuilderKey == null) {
            throw new UnsupportedOperationException("No query builder defined for : " + condition.getConditionTypeId());
        }
        if (this.queryBuilders.containsKey(queryBuilderKey)) {
            ConditionESQueryBuilder queryBuilder = this.queryBuilders.get(queryBuilderKey);
            Condition contextualCondition = ConditionContextHelper.getContextualCondition(condition, context, this.scriptExecutor);
            if (contextualCondition != null) {
                return queryBuilder.count(contextualCondition, context, this);
            }
        }
        logger.warn("No matching query builder. See debug log level for more information");
        if (logger.isDebugEnabled()) {
            logger.debug("No matching query builder for condition {} and context {}", (Object)condition, context);
        }
        throw new UnsupportedOperationException();
    }
}

