/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.migration.utils;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.unomi.shell.migration.service.MigrationContext;
import org.apache.unomi.shell.migration.utils.HttpUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MigrationUtils {
    public static JSONObject queryWithScroll(CloseableHttpClient httpClient, String url) throws IOException {
        url = url + "?scroll=1m";
        return new JSONObject(HttpUtils.executeGetRequest(httpClient, url, null));
    }

    public static JSONObject continueQueryWithScroll(CloseableHttpClient httpClient, String url, String scrollId) throws IOException {
        url = url + "/_search/scroll?scroll=1m&scroll_id=" + scrollId;
        return new JSONObject(HttpUtils.executeGetRequest(httpClient, url, null));
    }

    public static void bulkUpdate(CloseableHttpClient httpClient, String url, String jsonData) throws IOException {
        HttpUtils.executePostRequest(httpClient, url, jsonData, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String resourceAsString(BundleContext bundleContext, String resource) {
        URL url = bundleContext.getBundle().getResource(resource);
        try (InputStream stream = url.openStream();){
            String string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileWithoutComments(BundleContext bundleContext, String resource) {
        URL url = bundleContext.getBundle().getResource(resource);
        try (InputStream stream = url.openStream();){
            String line;
            DataInputStream in = new DataInputStream(stream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringBuilder value = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("/*") || line.startsWith(" *") || line.startsWith("*/")) continue;
                value.append(line);
            }
            in.close();
            String string = value.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean indexExists(CloseableHttpClient httpClient, String esAddress, String indexName) throws IOException {
        HttpGet httpGet = new HttpGet(esAddress + "/" + indexName);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
            boolean bl = response.getStatusLine().getStatusCode() == 200;
            return bl;
        }
    }

    public static Set<String> getIndexesPrefixedBy(CloseableHttpClient httpClient, String esAddress, String prefix) throws IOException {
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(esAddress + "/_aliases"));){
            if (response.getStatusLine().getStatusCode() == 200) {
                JSONObject indexesAsJson = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
                Set<String> set = indexesAsJson.keySet().stream().filter(alias -> alias.startsWith(prefix)).collect(Collectors.toSet());
                return set;
            }
        }
        return Collections.emptySet();
    }

    public static String extractMappingFromBundles(BundleContext bundleContext, String fileName) throws IOException {
        for (Bundle bundle : bundleContext.getBundles()) {
            Enumeration predefinedMappings = bundle.findEntries("META-INF/cxs/mappings", fileName, true);
            if (predefinedMappings == null || !predefinedMappings.hasMoreElements()) continue;
            URL predefinedMappingURL = (URL)predefinedMappings.nextElement();
            return IOUtils.toString((URL)predefinedMappingURL);
        }
        throw new RuntimeException("no mapping found in bundles for: " + fileName);
    }

    public static String buildIndexCreationRequest(String baseIndexSettings, String mapping, MigrationContext context, boolean isMonthlyIndex) throws IOException {
        String settings = baseIndexSettings.replace("#numberOfShards", context.getConfigString(isMonthlyIndex ? "monthlyIndex.number_of_shards" : "number_of_shards")).replace("#numberOfReplicas", context.getConfigString(isMonthlyIndex ? "monthlyIndex.number_of_replicas" : "number_of_replicas")).replace("#maxDocValueFieldsSearch", context.getConfigString(isMonthlyIndex ? "monthlyIndex.max_docvalue_fields_search" : "max_docvalue_fields_search")).replace("#mappingTotalFieldsLimit", context.getConfigString(isMonthlyIndex ? "monthlyIndex.mapping.total_fields.limit" : "mapping.total_fields.limit"));
        return settings.replace("#mappings", mapping);
    }

    public static void reIndex(CloseableHttpClient httpClient, BundleContext bundleContext, String esAddress, String indexName, String newIndexSettings, String painlessScript, MigrationContext migrationContext) throws Exception {
        if (indexName.endsWith("-cloned")) {
            return;
        }
        String indexNameCloned = indexName + "-cloned";
        String reIndexRequest = MigrationUtils.resourceAsString(bundleContext, "requestBody/2.0.0/base_reindex_request.json").replace("#source", indexNameCloned).replace("#dest", indexName).replace("#painless", StringUtils.isNotEmpty((CharSequence)painlessScript) ? MigrationUtils.getScriptPart(painlessScript) : "");
        String setIndexReadOnlyRequest = MigrationUtils.resourceAsString(bundleContext, "requestBody/2.0.0/base_set_index_readonly_request.json");
        migrationContext.performMigrationStep("Reindex step for: " + indexName + " (clone creation)", () -> {
            if (MigrationUtils.indexExists(httpClient, esAddress, indexNameCloned)) {
                HttpUtils.executeDeleteRequest(httpClient, esAddress + "/" + indexNameCloned, null);
            }
            HttpUtils.executePutRequest(httpClient, esAddress + "/" + indexName + "/_settings", setIndexReadOnlyRequest, null);
            HttpUtils.executePostRequest(httpClient, esAddress + "/" + indexName + "/_clone/" + indexNameCloned, null, null);
        });
        migrationContext.performMigrationStep("Reindex step for: " + indexName + " (recreate the index and perform the re-indexation)", () -> {
            if (MigrationUtils.indexExists(httpClient, esAddress, indexName)) {
                HttpUtils.executeDeleteRequest(httpClient, esAddress + "/" + indexName, null);
            }
            HttpUtils.executePutRequest(httpClient, esAddress + "/" + indexName, newIndexSettings, null);
            HttpUtils.executePostRequest(httpClient, esAddress + "/_reindex", reIndexRequest, null);
        });
        migrationContext.performMigrationStep("Reindex step for: " + indexName + " (delete clone)", () -> {
            if (MigrationUtils.indexExists(httpClient, esAddress, indexNameCloned)) {
                HttpUtils.executeDeleteRequest(httpClient, esAddress + "/" + indexNameCloned, null);
            }
        });
        HttpUtils.executePostRequest(httpClient, esAddress + "/" + indexName + "/_refresh", null, null);
        MigrationUtils.waitForYellowStatus(httpClient, esAddress, migrationContext);
    }

    public static void scrollQuery(CloseableHttpClient httpClient, String esAddress, String queryURL, String query, String scrollDuration, ScrollCallback scrollCallback) throws IOException {
        String response = HttpUtils.executePostRequest(httpClient, esAddress + queryURL + "?scroll=" + scrollDuration, query, null);
        while (true) {
            JSONObject hitsObject;
            JSONObject responseAsJson;
            String scrollId = (responseAsJson = new JSONObject(response)).has("_scroll_id") ? responseAsJson.getString("_scroll_id") : null;
            JSONArray hits = new JSONArray();
            if (responseAsJson.has("hits") && (hitsObject = responseAsJson.getJSONObject("hits")).has("hits")) {
                hits = hitsObject.getJSONArray("hits");
            }
            if (hits.length() == 0) {
                if (scrollId == null) break;
                HttpUtils.executeDeleteRequest(httpClient, esAddress + "/_search/scroll/" + scrollId, null);
                break;
            }
            if (scrollCallback != null) {
                scrollCallback.execute(hits.toString());
            }
            response = HttpUtils.executePostRequest(httpClient, esAddress + "/_search/scroll", "{\n  \"scroll_id\": \"" + scrollId + "\",\n  \"scroll\": \"" + scrollDuration + "\"\n}", null);
        }
    }

    public static void waitForYellowStatus(CloseableHttpClient httpClient, String esAddress, MigrationContext migrationContext) throws Exception {
        JSONObject status;
        while (true) {
            if (!(status = new JSONObject(HttpUtils.executeGetRequest(httpClient, esAddress + "/_cluster/health?wait_for_status=yellow&timeout=60s", null))).get("timed_out").equals("true")) break;
            migrationContext.printMessage("Waiting for ES Cluster status to be Yellow, current status is " + status.get("status"));
        }
        migrationContext.printMessage("ES Cluster status is " + status.get("status"));
    }

    private static String getScriptPart(String painlessScript) {
        return ", \"script\": {\"source\": \"" + painlessScript + "\", \"lang\": \"painless\"}";
    }

    public static interface ScrollCallback {
        public void execute(String var1);
    }
}

