/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.codec.UserData;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;

public class GroupData
extends UserData {
    private String[] members;
    private String[] requiredMembers;

    public GroupData(Group group) {
        super(group.getName(), 2, group.getProperties(), group.getCredentials());
        this.members = GroupData.toArray(group.getMembers());
        this.requiredMembers = GroupData.toArray(group.getRequiredMembers());
    }

    public GroupData(String name, String[] members, String[] requiredMembers) {
        this(name, null, null, members, requiredMembers);
    }

    public GroupData(String name, Dictionary properties, Dictionary credentials, String[] members, String[] requiredMembers) {
        super(name, 2, properties, credentials);
        this.members = members == null ? new String[]{} : members;
        this.requiredMembers = requiredMembers == null ? new String[]{} : requiredMembers;
    }

    @Override
    public CompositeData toCompositeData() {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("Name", this.name);
            items.put("Type", this.type);
            items.put("Members", this.members);
            items.put("RequiredMembers", this.requiredMembers);
            return new CompositeDataSupport(UserAdminMBean.GROUP_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData" + e);
        }
    }

    public static GroupData from(CompositeData data) {
        if (data == null) {
            return null;
        }
        String name = (String)data.get("Name");
        String[] members = (String[])data.get("Members");
        String[] requiredMembers = (String[])data.get("RequiredMembers");
        return new GroupData(name, null, null, members, requiredMembers);
    }

    public String[] getMembers() {
        return this.members;
    }

    public String[] getRequiredMembers() {
        return this.requiredMembers;
    }

    private static String[] toArray(Role[] roles) {
        ArrayList<String> members = new ArrayList<String>();
        if (roles != null) {
            for (Role role : roles) {
                members.add(role.getName());
            }
        }
        return members.toArray(new String[members.size()]);
    }
}

