/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.permissionadmin;

import java.io.IOException;
import org.osgi.jmx.service.permissionadmin.PermissionAdminMBean;
import org.osgi.service.permissionadmin.PermissionInfo;

public class PermissionAdmin
implements PermissionAdminMBean {
    private org.osgi.service.permissionadmin.PermissionAdmin permAdmin;

    public PermissionAdmin(org.osgi.service.permissionadmin.PermissionAdmin permAdmin) {
        this.permAdmin = permAdmin;
    }

    public String[] getPermissions(String location) throws IOException {
        if (location == null) {
            throw new IOException("Location cannot be null");
        }
        PermissionInfo[] permissions = this.permAdmin.getPermissions(location);
        if (permissions != null) {
            String[] encoded = new String[permissions.length];
            for (int i = 0; i < permissions.length; ++i) {
                PermissionInfo info = permissions[i];
                encoded[i] = info.getEncoded();
            }
            return encoded;
        }
        return null;
    }

    public String[] listDefaultPermissions() throws IOException {
        PermissionInfo[] permissions = this.permAdmin.getDefaultPermissions();
        if (permissions != null) {
            String[] encoded = new String[permissions.length];
            for (int i = 0; i < permissions.length; ++i) {
                PermissionInfo info = permissions[i];
                encoded[i] = info.getEncoded();
            }
            return encoded;
        }
        return null;
    }

    public String[] listLocations() throws IOException {
        return this.permAdmin.getLocations();
    }

    public void setDefaultPermissions(String[] encodedPermissions) throws IOException {
        PermissionInfo[] permissions = PermissionAdmin.toPermissionInfo(encodedPermissions);
        this.permAdmin.setDefaultPermissions(permissions);
    }

    public void setPermissions(String location, String[] encodedPermissions) throws IOException {
        if (location == null) {
            throw new IOException("Location cannot be null");
        }
        PermissionInfo[] permissions = PermissionAdmin.toPermissionInfo(encodedPermissions);
        this.permAdmin.setPermissions(location, permissions);
    }

    private static PermissionInfo[] toPermissionInfo(String[] encodedPermissions) throws IOException {
        if (encodedPermissions == null) {
            return null;
        }
        PermissionInfo[] permissions = new PermissionInfo[encodedPermissions.length];
        for (int i = 0; i < encodedPermissions.length; ++i) {
            try {
                permissions[i] = new PermissionInfo(encodedPermissions[i]);
                continue;
            }
            catch (Exception e) {
                IOException ex = new IOException("Invalid encoded permission: " + encodedPermissions[i]);
                ex.initCause(e);
                throw ex;
            }
        }
        return permissions;
    }
}

