/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.FileBackedCookieStore;
import groovyx.net.http.FromServer;
import groovyx.net.http.HttpConfig;
import groovyx.net.http.HttpConfigs;
import groovyx.net.http.HttpObjectConfig;
import groovyx.net.http.HttpObjectConfigImpl;
import groovyx.net.http.HttpVerb;
import groovyx.net.http.JavaHttpBuilder;
import groovyx.net.http.NonBlockingCookieStore;
import groovyx.net.http.NullCookieStore;
import groovyx.net.http.TransportingException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codehaus.groovy.runtime.MethodClosure;

public abstract class HttpBuilder
implements Closeable {
    private static final Function<HttpObjectConfig, ? extends HttpBuilder> factory = JavaHttpBuilder::new;
    static Closure NO_OP = new MethodClosure(HttpBuilder.class, "noOp");
    private final EnumMap<HttpVerb, BiFunction<ChainedHttpConfig, Function<ChainedHttpConfig, Object>, Object>> interceptors;
    private final CookieManager cookieManager;

    static void noOp() {
    }

    public static HttpBuilder configure(Function<HttpObjectConfig, ? extends HttpBuilder> factory) {
        return HttpBuilder.configure(factory, NO_OP);
    }

    public static HttpBuilder configure(@DelegatesTo(value=HttpObjectConfig.class) Closure closure) {
        return HttpBuilder.configure(factory, closure);
    }

    public static HttpBuilder configure(Function<HttpObjectConfig, ? extends HttpBuilder> factory, @DelegatesTo(value=HttpObjectConfig.class) Closure closure) {
        HttpObjectConfigImpl impl = new HttpObjectConfigImpl();
        closure.setDelegate((Object)impl);
        closure.setResolveStrategy(1);
        closure.call();
        return factory.apply(impl);
    }

    public static HttpBuilder configure(Consumer<HttpObjectConfig> configuration) {
        return HttpBuilder.configure(factory, configuration);
    }

    public static HttpBuilder configure(Function<HttpObjectConfig, ? extends HttpBuilder> factory, Consumer<HttpObjectConfig> configuration) {
        HttpObjectConfigImpl impl = new HttpObjectConfigImpl();
        configuration.accept(impl);
        return factory.apply(impl);
    }

    protected HttpBuilder(HttpObjectConfig objectConfig) {
        this.interceptors = new EnumMap<HttpVerb, BiFunction<ChainedHttpConfig, Function<ChainedHttpConfig, Object>, Object>>(objectConfig.getExecution().getInterceptors());
        this.cookieManager = new CookieManager(this.makeCookieStore(objectConfig), CookiePolicy.ACCEPT_ALL);
    }

    private CookieStore makeCookieStore(HttpObjectConfig objectConfig) {
        if (objectConfig.getClient().getCookiesEnabled()) {
            File folder = objectConfig.getClient().getCookieFolder();
            return folder == null ? new NonBlockingCookieStore() : new FileBackedCookieStore(folder, objectConfig.getExecution().getExecutor());
        }
        return NullCookieStore.instance();
    }

    protected CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public CookieStore getCookieStore() {
        return this.cookieManager.getCookieStore();
    }

    protected Map<String, String> cookiesToAdd(HttpObjectConfig.Client clientConfig, ChainedHttpConfig.ChainedRequest cr) throws URISyntaxException {
        HashMap<String, String> tmp = new HashMap<String, String>();
        try {
            URI uri = cr.getUri().toURI();
            for (HttpCookie cookie : cr.actualCookies(new ArrayList<HttpCookie>())) {
                String keyName = clientConfig.getCookieVersion() == 0 ? "Set-Cookie" : "Set-Cookie2";
                Map<String, List<String>> toPut = Collections.singletonMap(keyName, Collections.singletonList(cookie.toString()));
                this.cookieManager.put(cr.getUri().forCookie(cookie), toPut);
            }
            Map<String, List<String>> found = this.cookieManager.get(uri, Collections.emptyMap());
            for (Map.Entry<String, List<String>> e : found.entrySet()) {
                if (e.getValue() == null || e.getValue().isEmpty()) continue;
                tmp.put(e.getKey(), String.join((CharSequence)"; ", (Iterable<? extends CharSequence>)e.getValue()));
            }
        }
        catch (IOException ioe) {
            throw new TransportingException(ioe);
        }
        return tmp;
    }

    public static List<HttpCookie> cookies(List<FromServer.Header<?>> headers) {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        for (FromServer.Header<?> header : headers) {
            if (!header.getKey().equalsIgnoreCase("Set-Cookie") && !header.getKey().equalsIgnoreCase("Set-Cookie2")) continue;
            List found = (List)header.getParsed();
            for (Object o : found) {
                cookies.add((HttpCookie)o);
            }
        }
        return Collections.unmodifiableList(cookies);
    }

    protected void addCookieStore(URI uri, List<FromServer.Header<?>> headers) {
        for (HttpCookie cookie : HttpBuilder.cookies(headers)) {
            this.cookieManager.getCookieStore().add(uri, cookie);
        }
    }

    public Object get() {
        return this.get(NO_OP);
    }

    public <T> T get(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return type.cast(this.interceptors.get((Object)HttpVerb.GET).apply(this.configureRequest(type, HttpVerb.GET, closure), this::doGet));
    }

    public <T> T get(Class<T> type, Consumer<HttpConfig> configuration) {
        return type.cast(this.interceptors.get((Object)HttpVerb.GET).apply(this.configureRequest(type, HttpVerb.GET, configuration), this::doGet));
    }

    public CompletableFuture<Object> getAsync() {
        return CompletableFuture.supplyAsync(() -> this.get(), this.getExecutor());
    }

    public CompletableFuture<Object> getAsync(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.get(closure), this.getExecutor());
    }

    public CompletableFuture<Object> getAsync(Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.get(configuration), this.getExecutor());
    }

    public <T> CompletableFuture<T> getAsync(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.get(type, closure), this.getExecutor());
    }

    public <T> CompletableFuture<T> getAsync(Class<T> type, Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.get(type, configuration), this.getExecutor());
    }

    public Object head() {
        return this.head(NO_OP);
    }

    public <T> T head(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return type.cast(this.interceptors.get((Object)HttpVerb.HEAD).apply(this.configureRequest(type, HttpVerb.HEAD, closure), this::doHead));
    }

    public <T> T head(Class<T> type, Consumer<HttpConfig> configuration) {
        return type.cast(this.interceptors.get((Object)HttpVerb.HEAD).apply(this.configureRequest(type, HttpVerb.HEAD, configuration), this::doHead));
    }

    public CompletableFuture<Object> headAsync() {
        return CompletableFuture.supplyAsync(() -> this.head(), this.getExecutor());
    }

    public CompletableFuture<Object> headAsync(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.head(closure), this.getExecutor());
    }

    public CompletableFuture<Object> headAsync(Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.head(configuration), this.getExecutor());
    }

    public <T> CompletableFuture<T> headAsync(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.head(type, closure), this.getExecutor());
    }

    public <T> CompletableFuture<T> headAsync(Class<T> type, Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.head(type, configuration), this.getExecutor());
    }

    public Object post() {
        return this.post(NO_OP);
    }

    public <T> T post(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return type.cast(this.interceptors.get((Object)HttpVerb.POST).apply(this.configureRequest(type, HttpVerb.POST, closure), this::doPost));
    }

    public <T> T post(Class<T> type, Consumer<HttpConfig> configuration) {
        return type.cast(this.interceptors.get((Object)HttpVerb.POST).apply(this.configureRequest(type, HttpVerb.POST, configuration), this::doPost));
    }

    public CompletableFuture<Object> postAsync() {
        return CompletableFuture.supplyAsync(() -> this.post(NO_OP), this.getExecutor());
    }

    public CompletableFuture<Object> postAsync(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.post(closure), this.getExecutor());
    }

    public CompletableFuture<Object> postAsync(Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.post(configuration), this.getExecutor());
    }

    public <T> CompletableFuture<T> postAsync(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.post(type, closure), this.getExecutor());
    }

    public <T> CompletableFuture<T> postAsync(Class<T> type, Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.post(type, configuration), this.getExecutor());
    }

    public Object put() {
        return this.put(NO_OP);
    }

    public <T> T put(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return type.cast(this.interceptors.get((Object)HttpVerb.PUT).apply(this.configureRequest(type, HttpVerb.PUT, closure), this::doPut));
    }

    public <T> T put(Class<T> type, Consumer<HttpConfig> configuration) {
        return type.cast(this.interceptors.get((Object)HttpVerb.PUT).apply(this.configureRequest(type, HttpVerb.PUT, configuration), this::doPut));
    }

    public CompletableFuture<Object> putAsync() {
        return CompletableFuture.supplyAsync(() -> this.put(NO_OP), this.getExecutor());
    }

    public CompletableFuture<Object> putAsync(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.put(closure), this.getExecutor());
    }

    public CompletableFuture<Object> putAsync(Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.put(configuration), this.getExecutor());
    }

    public <T> CompletableFuture<T> putAsync(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.put(type, closure), this.getExecutor());
    }

    public <T> CompletableFuture<T> putAsync(Class<T> type, Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.put(type, configuration), this.getExecutor());
    }

    public Object delete() {
        return this.delete(NO_OP);
    }

    public <T> T delete(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return type.cast(this.interceptors.get((Object)HttpVerb.DELETE).apply(this.configureRequest(type, HttpVerb.DELETE, closure), this::doDelete));
    }

    public <T> T delete(Class<T> type, Consumer<HttpConfig> configuration) {
        return type.cast(this.interceptors.get((Object)HttpVerb.DELETE).apply(this.configureRequest(type, HttpVerb.DELETE, configuration), this::doDelete));
    }

    public CompletableFuture<Object> deleteAsync() {
        return CompletableFuture.supplyAsync(() -> this.delete(NO_OP), this.getExecutor());
    }

    public CompletableFuture<Object> deleteAsync(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.delete(closure), this.getExecutor());
    }

    public CompletableFuture<Object> deleteAsync(Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.delete(configuration), this.getExecutor());
    }

    public <T> CompletableFuture<T> deleteAsync(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.delete(type, closure), this.getExecutor());
    }

    public <T> CompletableFuture<T> deleteAsync(Class<T> type, Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.delete(type, configuration), this.getExecutor());
    }

    public Object get(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return this.get(Object.class, closure);
    }

    public Object get(Consumer<HttpConfig> configuration) {
        return this.get(Object.class, configuration);
    }

    public Object head(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return this.head(Object.class, closure);
    }

    public Object head(Consumer<HttpConfig> configuration) {
        return this.head(Object.class, configuration);
    }

    public Object post(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return this.post(Object.class, closure);
    }

    public Object post(Consumer<HttpConfig> configuration) {
        return this.post(Object.class, configuration);
    }

    public Object put(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return this.put(Object.class, closure);
    }

    public Object put(Consumer<HttpConfig> configuration) {
        return this.put(Object.class, configuration);
    }

    public Object delete(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return this.delete(Object.class, closure);
    }

    public Object delete(Consumer<HttpConfig> configuration) {
        return this.delete(Object.class, configuration);
    }

    public Object patch() {
        return this.patch(NO_OP);
    }

    public Object patch(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return this.patch(Object.class, closure);
    }

    public Object patch(Consumer<HttpConfig> configuration) {
        return this.patch(Object.class, configuration);
    }

    public <T> T patch(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return type.cast(this.interceptors.get((Object)HttpVerb.PATCH).apply(this.configureRequest(type, HttpVerb.PATCH, closure), this::doPatch));
    }

    public <T> T patch(Class<T> type, Consumer<HttpConfig> configuration) {
        return type.cast(this.interceptors.get((Object)HttpVerb.PATCH).apply(this.configureRequest(type, HttpVerb.PATCH, configuration), this::doPatch));
    }

    public CompletableFuture<Object> patchAsync() {
        return CompletableFuture.supplyAsync(() -> this.patch(), this.getExecutor());
    }

    public CompletableFuture<Object> patchAsync(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.patch(closure), this.getExecutor());
    }

    public CompletableFuture<Object> patchAsync(Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.patch(configuration), this.getExecutor());
    }

    public <T> CompletableFuture<T> patchAsync(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.patch(type, closure), this.getExecutor());
    }

    public <T> CompletableFuture<T> patchAsync(Class<T> type, Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.patch(type, configuration), this.getExecutor());
    }

    public Object options(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return this.options(Object.class, closure);
    }

    public Object options(Consumer<HttpConfig> configuration) {
        return this.options(Object.class, configuration);
    }

    public Object options() {
        return this.options(NO_OP);
    }

    public <T> T options(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return type.cast(this.interceptors.get((Object)HttpVerb.OPTIONS).apply(this.configureRequest(type, HttpVerb.OPTIONS, closure), this::doOptions));
    }

    public <T> T options(Class<T> type, Consumer<HttpConfig> configuration) {
        return type.cast(this.interceptors.get((Object)HttpVerb.OPTIONS).apply(this.configureRequest(type, HttpVerb.OPTIONS, configuration), this::doOptions));
    }

    public CompletableFuture<Object> optionsAsync() {
        return CompletableFuture.supplyAsync(() -> this.options(), this.getExecutor());
    }

    public CompletableFuture<Object> optionsAsync(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.options(closure), this.getExecutor());
    }

    public CompletableFuture<Object> optionsAsync(Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.options(configuration), this.getExecutor());
    }

    public <T> CompletableFuture<T> optionsAsync(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.options(type, closure), this.getExecutor());
    }

    public <T> CompletableFuture<T> optionsAsync(Class<T> type, Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.options(type, configuration), this.getExecutor());
    }

    public Object trace(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return this.trace(Object.class, closure);
    }

    public Object trace(Consumer<HttpConfig> configuration) {
        return this.trace(Object.class, configuration);
    }

    public Object trace() {
        return this.trace(NO_OP);
    }

    public <T> T trace(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return type.cast(this.interceptors.get((Object)HttpVerb.TRACE).apply(this.configureRequest(type, HttpVerb.TRACE, closure), this::doTrace));
    }

    public <T> T trace(Class<T> type, Consumer<HttpConfig> configuration) {
        return type.cast(this.interceptors.get((Object)HttpVerb.TRACE).apply(this.configureRequest(type, HttpVerb.TRACE, configuration), this::doTrace));
    }

    public CompletableFuture<Object> traceAsync() {
        return CompletableFuture.supplyAsync(() -> this.trace(), this.getExecutor());
    }

    public CompletableFuture<Object> traceAsync(@DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.trace(closure), this.getExecutor());
    }

    public CompletableFuture<Object> traceAsync(Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.trace(configuration), this.getExecutor());
    }

    public <T> CompletableFuture<T> traceAsync(Class<T> type, @DelegatesTo(value=HttpConfig.class) Closure closure) {
        return CompletableFuture.supplyAsync(() -> this.trace(type, closure), this.getExecutor());
    }

    public <T> CompletableFuture<T> traceAsync(Class<T> type, Consumer<HttpConfig> configuration) {
        return CompletableFuture.supplyAsync(() -> this.trace(type, configuration), this.getExecutor());
    }

    public abstract Object getClientImplementation();

    protected abstract Object doGet(ChainedHttpConfig var1);

    protected abstract Object doHead(ChainedHttpConfig var1);

    protected abstract Object doPost(ChainedHttpConfig var1);

    protected abstract Object doPut(ChainedHttpConfig var1);

    protected abstract Object doDelete(ChainedHttpConfig var1);

    protected abstract Object doPatch(ChainedHttpConfig var1);

    protected abstract Object doOptions(ChainedHttpConfig var1);

    protected abstract Object doTrace(ChainedHttpConfig var1);

    protected abstract ChainedHttpConfig getObjectConfig();

    public abstract Executor getExecutor();

    private ChainedHttpConfig configureRequest(Class<?> type, HttpVerb verb, Closure closure) {
        HttpConfigs.BasicHttpConfig myConfig = HttpConfigs.requestLevel(this.getObjectConfig());
        closure.setDelegate((Object)myConfig);
        closure.setResolveStrategy(1);
        closure.call();
        myConfig.getChainedRequest().setVerb(verb);
        myConfig.getChainedResponse().setType(type);
        return myConfig;
    }

    private ChainedHttpConfig configureRequest(Class<?> type, HttpVerb verb, Consumer<HttpConfig> configuration) {
        HttpConfigs.BasicHttpConfig myConfig = HttpConfigs.requestLevel(this.getObjectConfig());
        configuration.accept(myConfig);
        myConfig.getChainedRequest().setVerb(verb);
        myConfig.getChainedResponse().setType(type);
        return myConfig;
    }

    public static Throwable findCause(Exception e) {
        if (e instanceof TransportingException) {
            return e.getCause();
        }
        if (e instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException ute = (UndeclaredThrowableException)e;
            if (ute.getCause() != null) {
                return ute.getCause();
            }
            return e;
        }
        return e;
    }

    protected Object handleException(ChainedHttpConfig.ChainedResponse cr, Exception e) {
        return cr.actualException().apply(HttpBuilder.findCause(e));
    }

    protected static class ResponseHandlerFunction
    implements BiFunction<ChainedHttpConfig, FromServer, Object> {
        static final ResponseHandlerFunction HANDLER_FUNCTION = new ResponseHandlerFunction();

        protected ResponseHandlerFunction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object apply(ChainedHttpConfig requestConfig, FromServer fromServer) {
            try {
                BiFunction<ChainedHttpConfig, FromServer, Object> parser = requestConfig.findParser(fromServer.getContentType());
                BiFunction<FromServer, Object, ?> action = requestConfig.getChainedResponse().actualAction(fromServer.getStatusCode());
                Object obj = action.apply(fromServer, fromServer.getHasBody() ? parser.apply(requestConfig, fromServer) : null);
                return obj;
            }
            finally {
                fromServer.finish();
            }
        }
    }
}

