/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;

public class PostDataRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField RESET_START = new ParseField("reset_start", new String[0]);
    public static final ParseField RESET_END = new ParseField("reset_end", new String[0]);
    public static final ParseField CONTENT_TYPE = new ParseField("content_type", new String[0]);
    public static final ConstructingObjectParser<PostDataRequest, Void> PARSER = new ConstructingObjectParser("post_data_request", a -> new PostDataRequest((String)a[0], XContentType.fromMediaTypeOrFormat((String)a[1]), new byte[0]));
    private final String jobId;
    private final XContentType xContentType;
    private final BytesReference content;
    private String resetStart;
    private String resetEnd;

    public PostDataRequest(String jobId, XContentType xContentType, BytesReference content) {
        this.jobId = Objects.requireNonNull(jobId, "job_id must not be null");
        this.xContentType = Objects.requireNonNull(xContentType, "content_type must not be null");
        this.content = Objects.requireNonNull(content, "content must not be null");
    }

    public PostDataRequest(String jobId, XContentType xContentType, byte[] content) {
        this(jobId, xContentType, new BytesArray(content));
    }

    public PostDataRequest(String jobId, JsonBuilder builder) {
        this(jobId, XContentType.JSON, builder.build());
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getResetStart() {
        return this.resetStart;
    }

    public void setResetStart(String resetStart) {
        this.resetStart = resetStart;
    }

    public String getResetEnd() {
        return this.resetEnd;
    }

    public void setResetEnd(String resetEnd) {
        this.resetEnd = resetEnd;
    }

    public BytesReference getContent() {
        return this.content;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.resetStart, this.resetEnd, this.xContentType});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PostDataRequest other = (PostDataRequest)obj;
        return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.resetStart, other.resetStart) && Objects.equals(this.resetEnd, other.resetEnd) && Objects.equals((Object)this.xContentType, (Object)other.xContentType);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(CONTENT_TYPE.getPreferredName(), this.xContentType.mediaType());
        if (this.resetEnd != null) {
            builder.field(RESET_END.getPreferredName(), this.resetEnd);
        }
        if (this.resetStart != null) {
            builder.field(RESET_START.getPreferredName(), this.resetStart);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), CONTENT_TYPE);
        PARSER.declareStringOrNull(PostDataRequest::setResetEnd, RESET_END);
        PARSER.declareStringOrNull(PostDataRequest::setResetStart, RESET_START);
    }

    public static class JsonBuilder {
        private final List<ByteBuffer> bytes = new ArrayList<ByteBuffer>();

        public JsonBuilder addDoc(byte[] doc) {
            this.bytes.add(ByteBuffer.wrap(doc));
            return this;
        }

        public JsonBuilder addDoc(String doc) {
            this.bytes.add(ByteBuffer.wrap(doc.getBytes(StandardCharsets.UTF_8)));
            return this;
        }

        public JsonBuilder addDoc(Map<String, Object> doc) throws IOException {
            try (XContentBuilder builder = XContentBuilder.builder(XContentType.JSON.xContent());){
                builder.map(doc);
                this.bytes.add(ByteBuffer.wrap(BytesReference.toBytes(BytesReference.bytes(builder))));
            }
            return this;
        }

        private BytesReference build() {
            ByteBuffer[] buffers = this.bytes.toArray(new ByteBuffer[this.bytes.size()]);
            return BytesReference.fromByteBuffers(buffers);
        }
    }
}

