/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import org.apache.xbean.propertyeditor.AbstractConverter;
import org.apache.xbean.propertyeditor.PropertyEditorException;

public class PropertyEditorConverter
extends AbstractConverter {
    public PropertyEditorConverter(Class<?> type) {
        super(type);
    }

    @Override
    public String toStringImpl(Object value) throws PropertyEditorException {
        PropertyEditor editor = PropertyEditorManager.findEditor(this.getType());
        editor.setValue(value);
        try {
            return editor.getAsText();
        }
        catch (Exception e) {
            throw new PropertyEditorException("Error while converting a \"" + this.getType().getSimpleName() + "\" to text  using the property editor " + editor.getClass().getSimpleName(), e);
        }
    }

    @Override
    public Object toObjectImpl(String text) throws PropertyEditorException {
        PropertyEditor editor = PropertyEditorManager.findEditor(this.getType());
        editor.setAsText(text);
        try {
            return editor.getValue();
        }
        catch (Exception e) {
            throw new PropertyEditorException("Error while converting \"" + text + "\" to a " + this.getType().getSimpleName() + " using the property editor " + editor.getClass().getSimpleName(), e);
        }
    }
}

