/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.client.cache.impl.ClientCacheStatisticsImpl;
import com.hazelcast.client.cache.impl.OneShotExecutionCallback;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.spi.serialization.SerializationService;

final class CacheStatsHandler {
    private final SerializationService serializationService;
    private final ClientCacheStatisticsImpl statistics;

    CacheStatsHandler(SerializationService serializationService) {
        this.serializationService = serializationService;
        this.statistics = new ClientCacheStatisticsImpl(System.currentTimeMillis());
    }

    ClientCacheStatisticsImpl getStatistics() {
        return this.statistics;
    }

    void onReplace(boolean isGet, long startNanos, Object response) {
        if (isGet) {
            this.statistics.addGetTimeNanos(System.nanoTime() - startNanos);
            if (response != null) {
                this.statistics.increaseCacheHits();
                this.statistics.increaseCachePuts();
                this.statistics.addPutTimeNanos(System.nanoTime() - startNanos);
            } else {
                this.statistics.increaseCacheMisses();
            }
        } else if (Boolean.TRUE.equals(response)) {
            this.statistics.increaseCacheHits();
            this.statistics.increaseCachePuts();
            this.statistics.addPutTimeNanos(System.nanoTime() - startNanos);
        } else {
            this.statistics.increaseCacheMisses();
        }
    }

    <T> ExecutionCallback<T> newOnReplaceCallback(final long startNanos) {
        return new ExecutionCallback<T>(){

            @Override
            public void onResponse(T response) {
                CacheStatsHandler.this.onReplace(true, startNanos, CacheStatsHandler.this.toObject(response));
            }

            @Override
            public void onFailure(Throwable t) {
            }
        };
    }

    void onPutIfAbsent(long startNanos, boolean saved) {
        if (saved) {
            this.statistics.increaseCachePuts();
            this.statistics.increaseCacheMisses();
            this.statistics.addPutTimeNanos(System.nanoTime() - startNanos);
        }
    }

    ExecutionCallback<Boolean> newOnPutIfAbsentCallback(final long startNanos) {
        return new ExecutionCallback<Boolean>(){

            @Override
            public void onResponse(Boolean responseData) {
                Object response = CacheStatsHandler.this.toObject(responseData);
                CacheStatsHandler.this.onPutIfAbsent(startNanos, (Boolean)response);
            }

            @Override
            public void onFailure(Throwable t) {
            }
        };
    }

    void onPut(boolean isGet, long startNanos, boolean cacheHit) {
        this.statistics.increaseCachePuts();
        this.statistics.addPutTimeNanos(System.nanoTime() - startNanos);
        if (isGet) {
            this.statistics.addGetTimeNanos(System.nanoTime() - startNanos);
            if (cacheHit) {
                this.statistics.increaseCacheHits();
            } else {
                this.statistics.increaseCacheMisses();
            }
        }
    }

    <T> OneShotExecutionCallback<T> newOnPutCallback(final boolean isGet, final long startNanos) {
        return new OneShotExecutionCallback<T>(){

            @Override
            protected void onResponseInternal(T responseData) {
                CacheStatsHandler.this.onPut(isGet, startNanos, responseData != null);
            }

            @Override
            protected void onFailureInternal(Throwable t) {
            }
        };
    }

    void onRemove(boolean isGet, long startNanos, Object response) {
        if (isGet) {
            this.statistics.addGetTimeNanos(System.nanoTime() - startNanos);
            if (response != null) {
                this.statistics.increaseCacheHits();
                this.statistics.increaseCacheRemovals();
                this.statistics.addRemoveTimeNanos(System.nanoTime() - startNanos);
            } else {
                this.statistics.increaseCacheMisses();
            }
        } else if (Boolean.TRUE.equals(this.toObject(response))) {
            this.statistics.increaseCacheRemovals();
            this.statistics.addRemoveTimeNanos(System.nanoTime() - startNanos);
        }
    }

    <T> ExecutionCallback<T> newOnRemoveCallback(final boolean isGet, final long startNanos) {
        return new ExecutionCallback<T>(){

            @Override
            public void onResponse(T response) {
                CacheStatsHandler.this.onRemove(isGet, startNanos, response);
            }

            @Override
            public void onFailure(Throwable t) {
            }
        };
    }

    void onGet(long startNanos, boolean responseReceived) {
        if (responseReceived) {
            this.statistics.increaseCacheHits();
        } else {
            this.statistics.increaseCacheMisses();
        }
        this.statistics.addGetTimeNanos(System.nanoTime() - startNanos);
    }

    <T> ExecutionCallback<T> newOnGetCallback(final long startNanos) {
        return new ExecutionCallback<T>(){

            @Override
            public void onResponse(T response) {
                CacheStatsHandler.this.onGet(startNanos, response != null);
            }

            @Override
            public void onFailure(Throwable t) {
            }
        };
    }

    void onBatchRemove(long startNanos, int batchSize) {
        this.statistics.increaseCacheRemovals(batchSize);
        this.statistics.addRemoveTimeNanos(System.nanoTime() - startNanos);
    }

    void onBatchGet(long startNanos, int batchSize) {
        this.statistics.increaseCacheHits(batchSize);
        this.statistics.addGetTimeNanos(System.nanoTime() - startNanos);
    }

    void onBatchPut(long startNanos, int batchSize) {
        this.statistics.increaseCachePuts(batchSize);
        this.statistics.addPutTimeNanos(System.nanoTime() - startNanos);
    }

    void clear() {
        this.statistics.clear();
    }

    private Object toObject(Object responseData) {
        return this.serializationService.toObject(responseData);
    }
}

