/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.healthcheck.provider;

import java.util.concurrent.TimeUnit;
import org.apache.unomi.healthcheck.HealthCheckProvider;
import org.apache.unomi.healthcheck.HealthCheckResponse;
import org.apache.unomi.healthcheck.util.CachedValue;
import org.apache.unomi.lifecycle.BundleWatcher;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HealthCheckProvider.class}, immediate=true)
public class UnomiBundlesHealthCheckProvider
implements HealthCheckProvider {
    public static final String NAME = "unomi";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)UnomiBundlesHealthCheckProvider.class.getName());
    private final CachedValue<HealthCheckResponse> cache = new CachedValue(10L, TimeUnit.SECONDS);
    @Reference(service=BundleWatcher.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, bind="bind", unbind="unbind")
    private volatile BundleWatcher service;

    public UnomiBundlesHealthCheckProvider() {
        LOGGER.info("Building unomi bundles health provider service...");
    }

    public void bind(BundleWatcher service) {
        this.service = service;
    }

    public void unbind(BundleWatcher service) {
        this.service = null;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public HealthCheckResponse execute() {
        LOGGER.debug("Health check unomi bundles");
        if (this.cache.isStaled() || !this.cache.getValue().isLive()) {
            this.cache.setValue(this.refresh());
        }
        return this.cache.getValue();
    }

    private HealthCheckResponse refresh() {
        LOGGER.debug("Refresh");
        HealthCheckResponse.Builder builder = new HealthCheckResponse.Builder();
        builder.name(NAME).down();
        try {
            if (this.service != null) {
                builder.up();
                if (this.service.isStartupComplete()) {
                    builder.live();
                }
            }
        }
        catch (Exception e) {
            builder.error().withData("error", e.getMessage());
            LOGGER.error("Error while checking unomi bundles health", (Throwable)e);
        }
        return builder.build();
    }
}

