/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.StaticService;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.language.simple.SimpleBackwardsCompatibleParser;
import org.apache.camel.language.simple.SimpleExpressionParser;
import org.apache.camel.language.simple.SimplePredicateParser;
import org.apache.camel.language.simple.SimpleTokenizer;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.LRUCacheFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PredicateToExpressionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLanguage
extends LanguageSupport
implements StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleLanguage.class);
    private static final SimpleLanguage SIMPLE = new SimpleLanguage();
    boolean allowEscape = true;
    private Map<String, Expression> cacheExpression;
    private Map<String, Predicate> cachePredicate;

    @Override
    public void start() throws Exception {
        if (this.cacheExpression == null && this.cachePredicate == null && this.getCamelContext() != null) {
            int maxSize = CamelContextHelper.getMaximumSimpleCacheSize(this.getCamelContext());
            if (maxSize > 0) {
                this.cacheExpression = LRUCacheFactory.newLRUCache(16, maxSize, false);
                this.cachePredicate = LRUCacheFactory.newLRUCache(16, maxSize, false);
                LOG.debug("Simple language predicate/expression cache size: {}", (Object)maxSize);
            } else {
                LOG.debug("Simple language disabled predicate/expression cache");
            }
        }
    }

    @Override
    public void stop() throws Exception {
        LRUCache cache;
        if (this.cachePredicate instanceof LRUCache && LOG.isDebugEnabled()) {
            cache = (LRUCache)this.cachePredicate;
            LOG.debug("Clearing simple language predicate cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{cache.size(), cache.getHits(), cache.getMisses(), cache.getEvicted()});
        }
        if (this.cacheExpression instanceof LRUCache && LOG.isDebugEnabled()) {
            cache = (LRUCache)this.cacheExpression;
            LOG.debug("Clearing simple language expression cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{cache.size(), cache.getHits(), cache.getMisses(), cache.getEvicted()});
        }
    }

    @Override
    public Predicate createPredicate(String expression) {
        Predicate answer;
        ObjectHelper.notNull(expression, "expression");
        Predicate predicate = answer = this.cachePredicate != null ? this.cachePredicate.get(expression) : null;
        if (answer == null) {
            answer = SimpleBackwardsCompatibleParser.parsePredicate(expression = this.loadResource(expression), this.allowEscape);
            if (answer == null) {
                SimplePredicateParser parser = new SimplePredicateParser(expression, this.allowEscape, this.cacheExpression);
                answer = parser.parsePredicate();
            }
            if (this.cachePredicate != null && answer != null) {
                this.cachePredicate.put(expression, answer);
            }
        }
        return answer;
    }

    @Override
    public Expression createExpression(String expression) {
        Expression answer;
        ObjectHelper.notNull(expression, "expression");
        Expression expression2 = answer = this.cacheExpression != null ? this.cacheExpression.get(expression) : null;
        if (answer == null) {
            answer = SimpleBackwardsCompatibleParser.parseExpression(expression = this.loadResource(expression), this.allowEscape);
            if (answer == null) {
                SimpleExpressionParser parser = new SimpleExpressionParser(expression, this.allowEscape, this.cacheExpression);
                answer = parser.parseExpression();
            }
            if (this.cacheExpression != null && answer != null) {
                this.cacheExpression.put(expression, answer);
            }
        }
        return answer;
    }

    public static Expression simple(String expression) {
        return SimpleLanguage.expression(expression);
    }

    public static Expression simple(String expression, Class<?> resultType) {
        return new SimpleLanguage().createExpression(expression, resultType);
    }

    public Expression createExpression(String expression, Class<?> resultType) {
        if (resultType == Boolean.class || resultType == Boolean.TYPE) {
            Predicate predicate = this.createPredicate(expression);
            return PredicateToExpressionAdapter.toExpression(predicate);
        }
        Expression exp = this.createExpression(expression);
        if (resultType != null) {
            exp = ExpressionBuilder.convertToExpression(exp, resultType);
        }
        return exp;
    }

    public static Expression expression(String expression) {
        return SIMPLE.createExpression(expression);
    }

    public static Predicate predicate(String predicate) {
        return SIMPLE.createPredicate(predicate);
    }

    public static boolean hasSimpleFunction(String expression) {
        return SimpleTokenizer.hasFunctionStartToken(expression);
    }

    public static void changeFunctionStartToken(String ... startToken) {
        SimpleTokenizer.changeFunctionStartToken(startToken);
    }

    public static void changeFunctionEndToken(String ... endToken) {
        SimpleTokenizer.changeFunctionEndToken(endToken);
    }

    public void setFunctionStartToken(String startToken) {
        SimpleLanguage.changeFunctionStartToken(startToken);
    }

    public void setFunctionEndToken(String endToken) {
        SimpleLanguage.changeFunctionEndToken(endToken);
    }
}

