/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

public class LocalCacheEntry {
    private volatile boolean reload;
    private boolean removed;
    private Object value;
    private volatile boolean dirty;
    private final boolean transientEntry;

    public LocalCacheEntry(boolean transientEntry) {
        this.transientEntry = transientEntry;
        this.reload = true;
    }

    public LocalCacheEntry(boolean transientEntry, Object value) {
        this(transientEntry);
        this.value = value;
    }

    public boolean isTransient() {
        return this.transientEntry;
    }

    public boolean isDirty() {
        return !this.transientEntry && this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReload() {
        return this.reload;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalCacheEntry that = (LocalCacheEntry)o;
        if (this.reload != that.reload || this.removed != that.removed || this.dirty != that.dirty || this.transientEntry != that.transientEntry) {
            return false;
        }
        return !(this.value == null ? that.value != null : !this.value.equals(that.value));
    }

    public int hashCode() {
        int result = this.reload ? 1 : 0;
        result = 31 * result + (this.removed ? 1 : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.dirty ? 1 : 0);
        result = 31 * result + (this.transientEntry ? 1 : 0);
        return result;
    }
}

