/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.unomi.healthcheck.servlet;

import org.osgi.service.useradmin.Authorization;

import java.util.Arrays;

/**
 * A simple implementation of the {@link Authorization} interface (usually provided by UserAdmin).
 */
public class HealthCheckAuthorization implements Authorization {

    private final String name;
    private final String[] roles;

    public HealthCheckAuthorization(String name, String[] roles) {
        this.name = name;
        this.roles = roles;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean hasRole(String role) {
        return Arrays.asList(roles).contains(role);
    }

    @Override
    public String[] getRoles() {
        return roles;
    }
}
