/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.header.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.AbstractIterator;

public class RecordHeaders
implements Headers {
    private final List<Header> headers;
    private volatile boolean isReadOnly;

    public RecordHeaders() {
        this((Iterable<Header>)null);
    }

    public RecordHeaders(Header[] headers) {
        this.headers = headers == null ? new ArrayList<Header>() : new ArrayList<Header>(Arrays.asList(headers));
    }

    public RecordHeaders(Iterable<Header> headers) {
        if (headers == null) {
            this.headers = new ArrayList<Header>();
        } else if (headers instanceof RecordHeaders) {
            this.headers = new ArrayList<Header>(((RecordHeaders)headers).headers);
        } else if (headers instanceof Collection) {
            this.headers = new ArrayList<Header>((Collection)headers);
        } else {
            this.headers = new ArrayList<Header>();
            for (Header header : headers) {
                this.headers.add(header);
            }
        }
    }

    @Override
    public Headers add(Header header) throws IllegalStateException {
        this.canWrite();
        this.headers.add(header);
        return this;
    }

    @Override
    public Headers add(String key, byte[] value) throws IllegalStateException {
        return this.add(new RecordHeader(key, value));
    }

    @Override
    public Headers remove(String key) throws IllegalStateException {
        this.canWrite();
        this.checkKey(key);
        Iterator<Header> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().key().equals(key)) continue;
            iterator.remove();
        }
        return this;
    }

    @Override
    public Header lastHeader(String key) {
        this.checkKey(key);
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            Header header = this.headers.get(i);
            if (!header.key().equals(key)) continue;
            return header;
        }
        return null;
    }

    @Override
    public Iterable<Header> headers(final String key) {
        this.checkKey(key);
        return new Iterable<Header>(){

            @Override
            public Iterator<Header> iterator() {
                return new FilterByKeyIterator(RecordHeaders.this.headers.iterator(), key);
            }
        };
    }

    @Override
    public Iterator<Header> iterator() {
        return this.closeAware(this.headers.iterator());
    }

    public void setReadOnly() {
        this.isReadOnly = true;
    }

    @Override
    public Header[] toArray() {
        return this.headers.isEmpty() ? Record.EMPTY_HEADERS : this.headers.toArray(new Header[this.headers.size()]);
    }

    private void checkKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
    }

    private void canWrite() {
        if (this.isReadOnly) {
            throw new IllegalStateException("RecordHeaders has been closed.");
        }
    }

    private Iterator<Header> closeAware(final Iterator<Header> original) {
        return new Iterator<Header>(){

            @Override
            public boolean hasNext() {
                return original.hasNext();
            }

            @Override
            public Header next() {
                return (Header)original.next();
            }

            @Override
            public void remove() {
                RecordHeaders.this.canWrite();
                original.remove();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordHeaders headers1 = (RecordHeaders)o;
        return this.headers != null ? this.headers.equals(headers1.headers) : headers1.headers == null;
    }

    public int hashCode() {
        return this.headers != null ? this.headers.hashCode() : 0;
    }

    public String toString() {
        return "RecordHeaders(headers = " + this.headers + ", isReadOnly = " + this.isReadOnly + ')';
    }

    private static final class FilterByKeyIterator
    extends AbstractIterator<Header> {
        private final Iterator<Header> original;
        private final String key;

        private FilterByKeyIterator(Iterator<Header> original, String key) {
            this.original = original;
            this.key = key;
        }

        @Override
        protected Header makeNext() {
            while (this.original.hasNext()) {
                Header header = this.original.next();
                if (!header.key().equals(this.key)) continue;
                return header;
            }
            return (Header)this.allDone();
        }
    }
}

