/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Attachment;
import org.apache.camel.BytesSource;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.StreamCache;
import org.apache.camel.StringSource;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.bean.BeanConverter;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConverter;
import org.apache.camel.converter.AttachmentConverter;
import org.apache.camel.converter.CamelConverter;
import org.apache.camel.converter.CollectionConverter;
import org.apache.camel.converter.DateTimeConverter;
import org.apache.camel.converter.DurationConverter;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.NIOConverter;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.converter.SQLConverter;
import org.apache.camel.converter.TimePatternConverter;
import org.apache.camel.converter.jaxp.DomConverter;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.converter.jaxp.StreamSourceConverter;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.StreamCacheConverter;
import org.apache.camel.impl.converter.UriTypeConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CoreStaticTypeConverterLoader
implements TypeConverterLoader {
    private volatile XmlConverter xmlConverter;
    private volatile DomConverter domConverter;
    private volatile StaxConverter staxConverter;

    @Override
    public void load(final TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registry.addTypeConverter(Boolean.TYPE, Object.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toBool(value);
            }
        });
        registry.addTypeConverter(byte[].class, BufferedReader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toByteArray((BufferedReader)value, exchange);
            }
        });
        registry.addTypeConverter(byte[].class, ByteArrayOutputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toByteArray((ByteArrayOutputStream)value);
            }
        });
        registry.addTypeConverter(byte[].class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toByteArray((File)value);
            }
        });
        registry.addTypeConverter(byte[].class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toBytes((InputStream)value);
            }
        });
        registry.addTypeConverter(byte[].class, Reader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toByteArray((Reader)value, exchange);
            }
        });
        registry.addTypeConverter(byte[].class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toByteArray((String)value, exchange);
            }
        });
        registry.addTypeConverter(byte[].class, ByteBuffer.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteArray((ByteBuffer)value);
            }
        });
        registry.addTypeConverter(byte[].class, Source.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toByteArray((Source)value, exchange);
            }
        });
        registry.addTypeConverter(byte[].class, StreamCache.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToByteArray((StreamCache)value, exchange);
            }
        });
        registry.addTypeConverter(byte[].class, NodeList.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getDomConverter().toByteArray((NodeList)value, exchange);
            }
        });
        registry.addTypeConverter(Character.TYPE, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return Character.valueOf(ObjectConverter.toChar((String)value));
            }
        });
        registry.addTypeConverter(char[].class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toCharArray((String)value);
            }
        });
        registry.addTypeConverter(BufferedReader.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toReader((File)value, exchange);
            }
        });
        registry.addTypeConverter(BufferedWriter.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toWriter((File)value, exchange);
            }
        });
        registry.addTypeConverter(File.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toFile((String)value);
            }
        });
        registry.addTypeConverter(InputStream.class, byte[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((byte[])value);
            }
        });
        registry.addTypeConverter(InputStream.class, BufferedReader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((BufferedReader)value, exchange);
            }
        });
        registry.addTypeConverter(InputStream.class, ByteArrayOutputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((ByteArrayOutputStream)value);
            }
        });
        registry.addTypeConverter(InputStream.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((File)value);
            }
        });
        registry.addTypeConverter(InputStream.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((String)value, exchange);
            }
        });
        registry.addTypeConverter(InputStream.class, StringBuffer.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((StringBuffer)value, exchange);
            }
        });
        registry.addTypeConverter(InputStream.class, StringBuilder.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((StringBuilder)value, exchange);
            }
        });
        registry.addTypeConverter(InputStream.class, URL.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toInputStream((URL)value);
            }
        });
        registry.addTypeConverter(InputStream.class, ByteBuffer.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toInputStream((ByteBuffer)value);
            }
        });
        registry.addTypeConverter(InputStream.class, XMLStreamReader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createInputStream((XMLStreamReader)value, exchange);
            }
        });
        registry.addTypeConverter(InputStream.class, DOMSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toInputStream((DOMSource)value, exchange);
            }
        });
        registry.addTypeConverter(InputStream.class, StreamSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamSourceConverter.toInputStream((StreamSource)value);
            }
        });
        registry.addTypeConverter(InputStream.class, GenericFile.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return GenericFileConverter.genericFileToInputStream((GenericFile)value, exchange);
            }
        });
        registry.addTypeConverter(InputStream.class, Document.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toInputStream((Document)value, exchange);
            }
        });
        registry.addTypeConverter(InputStream.class, NodeList.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getDomConverter().toInputStream((NodeList)value, exchange);
            }
        });
        registry.addTypeConverter(ObjectInput.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toObjectInput((InputStream)value, exchange);
            }
        });
        registry.addTypeConverter(ObjectOutput.class, OutputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toObjectOutput((OutputStream)value);
            }
        });
        registry.addTypeConverter(OutputStream.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toOutputStream((File)value);
            }
        });
        registry.addTypeConverter(Reader.class, byte[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toReader((byte[])value, exchange);
            }
        });
        registry.addTypeConverter(Reader.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toReader((InputStream)value, exchange);
            }
        });
        registry.addTypeConverter(Reader.class, XMLStreamReader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createReader((XMLStreamReader)value, exchange);
            }
        });
        registry.addTypeConverter(Reader.class, StreamSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamSourceConverter.toReader((StreamSource)value);
            }
        });
        registry.addTypeConverter(Reader.class, Source.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toReaderFromSource((Source)value, exchange);
            }
        });
        registry.addTypeConverter(Serializable.class, StreamCache.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToSerializable((StreamCache)value, exchange);
            }
        });
        registry.addTypeConverter(Serializable.class, GenericFile.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return GenericFileConverter.genericFileToSerializable((GenericFile)value, exchange);
            }
        });
        registry.addTypeConverter(StringReader.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toReader((String)value);
            }
        });
        registry.addTypeConverter(Writer.class, OutputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toWriter((OutputStream)value, exchange);
            }
        });
        registry.addTypeConverter(Boolean.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toBoolean((String)value);
            }
        });
        registry.addTypeConverter(Boolean.class, NodeList.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toBoolean((NodeList)value);
            }
        });
        registry.addTypeConverter(Boolean.class, Object.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toBoolean(value);
            }
        });
        registry.addTypeConverter(Byte.class, Object.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toByte(value);
            }
        });
        registry.addTypeConverter(CharSequence.class, URI.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return UriTypeConverter.toCharSequence((URI)value);
            }
        });
        registry.addTypeConverter(Character.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toCharacter((String)value);
            }
        });
        registry.addTypeConverter(Class.class, Object.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toClass(value, exchange);
            }
        });
        registry.addTypeConverter(Double.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toDouble((String)value);
            }
        });
        registry.addTypeConverter(Double.class, Object.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toDouble(value);
            }
        });
        registry.addTypeConverter(Float.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toFloat((String)value);
            }
        });
        registry.addTypeConverter(Float.class, Object.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toFloat(value);
            }
        });
        registry.addTypeConverter(Integer.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toInteger((String)value);
            }
        });
        registry.addTypeConverter(Integer.class, NodeList.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DomConverter.toInteger((NodeList)value);
            }
        });
        registry.addTypeConverter(Integer.class, Object.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toInteger(value);
            }
        });
        registry.addTypeConverter(Iterable.class, Object.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.iterable(value);
            }
        });
        registry.addTypeConverter(Long.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toLong((String)value);
            }
        });
        registry.addTypeConverter(Long.class, Timestamp.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return SQLConverter.toLong((Timestamp)value);
            }
        });
        registry.addTypeConverter(Long.class, Date.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DateTimeConverter.toLong((Date)value);
            }
        });
        registry.addTypeConverter(Long.class, NodeList.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DomConverter.toLong((NodeList)value);
            }
        });
        registry.addTypeConverter(Long.class, Object.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toLong(value);
            }
        });
        registry.addTypeConverter(Object[].class, Collection.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toArray((Collection)value);
            }
        });
        registry.addTypeConverter(Short.class, Object.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toShort(value);
            }
        });
        registry.addTypeConverter(String.class, byte[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((byte[])value, exchange);
            }
        });
        registry.addTypeConverter(String.class, char[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.fromCharArray((char[])value);
            }
        });
        registry.addTypeConverter(String.class, BufferedReader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((BufferedReader)value);
            }
        });
        registry.addTypeConverter(String.class, ByteArrayOutputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((ByteArrayOutputStream)value, exchange);
            }
        });
        registry.addTypeConverter(String.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((File)value, exchange);
            }
        });
        registry.addTypeConverter(String.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((InputStream)value, exchange);
            }
        });
        registry.addTypeConverter(String.class, Reader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((Reader)value);
            }
        });
        registry.addTypeConverter(String.class, Boolean.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toString((Boolean)value);
            }
        });
        registry.addTypeConverter(String.class, Integer.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toString((Integer)value);
            }
        });
        registry.addTypeConverter(String.class, Long.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toString((Long)value);
            }
        });
        registry.addTypeConverter(String.class, StringBuffer.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toString((StringBuffer)value);
            }
        });
        registry.addTypeConverter(String.class, StringBuilder.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toString((StringBuilder)value);
            }
        });
        registry.addTypeConverter(String.class, URL.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toString((URL)value, exchange);
            }
        });
        registry.addTypeConverter(String.class, ByteBuffer.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toString((ByteBuffer)value, exchange);
            }
        });
        registry.addTypeConverter(String.class, Duration.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DurationConverter.toString((Duration)value);
            }
        });
        registry.addTypeConverter(String.class, Source.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toString((Source)value, exchange);
            }
        });
        registry.addTypeConverter(String.class, GenericFile.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return GenericFileConverter.genericFileToString((GenericFile)value, exchange);
            }
        });
        registry.addTypeConverter(String.class, Node.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toString((Node)value, exchange);
            }
        });
        registry.addTypeConverter(String.class, NodeList.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getDomConverter().toString((NodeList)value, exchange);
            }
        });
        registry.addTypeConverter(BigInteger.class, Object.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.toBigInteger(value);
            }
        });
        registry.addTypeConverter(URI.class, CharSequence.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return UriTypeConverter.toUri((CharSequence)value);
            }
        });
        registry.addTypeConverter(ByteBuffer.class, byte[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((byte[])value);
            }
        });
        registry.addTypeConverter(ByteBuffer.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((File)value);
            }
        });
        registry.addTypeConverter(ByteBuffer.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.covertToByteBuffer((InputStream)value);
            }
        });
        registry.addTypeConverter(ByteBuffer.class, Double.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((Double)value);
            }
        });
        registry.addTypeConverter(ByteBuffer.class, Float.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((Float)value);
            }
        });
        registry.addTypeConverter(ByteBuffer.class, Integer.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((Integer)value);
            }
        });
        registry.addTypeConverter(ByteBuffer.class, Long.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((Long)value);
            }
        });
        registry.addTypeConverter(ByteBuffer.class, Short.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((Short)value);
            }
        });
        registry.addTypeConverter(ByteBuffer.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NIOConverter.toByteBuffer((String)value, exchange);
            }
        });
        registry.addTypeConverter(ByteBuffer.class, StreamCache.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToByteBuffer((StreamCache)value, exchange);
            }
        });
        registry.addTypeConverter(Timestamp.class, Long.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return SQLConverter.toTimestamp((Long)value);
            }
        });
        registry.addTypeConverter(Duration.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DurationConverter.toDuration((String)value);
            }
        });
        registry.addTypeConverter(ArrayList.class, Iterator.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toArrayList((Iterator)value);
            }
        });
        registry.addTypeConverter(Date.class, Long.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DateTimeConverter.toDate((Long)value);
            }
        });
        registry.addTypeConverter(HashMap.class, Map.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toHashMap((Map)value);
            }
        });
        registry.addTypeConverter(Hashtable.class, Map.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toHashtable((Map)value);
            }
        });
        registry.addTypeConverter(Iterator.class, Object.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ObjectConverter.iterator(value);
            }
        });
        registry.addTypeConverter(List.class, Iterable.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toList((Iterable)value);
            }
        });
        registry.addTypeConverter(List.class, Object[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toList((Object[])value);
            }
        });
        registry.addTypeConverter(List.class, Collection.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toList((Collection)value);
            }
        });
        registry.addTypeConverter(List.class, NodeList.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DomConverter.toList((NodeList)value);
            }
        });
        registry.addTypeConverter(Properties.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toProperties((File)value);
            }
        });
        registry.addTypeConverter(Properties.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toProperties((InputStream)value);
            }
        });
        registry.addTypeConverter(Properties.class, Reader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return IOConverter.toProperties((Reader)value);
            }
        });
        registry.addTypeConverter(Properties.class, Map.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toProperties((Map)value);
            }
        });
        registry.addTypeConverter(Set.class, Object[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toSet((Object[])value);
            }
        });
        registry.addTypeConverter(Set.class, Collection.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toSet((Collection)value);
            }
        });
        registry.addTypeConverter(Set.class, Map.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CollectionConverter.toSet((Map)value);
            }
        });
        registry.addTypeConverter(TimeZone.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DateTimeConverter.toTimeZone((String)value);
            }
        });
        registry.addTypeConverter(DataHandler.class, Attachment.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return AttachmentConverter.toDataHandler((Attachment)value);
            }
        });
        registry.addTypeConverter(XMLEventReader.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventReader((File)value, exchange);
            }
        });
        registry.addTypeConverter(XMLEventReader.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventReader((InputStream)value, exchange);
            }
        });
        registry.addTypeConverter(XMLEventReader.class, Reader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventReader((Reader)value);
            }
        });
        registry.addTypeConverter(XMLEventReader.class, XMLStreamReader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventReader((XMLStreamReader)value);
            }
        });
        registry.addTypeConverter(XMLEventReader.class, Source.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventReader((Source)value);
            }
        });
        registry.addTypeConverter(XMLEventWriter.class, OutputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventWriter((OutputStream)value, exchange);
            }
        });
        registry.addTypeConverter(XMLEventWriter.class, Writer.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventWriter((Writer)value);
            }
        });
        registry.addTypeConverter(XMLEventWriter.class, Result.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLEventWriter((Result)value);
            }
        });
        registry.addTypeConverter(XMLStreamReader.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamReader((File)value, exchange);
            }
        });
        registry.addTypeConverter(XMLStreamReader.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamReader((InputStream)value, exchange);
            }
        });
        registry.addTypeConverter(XMLStreamReader.class, Reader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamReader((Reader)value);
            }
        });
        registry.addTypeConverter(XMLStreamReader.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamReader((String)value);
            }
        });
        registry.addTypeConverter(XMLStreamReader.class, Source.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamReader((Source)value);
            }
        });
        registry.addTypeConverter(XMLStreamWriter.class, OutputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamWriter((OutputStream)value, exchange);
            }
        });
        registry.addTypeConverter(XMLStreamWriter.class, Writer.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamWriter((Writer)value);
            }
        });
        registry.addTypeConverter(XMLStreamWriter.class, Result.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getStaxConverter().createXMLStreamWriter((Result)value);
            }
        });
        registry.addTypeConverter(Source.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSource((String)value);
            }
        });
        registry.addTypeConverter(DOMSource.class, byte[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((byte[])value);
            }
        });
        registry.addTypeConverter(DOMSource.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((File)value, exchange);
            }
        });
        registry.addTypeConverter(DOMSource.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((InputStream)value, exchange);
            }
        });
        registry.addTypeConverter(DOMSource.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((String)value);
            }
        });
        registry.addTypeConverter(DOMSource.class, SAXSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSourceFromSAX((SAXSource)value);
            }
        });
        registry.addTypeConverter(DOMSource.class, StAXSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSourceFromStAX((StAXSource)value);
            }
        });
        registry.addTypeConverter(DOMSource.class, StreamSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSourceFromStream((StreamSource)value, exchange);
            }
        });
        registry.addTypeConverter(DOMSource.class, Source.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((Source)value, exchange);
            }
        });
        registry.addTypeConverter(DOMSource.class, Document.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((Document)value);
            }
        });
        registry.addTypeConverter(DOMSource.class, Node.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMSource((Node)value);
            }
        });
        registry.addTypeConverter(SAXSource.class, byte[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSource((byte[])value, exchange);
            }
        });
        registry.addTypeConverter(SAXSource.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSource((File)value, exchange);
            }
        });
        registry.addTypeConverter(SAXSource.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSource((InputStream)value, exchange);
            }
        });
        registry.addTypeConverter(SAXSource.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSource((String)value, exchange);
            }
        });
        registry.addTypeConverter(SAXSource.class, DOMSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSourceFromDOM((DOMSource)value, exchange);
            }
        });
        registry.addTypeConverter(SAXSource.class, StAXSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSourceFromStAX((StAXSource)value, exchange);
            }
        });
        registry.addTypeConverter(SAXSource.class, StreamSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSourceFromStream((StreamSource)value, exchange);
            }
        });
        registry.addTypeConverter(SAXSource.class, Source.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toSAXSource((Source)value, exchange);
            }
        });
        registry.addTypeConverter(StAXSource.class, byte[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStAXSource((byte[])value, exchange);
            }
        });
        registry.addTypeConverter(StAXSource.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStAXSource((File)value, exchange);
            }
        });
        registry.addTypeConverter(StAXSource.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStAXSource((InputStream)value, exchange);
            }
        });
        registry.addTypeConverter(StAXSource.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStAXSource((String)value, exchange);
            }
        });
        registry.addTypeConverter(StreamSource.class, byte[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSource((byte[])value, exchange);
            }
        });
        registry.addTypeConverter(StreamSource.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSource((File)value);
            }
        });
        registry.addTypeConverter(StreamSource.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSource((InputStream)value);
            }
        });
        registry.addTypeConverter(StreamSource.class, Reader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSource((Reader)value);
            }
        });
        registry.addTypeConverter(StreamSource.class, ByteBuffer.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSource((ByteBuffer)value, exchange);
            }
        });
        registry.addTypeConverter(StreamSource.class, DOMSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSourceFromDOM((DOMSource)value, exchange);
            }
        });
        registry.addTypeConverter(StreamSource.class, SAXSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSourceFromSAX((SAXSource)value, exchange);
            }
        });
        registry.addTypeConverter(StreamSource.class, StAXSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSourceFromStAX((StAXSource)value, exchange);
            }
        });
        registry.addTypeConverter(StreamSource.class, Source.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStreamSource((Source)value, exchange);
            }
        });
        registry.addTypeConverter(Long.TYPE, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return TimePatternConverter.toMilliSeconds((String)value);
            }
        });
        registry.addTypeConverter(Long.TYPE, Duration.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return DurationConverter.toMilliSeconds((Duration)value);
            }
        });
        registry.addTypeConverter(BytesSource.class, byte[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toBytesSource((byte[])value);
            }
        });
        registry.addTypeConverter(Processor.class, Expression.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CamelConverter.toProcessor((Expression)value);
            }
        });
        registry.addTypeConverter(Processor.class, Predicate.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CamelConverter.toProcessor((Predicate)value);
            }
        });
        registry.addTypeConverter(StreamCache.class, ByteArrayInputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((ByteArrayInputStream)value, exchange);
            }
        });
        registry.addTypeConverter(StreamCache.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((InputStream)value, exchange);
            }
        });
        registry.addTypeConverter(StreamCache.class, Reader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((Reader)value, exchange);
            }
        });
        registry.addTypeConverter(StreamCache.class, SAXSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((SAXSource)value, exchange);
            }
        });
        registry.addTypeConverter(StreamCache.class, BytesSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((BytesSource)value);
            }
        });
        registry.addTypeConverter(StreamCache.class, StringSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((StringSource)value);
            }
        });
        registry.addTypeConverter(StreamCache.class, StreamSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((StreamSource)value, exchange);
            }
        });
        registry.addTypeConverter(StreamCache.class, CachedOutputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((CachedOutputStream)value, exchange);
            }
        });
        registry.addTypeConverter(StringSource.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toStringSource((String)value);
            }
        });
        registry.addTypeConverter(Document.class, byte[].class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((byte[])value, exchange);
            }
        });
        registry.addTypeConverter(Document.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((File)value, exchange);
            }
        });
        registry.addTypeConverter(Document.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((InputStream)value, exchange);
            }
        });
        registry.addTypeConverter(Document.class, Reader.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((Reader)value, exchange);
            }
        });
        registry.addTypeConverter(Document.class, String.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((String)value, exchange);
            }
        });
        registry.addTypeConverter(Document.class, Source.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((Source)value);
            }
        });
        registry.addTypeConverter(Document.class, Node.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((Node)value);
            }
        });
        registry.addTypeConverter(Document.class, NodeList.class, new SimpleTypeConverter(true){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocumentFromSingleNodeList((NodeList)value);
            }
        });
        registry.addTypeConverter(Document.class, InputSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMDocument((InputSource)value, exchange);
            }
        });
        registry.addTypeConverter(Element.class, Source.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMElement((Source)value);
            }
        });
        registry.addTypeConverter(Element.class, Node.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMElement((Node)value);
            }
        });
        registry.addTypeConverter(Node.class, SAXSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMNodeFromSAX((SAXSource)value);
            }
        });
        registry.addTypeConverter(Node.class, StAXSource.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMNodeFromStAX((StAXSource)value);
            }
        });
        registry.addTypeConverter(Node.class, Source.class, new SimpleTypeConverter(true){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMNode((Source)value);
            }
        });
        registry.addTypeConverter(Node.class, NodeList.class, new SimpleTypeConverter(true){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toDOMNodeFromSingleNodeList((NodeList)value);
            }
        });
        registry.addTypeConverter(InputSource.class, File.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toInputSource((File)value, exchange);
            }
        });
        registry.addTypeConverter(InputSource.class, InputStream.class, new SimpleTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CoreStaticTypeConverterLoader.this.getXmlConverter().toInputSource((InputStream)value, exchange);
            }
        });
        registry.addFallbackTypeConverter(new TypeConverterSupport(){

            @Override
            public boolean allowNull() {
                return false;
            }

            @Override
            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
                try {
                    return (T)BeanConverter.convertTo(type, exchange, value, registry);
                }
                catch (TypeConversionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new TypeConversionException(value, type, e);
                }
            }
        }, false);
        registry.addFallbackTypeConverter(new TypeConverterSupport(){

            @Override
            public boolean allowNull() {
                return false;
            }

            @Override
            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
                try {
                    return (T)GenericFileConverter.convertTo(type, exchange, value, registry);
                }
                catch (TypeConversionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new TypeConversionException(value, type, e);
                }
            }
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlConverter getXmlConverter() {
        if (this.xmlConverter == null) {
            CoreStaticTypeConverterLoader coreStaticTypeConverterLoader = this;
            synchronized (coreStaticTypeConverterLoader) {
                if (this.xmlConverter == null) {
                    this.xmlConverter = new XmlConverter();
                }
            }
        }
        return this.xmlConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomConverter getDomConverter() {
        if (this.domConverter == null) {
            CoreStaticTypeConverterLoader coreStaticTypeConverterLoader = this;
            synchronized (coreStaticTypeConverterLoader) {
                if (this.domConverter == null) {
                    this.domConverter = new DomConverter();
                }
            }
        }
        return this.domConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StaxConverter getStaxConverter() {
        if (this.staxConverter == null) {
            CoreStaticTypeConverterLoader coreStaticTypeConverterLoader = this;
            synchronized (coreStaticTypeConverterLoader) {
                if (this.staxConverter == null) {
                    this.staxConverter = new StaxConverter();
                }
            }
        }
        return this.staxConverter;
    }

    static abstract class SimpleTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public SimpleTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        @Override
        public boolean allowNull() {
            return this.allowNull;
        }

        @Override
        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

