/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.upload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.file.IFileCleaner;
import org.apache.wicket.util.io.DeferredFileOutputStream;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.upload.FileItem;
import org.apache.wicket.util.upload.FileItemHeaders;
import org.apache.wicket.util.upload.FileItemHeadersSupport;
import org.apache.wicket.util.upload.ParameterParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskFileItem
implements FileItem,
FileItemHeadersSupport {
    private static final Logger log = LoggerFactory.getLogger(DiskFileItem.class);
    private static final long serialVersionUID = 2237570099615271025L;
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String UID = UUID.randomUUID().toString().replace(':', '_').replace('-', '_');
    private static final Random counter = new Random();
    private String fieldName;
    private final String contentType;
    private boolean isFormField;
    private final String fileName;
    private long size = -1L;
    private final int sizeThreshold;
    private final File repository;
    private byte[] cachedContent;
    private transient DeferredFileOutputStream dfos;
    private transient File tempFile;
    private File dfosFile;
    private FileItemHeaders headers;
    private final transient IFileCleaner fileUploadCleaner;

    public DiskFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository, IFileCleaner fileUploadCleaner) {
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.sizeThreshold = sizeThreshold;
        this.repository = repository;
        this.fileUploadCleaner = fileUploadCleaner;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.isInMemory()) {
            return new FileInputStream(this.dfos.getFile());
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public String getCharSet() {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(this.getContentType(), ';');
        return params.get("charset");
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public boolean isInMemory() {
        if (this.cachedContent != null) {
            return true;
        }
        return this.dfos.isInMemory();
    }

    @Override
    public long getSize() {
        if (this.size >= 0L) {
            return this.size;
        }
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.dfos.getFile().length();
    }

    @Override
    public byte[] get() {
        if (this.isInMemory()) {
            if (this.cachedContent == null) {
                this.cachedContent = this.dfos.getData();
            }
            return this.cachedContent;
        }
        File file = this.dfos.getFile();
        try {
            return Files.readBytes(file);
        }
        catch (IOException e) {
            log.debug("failed to read content of file: " + file.getAbsolutePath(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getString(String charset) throws UnsupportedEncodingException {
        return new String(this.get(), charset);
    }

    @Override
    public String getString() {
        byte[] rawdata = this.get();
        String charset = this.getCharSet();
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        try {
            return new String(rawdata, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(rawdata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File file) throws IOException {
        if (this.isInMemory()) {
            FileOutputStream fout = new FileOutputStream(file);
            try {
                fout.write(this.get());
            }
            finally {
                fout.close();
            }
        }
        File outputFile = this.getStoreLocation();
        Checks.notNull(outputFile, "for a non-memory upload the file location must not be empty", new Object[0]);
        this.size = outputFile.length();
        if (!outputFile.renameTo(file)) {
            BufferedInputStream in = null;
            BufferedOutputStream out = null;
            try {
                in = new BufferedInputStream(new FileInputStream(outputFile));
                out = new BufferedOutputStream(new FileOutputStream(file));
                Streams.copy(in, out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
    }

    @Override
    public void delete() {
        this.cachedContent = null;
        File outputFile = this.getStoreLocation();
        if (outputFile != null && outputFile.exists() && !Files.remove(outputFile)) {
            log.error("failed to delete file: " + outputFile.getAbsolutePath());
        }
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public boolean isFormField() {
        return this.isFormField;
    }

    @Override
    public void setFormField(boolean state) {
        this.isFormField = state;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.dfos == null) {
            this.dfos = new DeferredFileOutputStream(this.sizeThreshold, new DeferredFileOutputStream.FileFactory(){

                @Override
                public File createFile() {
                    return DiskFileItem.this.getTempFile();
                }
            });
        }
        return this.dfos;
    }

    public File getStoreLocation() {
        return this.dfos == null ? null : this.dfos.getFile();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        File outputFile = this.dfos.getFile();
        if (outputFile != null && outputFile.exists() && !Files.remove(outputFile)) {
            log.error("failed to delete file: " + outputFile.getAbsolutePath());
        }
    }

    protected File getTempFile() {
        if (this.tempFile == null) {
            File tempDir = this.repository;
            if (tempDir == null) {
                String systemTmp;
                try {
                    systemTmp = System.getProperty("java.io.tmpdir");
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Reading property java.io.tmpdir is not allowed for the current security settings. The repository location needs to be set manually, or upgrade permissions to allow reading the tmpdir property.");
                }
                tempDir = new File(systemTmp);
            }
            Files.checkFileName(tempDir.getPath());
            try {
                do {
                    String tempFileName = "upload_" + UID + "_" + DiskFileItem.getUniqueId() + ".tmp";
                    this.tempFile = new File(tempDir, tempFileName);
                } while (!this.tempFile.createNewFile());
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create the temp file for upload: " + this.tempFile.getAbsolutePath(), e);
            }
            if (this.fileUploadCleaner != null) {
                this.fileUploadCleaner.track(this.tempFile, this);
            }
        }
        return this.tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUniqueId() {
        int limit = 100000000;
        Class<DiskFileItem> clazz = DiskFileItem.class;
        synchronized (DiskFileItem.class) {
            int current = counter.nextInt();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            String id = Integer.toString(current);
            if (current < 100000000) {
                id = ("00000000" + id).substring(id.length());
            }
            return id;
        }
    }

    public String toString() {
        return "name=" + this.getName() + ", StoreLocation=" + String.valueOf(this.getStoreLocation()) + ", size=" + this.getSize() + "bytes, " + "isFormField=" + this.isFormField() + ", FieldName=" + this.getFieldName();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(FileItemHeaders pHeaders) {
        this.headers = pHeaders;
    }
}

