/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.protocol.ws.WebSocketSettings;
import org.apache.wicket.protocol.ws.api.WebSocketResource;
import org.apache.wicket.protocol.ws.api.event.WebSocketPayload;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.SharedResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;

public class WebSocketMessageBroadcastHandler
implements IRequestHandler {
    private final int pageId;
    private final String resourceName;
    private final WebSocketPayload<?> payload;

    WebSocketMessageBroadcastHandler(int pageId, String resourceName, WebSocketPayload<?> payload) {
        this.pageId = pageId;
        this.resourceName = resourceName;
        this.payload = (WebSocketPayload)Args.notNull(payload, (String)"payload");
    }

    public void respond(IRequestCycle requestCycle) {
        final Application application = Application.get();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                if (WebSocketMessageBroadcastHandler.this.pageId != -1) {
                    Page page = (Page)Session.get().getPageManager().getPage(WebSocketMessageBroadcastHandler.this.pageId);
                    page.send((IEventSink)application, Broadcast.BREADTH, (Object)WebSocketMessageBroadcastHandler.this.payload);
                } else {
                    SharedResourceReference reference = new SharedResourceReference(WebSocketMessageBroadcastHandler.this.resourceName);
                    IResource resource = reference.getResource();
                    if (resource instanceof WebSocketResource) {
                        WebSocketResource wsResource = (WebSocketResource)resource;
                        wsResource.onPayload(WebSocketMessageBroadcastHandler.this.payload);
                    } else {
                        throw new IllegalStateException(String.format("Shared resource with name '%s' is not a %s but %s", WebSocketMessageBroadcastHandler.this.resourceName, WebSocketResource.class.getSimpleName(), Classes.name(resource.getClass())));
                    }
                }
            }
        };
        WebSocketSettings webSocketSettings = WebSocketSettings.Holder.get(application);
        webSocketSettings.getSendPayloadExecutor().run(action);
    }

    public void detach(IRequestCycle requestCycle) {
    }
}

