/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.pages;

import org.apache.wicket.core.request.ClientInfo;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.MetaDataHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.pages.BrowserInfoForm;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.cycle.RequestCycle;

public class BrowserInfoPage
extends WebPage {
    private static final long serialVersionUID = 1L;
    private BrowserInfoForm browserInfoForm;

    public BrowserInfoPage() {
        this.initComps();
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render(OnLoadHeaderItem.forScript(String.format("Wicket.BrowserInfo.submitForm('%s')", this.browserInfoForm.getFormMarkupId())));
    }

    @Override
    public boolean isVersioned() {
        return false;
    }

    protected WebClientInfo newWebClientInfo(RequestCycle requestCycle) {
        return new WebClientInfo(requestCycle);
    }

    private void initComps() {
        final LoadableDetachableModel<WebClientInfo> info = new LoadableDetachableModel<WebClientInfo>(){

            @Override
            protected WebClientInfo load() {
                return BrowserInfoPage.this.newWebClientInfo(BrowserInfoPage.this.getRequestCycle());
            }
        };
        LoadableDetachableModel<ClientProperties> properties = new LoadableDetachableModel<ClientProperties>(){

            @Override
            protected ClientProperties load() {
                return ((WebClientInfo)info.getObject()).getProperties();
            }
        };
        this.add(new ContinueLink("link", (IModel<WebClientInfo>)info));
        this.browserInfoForm = new BrowserInfoForm("postback", properties){
            private static final long serialVersionUID = 1L;

            @Override
            protected void afterSubmit() {
                ((ClientProperties)this.getModelObject()).setJavaScriptEnabled(true);
                WebSession.get().setClientInfo((ClientInfo)info.getObject());
                this.continueToOriginalDestination();
                this.setResponsePage(this.getApplication().getHomePage());
            }
        };
        this.add(this.browserInfoForm);
    }

    protected ClientProperties newClientInfo() {
        return WebSession.get().getClientInfo().getProperties();
    }

    private static class ContinueLink
    extends Link<WebClientInfo> {
        public ContinueLink(String id, IModel<WebClientInfo> info) {
            super(id, info);
        }

        @Override
        public void renderHead(IHeaderResponse response) {
            String content = "0; url=" + String.valueOf(this.getURL());
            response.render(MetaDataHeaderItem.forHttpEquiv("refresh", content));
        }

        @Override
        public void onClick() {
            ((WebClientInfo)this.getModelObject()).getProperties().setJavaScriptEnabled(false);
            WebSession.get().setClientInfo((ClientInfo)this.getModelObject());
            this.continueToOriginalDestination();
            this.setResponsePage(this.getApplication().getHomePage());
        }
    }
}

