/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.stax.pull.input;

import java.io.Closeable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.core.stream.CharacterData;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlReader;
import org.apache.axiom.core.stream.stax.pull.input.DTDInfo;
import org.apache.axiom.core.stream.stax.pull.input.XMLStreamReaderHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class StAXPullReader
implements XmlReader {
    private static final Log log = LogFactory.getLog(StAXPullReader.class);
    private XMLStreamReader reader;
    private XMLStreamReaderHelper helper;
    private final XmlHandler handler;
    private final Closeable closeable;
    private final boolean autoClose;
    private boolean isClosed = false;
    private Exception parserException;
    private boolean start = true;

    StAXPullReader(XMLStreamReader reader, XMLStreamReaderHelper helper, XmlHandler handler, Closeable closeable, boolean autoClose) {
        if (reader.getEventType() != 7) {
            throw new IllegalStateException("The XMLStreamReader must be positioned on a START_DOCUMENT event");
        }
        this.reader = reader;
        this.helper = helper;
        this.handler = handler;
        this.closeable = closeable;
        this.autoClose = autoClose;
    }

    private static String normalize(String s) {
        return s == null ? "" : s;
    }

    private void processText(int textType) throws StreamException {
        String text;
        CharacterData data;
        if (textType == 4 && (data = this.helper.getCharacterData()) != null) {
            this.handler.processCharacterData(data, false);
            return;
        }
        try {
            text = this.reader.getText();
        }
        catch (RuntimeException ex) {
            this.parserException = ex;
            throw ex;
        }
        switch (textType) {
            case 4: {
                this.handler.processCharacterData(text, false);
                break;
            }
            case 6: {
                this.handler.processCharacterData(text, true);
                break;
            }
            case 12: {
                this.handler.startCDATASection();
                this.handler.processCharacterData(text, false);
                this.handler.endCDATASection();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void dispose() {
        try {
            if (!this.isClosed) {
                this.reader.close();
                if (this.closeable != null) {
                    this.closeable.close();
                }
            }
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception occurred during parser close.  Processing continues. " + e));
            }
        }
        finally {
            this.isClosed = true;
            this.reader = null;
            this.helper = null;
        }
    }

    @Override
    public boolean proceed() throws StreamException {
        int token = this.parserNext();
        switch (token) {
            case 7: {
                this.handler.startDocument(this.reader.getEncoding(), this.reader.getVersion(), this.reader.getCharacterEncodingScheme(), this.reader.standaloneSet() ? Boolean.valueOf(this.reader.isStandalone()) : null);
                break;
            }
            case 1: {
                this.processElement();
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                this.processText(token);
                break;
            }
            case 2: {
                this.handler.endElement();
                break;
            }
            case 8: {
                this.handler.completed();
                break;
            }
            case 5: {
                this.handler.startComment();
                this.handler.processCharacterData(this.reader.getText(), false);
                this.handler.endComment();
                break;
            }
            case 11: {
                this.processDTD();
                break;
            }
            case 3: {
                this.handler.startProcessingInstruction(this.reader.getPITarget());
                this.handler.processCharacterData(this.reader.getPIData(), false);
                this.handler.endProcessingInstruction();
                break;
            }
            case 9: {
                this.handler.processEntityReference(this.reader.getLocalName(), this.reader.getText());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return token == 8;
    }

    private void processElement() throws StreamException {
        int i;
        String namespaceURI = StAXPullReader.normalize(this.reader.getNamespaceURI());
        String localName = this.reader.getLocalName();
        String prefix = StAXPullReader.normalize(this.reader.getPrefix());
        this.handler.startElement(namespaceURI, localName, prefix);
        int count = this.reader.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            this.handler.processNamespaceDeclaration(StAXPullReader.normalize(this.reader.getNamespacePrefix(i)), StAXPullReader.normalize(this.reader.getNamespaceURI(i)));
        }
        count = this.reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            this.handler.processAttribute(StAXPullReader.normalize(this.reader.getAttributeNamespace(i)), this.reader.getAttributeLocalName(i), StAXPullReader.normalize(this.reader.getAttributePrefix(i)), this.reader.getAttributeValue(i), this.reader.getAttributeType(i), this.reader.isAttributeSpecified(i));
        }
        this.handler.attributesCompleted();
    }

    private void processDTD() throws StreamException {
        DTDInfo dtdInfo = this.helper.getDTDInfo();
        String internalSubset = this.getDTDText();
        if (internalSubset != null && internalSubset.length() == 0) {
            internalSubset = null;
        }
        this.handler.processDocumentTypeDeclaration(dtdInfo.getRootName(), dtdInfo.getPublicId(), dtdInfo.getSystemId(), internalSubset);
    }

    private String getDTDText() {
        String text;
        block3: {
            text = null;
            try {
                text = this.reader.getText();
            }
            catch (RuntimeException e) {
                Boolean b = (Boolean)this.reader.getProperty("javax.xml.stream.isSupportingExternalEntities");
                if (b == null || b == Boolean.TRUE) {
                    throw e;
                }
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("An exception occurred while calling getText() for a DOCTYPE.  The exception is ignored because external entites support is disabled.  The ignored exception is " + e));
            }
        }
        return text;
    }

    private int parserNext() throws StreamException {
        if (this.start) {
            this.start = false;
            return this.reader.getEventType();
        }
        try {
            int event;
            if (this.parserException != null) {
                log.warn((Object)"Attempt to access a parser that has thrown a parse exception before; rethrowing the original exception.");
                if (this.parserException instanceof XMLStreamException) {
                    throw (XMLStreamException)this.parserException;
                }
                throw (RuntimeException)this.parserException;
            }
            try {
                event = this.reader.next();
            }
            catch (XMLStreamException ex) {
                this.parserException = ex;
                throw ex;
            }
            if (this.autoClose && event == 8) {
                this.dispose();
            }
            return event;
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }
}

