/*
 * PlainTemplate.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 2003 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): suhler.
 *
 * Version:  1.2
 * Created by suhler on 03/05/12
 * Last modified by suhler on 03/07/07 14:08:39
 */

package sunlabs.brazil.sunlabs;

import sunlabs.brazil.util.http.HttpUtil;
import sunlabs.brazil.template.RewriteContext;
import sunlabs.brazil.template.Template;

/**
 * Template to turn all markup between <plain> and </plain> into
 * ordinary text, by escaping all HTML markup.
 */

public class PlainTemplate extends Template  {

    public boolean
    init(RewriteContext hr) {
	hr.addClosingTag("plain");
	return true;
    }

    public void
    tag_plain(RewriteContext hr) {
	hr.accumulate(false);
	hr.nextToken();
	String plain = hr.getBody();
	hr.accumulate(true);
	hr.nextToken(); // eat the /plain
	hr.append(HttpUtil.htmlEncode(plain)); 
    }
}
