/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.ParserWrapper;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Counter {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    protected static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_BASE_URIS = true;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_LANGUAGE = true;
    protected long fElements;
    protected long fAttributes;
    protected long fCharacters;
    protected long fIgnorableWhitespace;
    protected ParserWrapper.DocumentInfo fDocumentInfo;

    public void setDocumentInfo(ParserWrapper.DocumentInfo documentInfo) {
        this.fDocumentInfo = documentInfo;
    }

    public void count(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.fElements = 0L;
                this.fAttributes = 0L;
                this.fCharacters = 0L;
                this.fIgnorableWhitespace = 0L;
                Document document = (Document)node;
                this.count(document.getDocumentElement());
                break;
            }
            case 1: {
                ++this.fElements;
                Object object = node.getAttributes();
                if (object != null) {
                    this.fAttributes += (long)object.getLength();
                }
            }
            case 5: {
                Object object;
                for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                    this.count((Node)object);
                }
                break;
            }
            case 4: {
                this.fCharacters += (long)((Text)node).getLength();
                break;
            }
            case 3: {
                if (this.fDocumentInfo == null) break;
                Text text = (Text)node;
                int n = text.getLength();
                if (this.fDocumentInfo.isIgnorableWhitespace(text)) {
                    this.fIgnorableWhitespace += (long)n;
                    break;
                }
                this.fCharacters += (long)n;
            }
        }
    }

    public void printResults(PrintWriter printWriter, String string, long l, long l2, long l3, int n) {
        printWriter.print(string);
        printWriter.print(": ");
        if (n == 1) {
            printWriter.print(l);
        } else {
            printWriter.print(l);
            printWriter.print('/');
            printWriter.print(n);
            printWriter.print('=');
            printWriter.print(l / (long)n);
        }
        printWriter.print(';');
        printWriter.print(l2);
        printWriter.print(';');
        printWriter.print(l3);
        printWriter.print(" ms (");
        printWriter.print(this.fElements);
        printWriter.print(" elems, ");
        printWriter.print(this.fAttributes);
        printWriter.print(" attrs, ");
        printWriter.print(this.fIgnorableWhitespace);
        printWriter.print(" spaces, ");
        printWriter.print(this.fCharacters);
        printWriter.print(" chars)");
        printWriter.println();
        printWriter.flush();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Counter.printUsage();
            System.exit(1);
        }
        Counter counter = new Counter();
        PrintWriter printWriter = new PrintWriter(System.out);
        ParserWrapper parserWrapper = null;
        int n = 1;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = true;
        boolean bl10 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string = stringArray[i];
            if (string.startsWith("-")) {
                String string2 = string.substring(1);
                if (string2.equals("p")) {
                    if (++i == stringArray.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    object = stringArray[i];
                    try {
                        parserWrapper = (ParserWrapper)Class.forName((String)object).newInstance();
                    }
                    catch (Exception exception) {
                        parserWrapper = null;
                        System.err.println("error: Unable to instantiate parser (" + (String)object + ")");
                    }
                    continue;
                }
                if (string2.equals("x")) {
                    if (++i == stringArray.length) {
                        System.err.println("error: Missing argument to -x option.");
                        continue;
                    }
                    object = stringArray[i];
                    try {
                        int n2 = Integer.parseInt((String)object);
                        if (n2 < 1) {
                            System.err.println("error: Repetition must be at least 1.");
                            continue;
                        }
                        n = n2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("error: invalid number (" + (String)object + ").");
                    }
                    continue;
                }
                if (string2.equalsIgnoreCase("n")) {
                    bl = string2.equals("n");
                    continue;
                }
                if (string2.equalsIgnoreCase("v")) {
                    bl2 = string2.equals("v");
                    continue;
                }
                if (string2.equalsIgnoreCase("s")) {
                    bl3 = string2.equals("s");
                    continue;
                }
                if (string2.equalsIgnoreCase("f")) {
                    bl4 = string2.equals("f");
                    continue;
                }
                if (string2.equalsIgnoreCase("hs")) {
                    bl5 = string2.equals("hs");
                    continue;
                }
                if (string2.equalsIgnoreCase("va")) {
                    bl6 = string2.equals("va");
                    continue;
                }
                if (string2.equalsIgnoreCase("dv")) {
                    bl7 = string2.equals("dv");
                    continue;
                }
                if (string2.equalsIgnoreCase("xi")) {
                    bl8 = string2.equals("xi");
                    continue;
                }
                if (string2.equalsIgnoreCase("xb")) {
                    bl9 = string2.equals("xb");
                    continue;
                }
                if (string2.equalsIgnoreCase("xl")) {
                    bl10 = string2.equals("xl");
                    continue;
                }
                if (string2.equals("h")) {
                    Counter.printUsage();
                    continue;
                }
            }
            if (parserWrapper == null) {
                try {
                    parserWrapper = (ParserWrapper)Class.forName(DEFAULT_PARSER_NAME).newInstance();
                }
                catch (Exception exception) {
                    System.err.println("error: Unable to instantiate parser (dom.wrappers.Xerces)");
                    continue;
                }
            }
            try {
                parserWrapper.setFeature(NAMESPACES_FEATURE_ID, bl);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
            }
            try {
                parserWrapper.setFeature(VALIDATION_FEATURE_ID, bl2);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
            }
            try {
                parserWrapper.setFeature(SCHEMA_VALIDATION_FEATURE_ID, bl3);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
            }
            try {
                parserWrapper.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl4);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                parserWrapper.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl5);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            try {
                parserWrapper.setFeature(VALIDATE_ANNOTATIONS_ID, bl6);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validate-annotations)");
            }
            try {
                parserWrapper.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, bl7);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
            }
            try {
                parserWrapper.setFeature(XINCLUDE_FEATURE_ID, bl8);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude)");
            }
            try {
                parserWrapper.setFeature(XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID, bl9);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
            }
            try {
                parserWrapper.setFeature(XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID, bl10);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-language)");
            }
            try {
                long l = System.currentTimeMillis();
                Document document = null;
                for (int j = 0; j < n; ++j) {
                    document = parserWrapper.parse(string);
                }
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                ParserWrapper.DocumentInfo documentInfo = parserWrapper.getDocumentInfo();
                counter.setDocumentInfo(documentInfo);
                long l4 = System.currentTimeMillis();
                counter.count(document);
                long l5 = System.currentTimeMillis();
                long l6 = l5 - l4;
                long l7 = System.currentTimeMillis();
                counter.count(document);
                long l8 = System.currentTimeMillis();
                long l9 = l8 - l7;
                counter.printResults(printWriter, string, l3, l6, l9, n);
                continue;
            }
            catch (SAXParseException sAXParseException) {
                continue;
            }
            catch (Exception exception) {
                System.err.println("error: Parse error occurred - " + exception.getMessage());
                object = exception;
                if (exception instanceof SAXException) {
                    object = ((SAXException)exception).getException();
                }
                if (object != null) {
                    ((Throwable)object).printStackTrace(System.err);
                    continue;
                }
                exception.printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java dom.Counter (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -x number   Select number of repetitions.");
        System.err.println("  -n  | -N    Turn on/off namespace processing.");
        System.err.println("  -v  | -V    Turn on/off validation.");
        System.err.println("  -s  | -S    Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xi | -XI   Turn on/off XInclude processing.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xb | -XB   Turn on/off base URI fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -xl | -XL   Turn on/off language fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     dom.wrappers.Xerces");
        System.err.println("  Repetition: 1");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:            ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:     ");
        System.err.println("off");
        System.err.print("  Validate annotations:            ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
        System.err.print("  XInclude:   ");
        System.err.println("off");
        System.err.print("  XInclude base URI fixup:  ");
        System.err.println("on");
        System.err.print("  XInclude language fixup:  ");
        System.err.println("on");
    }
}

