#!BPY
"""
Name: 'Spindle'
Blender: 248
Group: 'AddMesh'
"""
__author__ = ["Four Mad Men", "FourMadMen.com"]
__version__ = '1.00'
__url__ = ["http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Add/Spindle"]
__email__=["bwiki {at} fourmadmen {dot} com"]


__bpydoc__ = """

Usage:

* Launch from Add Mesh menu

* Modify parameters as desired or keep defaults

"""
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2008, FourMadMen.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****

import BPyAddMesh
import Blender

def add_spindle(PREF_SEG, PREF_RAD, PREF_HGT, PREF_CAP_HGT):
	Vector = Blender.Mathutils.Vector
	RotationMatrix = Blender.Mathutils.RotationMatrix
	verts = []
	faces = []
	
	tot_verts = PREF_SEG * 2 + 2
	
	half_height = PREF_HGT * .5
	
	verts.append( Vector(0, 0, half_height + PREF_CAP_HGT) )
	verts.append( Vector(0, 0, -half_height - PREF_CAP_HGT) )
	
	i = 2
	for index in xrange(PREF_SEG):
		mtx = RotationMatrix( 360 * float(index)/PREF_SEG, 3, 'z' )
		
		verts.append( Vector(PREF_RAD, 0, half_height) * mtx )
		it1 = i
		i+=1
		
		verts.append( Vector(PREF_RAD, 0, -half_height) * mtx )
		ib1 = i
		i+=1
		
		if i>4:
			faces.append( (it2, it1, 0) )
			faces.append( (it1, it2, ib2, ib1) )
			faces.append( (ib1, ib2, 1) )
		
		it2 = it1
		ib2 = ib1
		
	faces.append( (tot_verts-2, 2, 0) )
	faces.append( (3, 2, tot_verts-2, tot_verts-1) )
	faces.append( (3, tot_verts-1, 1) )
	
	return verts, faces

def main():
	Draw = Blender.Draw
	PREF_SEG = Draw.Create(32)
	PREF_RAD = Draw.Create(1.0)
	PREF_HGT = Draw.Create(1.0)
	PREF_CAP_HGT = Draw.Create(0.5)
	
	if not Draw.PupBlock('Add Spindle', [\
	('Segments:', PREF_SEG,  3, 256, 'Number of segments of the spindle'),\
	('Radius:', PREF_RAD,  0.01, 100, 'Radius of the spindle'),\
	('Height:', PREF_HGT,  0.01, 100, 'Height of the spindle'),\
	('Cap Height:', PREF_CAP_HGT,  0.01, 100, 'Cap height of the spindle'),\
	]):
		return
	
	verts, faces = add_spindle(PREF_SEG.val, PREF_RAD.val, PREF_HGT.val, PREF_CAP_HGT.val)
	
	BPyAddMesh.add_mesh_simple('Spindle', verts, [], faces)

main()

