####Arcus water-ballast system

####Information according to POH:####
#release time wings: 3.5min (210secs) for 92l (one tank)
#		-> 0.4381l per second
#			0.4381 l water = 0.96585 lbs
#capacity wings:	92l per tank (two wing tanks)
#release time wings: 2min (120secs) for 11l (one tank)
#		-> 0.09167l per second
#			0.09167 l water (kg) = 0.202098 lbs
#capacity tail:		11l (one tail tank)

###Information for flightgear configuration####
#Left wing tank:	/sim/weight[3]/weight-lb
#Right wing tank:	/sim/weight[4]/weight-lb

#set constants
var release_rate_wings = 0.96585; #lbs per second
var release_rate_tail = 0.202098; #lbs per second
var left_tank = "/sim/weight[2]/weight-lb";
var right_tank = "/sim/weight[3]/weight-lb";
var tail_tank = "/sim/weight[4]/weight-lb";
var control_prop = "controls/flight/drop-water-ballast";
var left_ps = "controls/flight/drop-water-ballast-left";
var right_ps = "controls/flight/drop-water-ballast-right";
var tail_ps = "controls/flight/drop-water-ballast-tail";

setlistener(control_prop, func{
	release();
});

var release = func () {	
	if(getprop(control_prop) == 1 ){
		#print("Releasing water ballast");
		
		var left_value = getprop(left_tank);
		if(left_value>release_rate_wings){
			setprop(left_tank, left_value-release_rate_wings);
		}else if(left_value>0){
			setprop(left_tank, 0);
		}
		
		if(left_value>0 and getprop(left_ps)!=1){
			setprop(left_ps, 1);
		}else if(left_value==0 and getprop(left_ps)==1){
			setprop(left_ps, 0);
		}
				
		var right_value = getprop(right_tank);
		if( right_value>release_rate_wings){
			setprop(right_tank, right_value-release_rate_wings);
		}else if( right_value>0 ) {
			setprop(right_tank, 0);
		}
		
		if(right_value>0 and getprop(right_ps)!=1){
			setprop(right_ps, 1);
		}else if(right_value==0 and getprop(right_ps)==1){
			setprop(right_ps, 0);
		}
		
		var tail_value = getprop(tail_tank);
		if( tail_value>release_rate_tail){
			setprop(tail_tank, tail_value-release_rate_tail);
		}else if( tail_value>0 ) {
			setprop(tail_tank, 0);
		}
		
		if(tail_value>0 and getprop(tail_ps)!=1){
			setprop(tail_ps, 1);
		}else if(tail_value==0 and getprop(tail_ps)==1){
			setprop(tail_ps, 0);
		}
		
		settimer(release, 1);
	}else{
		#print("Stopping release process");
		setprop(left_ps, 0);
		setprop(right_ps, 0);
		setprop(tail_ps, 0);
	}
}