# provides relative vectors from eye-point to aircraft lights
# in east/north/up coordinates the renderer uses
# Thanks to BAWV12 / Thorsten

# modified by Bea Wolf (D-ECHO) 03/2020: use arrays and foreach loops

var n = 4; # number of light spots

var light_manager = {

	run: 0,
	
	lat_to_m: 110952.0,
	lon_to_m: 0.0,
	
	light_is_on: [0, 0, 0, 0],
	light_r : [0.0, 0.0, 0.0, 0.0],
	light_g : [0.0, 0.0, 0.0, 0.0],
	light_b : [0.0, 0.0, 0.0, 0.0],
	
	light_size : [0.0, 0.0, 0.0, 0.0],
	light_stretch : [0.0, 0.0, 0.0, 0.0],
	
	light_xpos : [0.0, 0.0, 0.0, 0.0],
	light_ypos : [0.0, 0.0, 0.0, 0.0],
	light_zpos : [0.0, 0.0, 0.0, 0.0],
	
	flcpt: 0,
	prev_view : 1,
		
	nd_ref_light_x : [
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/eyerel-x-m[0]", 1),
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/eyerel-x-m[1]", 1),
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/eyerel-x-m[2]", 1),
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/eyerel-x-m[3]", 1),
	],
	
	nd_ref_light_y : [
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/eyerel-y-m[0]", 1),
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/eyerel-y-m[1]", 1),
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/eyerel-y-m[2]", 1),
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/eyerel-y-m[3]", 1),
	],
	
	nd_ref_light_z : [
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/eyerel-z-m[0]", 1),
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/eyerel-z-m[1]", 1),
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/eyerel-z-m[2]", 1),
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/eyerel-z-m[3]", 1),
	],
	
	nd_ref_light_dir : [
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/dir[0]", 1),
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/dir[1]", 1),
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/dir[2]", 1),
		props.globals.getNode("/sim/rendering/als-secondary-lights/lightspot/dir[3]", 1),
	],
	
	init: func {
		# define your lights here

		# lights ########
		# offsets to aircraft center
 
		me.light_xpos = [150.0, -3.3, 1.0, 1.0];
		me.light_ypos = [0.0, 0.0, 5.3, -5.3];
		me.light_zpos = [2.0, 0.0, 0.0, 0.0];
		
		# color values
		me.light_r = [0.7, 0.1, 0.2, 0.0];
		me.light_g = [0.7, 0.1, 0.0, 0.2];
		me.light_b = [0.7, 0.1, 0.0, 0.0];

		# spot size
		me.light_size = [23, 1.5, 1.5, 1.5];
		me.light_stretch = [6, 0.0, 0.0, 0.0];
		
		
		setprop("sim/rendering/als-secondary-lights/flash-radius", 13);

		me.start();
	},

	start: func {
		setprop("/sim/rendering/als-secondary-lights/num-lightspots", n);
		
		for(var x=0; x < n; x=x+1){
			setprop("/sim/rendering/als-secondary-lights/lightspot/size["~x~"]", me.light_size[x]);
			setprop("/sim/rendering/als-secondary-lights/lightspot/stretch["~x~"]", me.light_stretch[x]);
		}
 
		me.run = 1;		
		me.update();
	},

	stop: func {
		me.run = 0;
	},

	update: func {
		if (me.run == 0) {
			return;
		}
		
		als_on = getprop("/sim/rendering/shaders/skydome");
		alt_agl = getprop("/position/altitude-agl-ft");
		type_of_view = getprop("sim/current-view/internal");
		
		if (als_on == 1 and alt_agl < 100.0) {
			var land = getprop("/systems/electrical/outputs/landing-lights");
			var nav = getprop("/systems/electrical/outputs/nav-lights-norm");
			var ac = getprop("/systems/electrical/outputs/ac-lights-norm/state");
			
			var apos = geo.aircraft_position();
			var vpos = geo.viewer_position();

			me.lon_to_m = math.cos(apos.lat()*math.pi/180.0) * me.lat_to_m;

			var heading = getprop("/orientation/heading-deg") * math.pi/180.0;

			var lat = apos.lat();
			var lon = apos.lon();
			var alt = apos.alt();

			var sh = math.sin(heading);
			var ch = math.cos(heading);
		
			if (land > 10 ) {
				me.light_on(0);
			} else {
				me.light_off(0);
			}
			
			if ( ac == 1) {			
				me.light_r[2] = 0.3;
				me.light_g[2] = 0.3;
				me.light_b[2] = 0.3;
				
				me.light_r[3] = 0.3;
				me.light_g[3] = 0.3;
				me.light_b[3] = 0.3;
				
				me.light_on(1);
				me.light_on_up(2);
				me.light_on_up(3);
			} else if ( nav == 1 ) {				
				me.light_r[2] = 0.2;
				me.light_g[2] = 0.0;
				me.light_b[2] = 0.0;
				
				me.light_r[3] = 0.0;
				me.light_g[3] = 0.2;
				me.light_b[3] = 0.0;
				
				me.light_on(1);
				me.light_on_up(2);
				me.light_on_up(3);
			} else {
				me.light_off(1);
				me.light_off(2);
				me.light_off(3);
			}
			

			# light position
			var proj_z = alt_agl/10.0;
			
			for( var x = 0; x < n; x=x+1 ){
				apos.set_lat(lat + (me.light_xpos[x] * ch + me.light_ypos[x] * sh) / me.lat_to_m);
				apos.set_lon(lon + (me.light_xpos[x] * sh - me.light_ypos[x] * ch) / me.lon_to_m);
		
				delta_x = (apos.lat() - vpos.lat()) * me.lat_to_m;
				delta_y = -(apos.lon() - vpos.lon()) * me.lon_to_m;
				var delta_z = apos.alt()- proj_z - vpos.alt();
		
				me.nd_ref_light_x[x].setValue(delta_x);
				me.nd_ref_light_y[x].setValue(delta_y);
				me.nd_ref_light_z[x].setValue(delta_z);
				me.nd_ref_light_dir[x].setValue(heading);	
			}
			
		}
		
		settimer ( func me.update(), 0.0);
	},

	light_on : func (i) {
		if (me.light_is_on[i] == 1) {return;}
		setprop("/sim/rendering/als-secondary-lights/lightspot/lightspot-r["~i~"]", me.light_r[i]);
		setprop("/sim/rendering/als-secondary-lights/lightspot/lightspot-g["~i~"]", me.light_g[i]);
		setprop("/sim/rendering/als-secondary-lights/lightspot/lightspot-b["~i~"]", me.light_b[i]);
 		me.light_is_on[i] = 1;
		},
 
	light_off : func (i) {
  		if (me.light_is_on[i] == 0) {return;}
		setprop("/sim/rendering/als-secondary-lights/lightspot/lightspot-r["~i~"]", 0.0);
		setprop("/sim/rendering/als-secondary-lights/lightspot/lightspot-g["~i~"]", 0.0);
		setprop("/sim/rendering/als-secondary-lights/lightspot/lightspot-b["~i~"]", 0.0);
  		me.light_is_on[i] = 0;
		},

	light_on_up : func (i) {
		setprop("/sim/rendering/als-secondary-lights/lightspot/lightspot-r["~i~"]", me.light_r[i]);
		setprop("/sim/rendering/als-secondary-lights/lightspot/lightspot-g["~i~"]", me.light_g[i]);
		setprop("/sim/rendering/als-secondary-lights/lightspot/lightspot-b["~i~"]", me.light_b[i]);
 		me.light_is_on[i] = 1;
		},
};

light_manager.init();



