#Initialise
var engine1 = engines.Turboprop.new(0, 0, 0);
var engine2 = engines.Turboprop.new(1, 0, 0);
var engine3 = engines.Turboprop.new(2, 0, 0);
var engine4 = engines.Turboprop.new(3, 0, 0);

engine1.init();
engine2.init();
engine3.init();
engine4.init();

props.globals.initNode("/sim/autostart/started", 0, "BOOL");

var eng1fuelon = func { setprop("/controls/engines/engine[0]/cutoff", 0); }
var eng2fuelon = func { setprop("/controls/engines/engine[1]/cutoff", 0); }
var eng3fuelon = func { setprop("/controls/engines/engine[2]/cutoff", 0); }
var eng4fuelon = func { setprop("/controls/engines/engine[3]/cutoff", 0); }

var eng1fueloff = func { setprop("/controls/engines/engine[0]/cutoff", 1); }
var eng2fueloff = func { setprop("/controls/engines/engine[1]/cutoff", 1); }
var eng3fueloff = func { setprop("/controls/engines/engine[2]/cutoff", 1); }
var eng4fueloff = func { setprop("/controls/engines/engine[3]/cutoff", 1); }

var eng1starter = func { setprop("/controls/engines/engine[0]/starter", 1); }
var eng2starter = func { setprop("/controls/engines/engine[1]/starter", 1); }
var eng3starter = func { setprop("/controls/engines/engine[2]/starter", 1); }
var eng4starter = func { setprop("/controls/engines/engine[3]/starter", 1); }

var eng1stop    = func { setprop("/controls/engines/engine[0]/starter", 0); }
var eng2stop    = func { setprop("/controls/engines/engine[1]/starter", 0); }
var eng3stop    = func { setprop("/controls/engines/engine[2]/starter", 0); }
var eng4stop    = func { setprop("/controls/engines/engine[3]/starter", 0); }

var eng1start = func {
  gui.popupTip("*** Engine start 1 left exterior  ***");
  eng1fuelon();
  eng1starter();
  settimer(eng1fuelon, 2);
  setprop("/controls/engines/engine[0]/throttle", 0.1);
  setprop("/controls/engines/engine[0]/condition", 1);
}

var eng2start = func {
  gui.popupTip("*** Engine start 2 left interior ***");
  eng2fuelon();
  eng2starter();
  settimer(eng2fuelon, 2);
  setprop("/controls/engines/engine[1]/throttle", 0.1);
  setprop("/controls/engines/engine[1]/condition", 1);
}

var eng3start = func {
  gui.popupTip("*** Engine start 3 right interior ***");
  eng3fuelon();
  eng3starter();
  settimer(eng3fuelon, 2);
  setprop("/controls/engines/engine[2]/throttle", 0.1);
  setprop("/controls/engines/engine[2]/condition", 1);
}

var eng4start = func {
  gui.popupTip("*** Engine start 4 right exterior ***");
  eng4fuelon();
  eng4starter();
  settimer(eng4fuelon, 2);
  setprop("/controls/engines/engine[3]/throttle", 0.1);
  setprop("/controls/engines/engine[3]/condition", 1);
}

var engstart = func {
  setprop("/controls/electric/battery-switch", 1);
  setprop("/controls/switches/gauge-light", 1);
  setprop("/controls/lighting/nav-lights", 1);
  setprop("sim/messages/copilot", "Main power and lights are on");
  setprop("/instrumentation/adf[0]/power-btn", 1);
  setprop("/instrumentation/adf[1]/power-btn", 1);
  setprop("/instrumentation/heading-indicator[0]/serviceable", 1);
  setprop("/instrumentation/nav[0]/power-btn", 1);
  setprop("/instrumentation/nav[1]/power-btn", 1);
  setprop("/instrumentation/transponder/serviceable", 1);
  setprop("/controls/switches/fuel", 1);
  setprop("/consumables/fuel/tank[0]/selected", 1);
  setprop("/consumables/fuel/tank[1]/selected", 1);
  setprop("/consumables/fuel/tank[2]/selected", 1);
  setprop("/consumables/fuel/tank[3]/selected", 1);

  setprop("sim/messages/copilot", "Instruments are powered");

  settimer(eng1start, 1);
  settimer(eng4start, 8);
  settimer(eng2start, 16);
  settimer(eng3start, 24);
}

var engstop = func {
  eng1fueloff();
  eng1stop();
  setprop("/controls/engines/engine[0]/throttle", 0);
  setprop("/controls/engines/engine[0]/condition", 0);
  eng2fueloff();
  eng2stop();
  setprop("/controls/engines/engine[1]/throttle", 0);
  setprop("/controls/engines/engine[1]/condition", 0);
  eng3fueloff();
  eng3stop();
  setprop("/controls/engines/engine[2]/throttle", 0);
  setprop("/controls/engines/engine[2]/condition", 0);
  eng4fueloff();
  eng4stop();
  setprop("/controls/engines/engine[3]/throttle", 0);
  setprop("/controls/engines/engine[3]/condition", 0);

  setprop("/controls/electric/battery-switch", 1);
  setprop("/controls/switches/gauge-light", 0);
  setprop("/controls/lighting/nav-lights", 0);
  setprop("sim/messages/copilot", "Main power and lights are off");
  setprop("/instrumentation/adf[0]/power-btn", 0);
  setprop("/instrumentation/adf[1]/power-btn", 0);
  setprop("/instrumentation/heading-indicator[0]/serviceable", 0);
  setprop("/instrumentation/nav[0]/power-btn", 0);
  setprop("/instrumentation/nav[1]/power-btn", 0);
  setprop("/instrumentation/transponder/serviceable", 0);
  setprop("/controls/switches/fuel", 0);
  setprop("/consumables/fuel/tank[0]/selected", 0);
  setprop("/consumables/fuel/tank[1]/selected", 0);
  setprop("/consumables/fuel/tank[2]/selected", 0);
  setprop("/consumables/fuel/tank[3]/selected", 0);

  setprop("sim/messages/copilot", "Instruments are unpowered");
}

var autostart = func {
  var startstatus = getprop("/sim/autostart/started");
  if ( startstatus == 0 ) {
    gui.popupTip("Autostarting...");
    setprop("/sim/model/autostart", 1);
    setprop("/sim/autostart/started", 1);
    settimer(engstart, 0.4);
    gui.popupTip("Starting Engines");
  }
  if ( startstatus == 1 ) {
    gui.popupTip("Shutting Down...");
    setprop("/sim/model/autostart", 0);
    setprop("/sim/autostart/started", 0);
    engstop();
  }
}
