# Q400 MFD/EFIS by D-ECHO based on
# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

#sources: http://www.smartcockpit.com/docs/Q400-Power_Plant.pdf https://quizlet.com/2663067/q400-limitations-flash-cards/ http://www.smartcockpit.com/docs/Q400-Indicating_and_Recording_Systems.pdf

var arcdu_first = nil;
var arcdu_selftest = nil;
var arcdu_display = nil;
var page = "first";

var frequencies = {
	comm: [
		{	active:		props.globals.getNode( "instrumentation/comm[0]/frequencies/selected-mhz" ),
			standby:	props.globals.getNode( "instrumentation/comm[0]/frequencies/standby-mhz"  ),
		},
		{	active:		props.globals.getNode( "instrumentation/comm[1]/frequencies/selected-mhz" ),
			standby:	props.globals.getNode( "instrumentation/comm[1]/frequencies/standby-mhz"  ),
		},
	],
	nav: [
		{	active:		props.globals.getNode( "instrumentation/nav[0]/frequencies/selected-mhz" ),
			standby:	props.globals.getNode( "instrumentation/nav[0]/frequencies/standby-mhz"  ),
		},
		{	active:		props.globals.getNode( "instrumentation/nav[1]/frequencies/selected-mhz" ),
			standby:	props.globals.getNode( "instrumentation/nav[1]/frequencies/standby-mhz"  ),
		},
	],
	adf: [
		{	active:		props.globals.getNode( "instrumentation/adf[0]/frequencies/selected-khz" ),
			standby:	props.globals.getNode( "instrumentation/adf[0]/frequencies/standby-khz"  ),
		},
		{	active:		props.globals.getNode( "instrumentation/adf[1]/frequencies/selected-khz" ),
			standby:	props.globals.getNode( "instrumentation/adf[1]/frequencies/standby-khz"  ),
		},
	],
};
var volumes = {
	comm: [
		props.globals.getNode( "instrumentation/comm[0]/volume" ),
		props.globals.getNode( "instrumentation/comm[1]/volume" ),
	],
	nav: [
		props.globals.initNode( "instrumentation/nav[0]/volume", 0.0, "DOUBLE"),
		props.globals.initNode( "instrumentation/nav[1]/volume", 0.0, "DOUBLE"),
	],
	adf: [
		props.globals.initNode( "instrumentation/adf[0]/volume", 0.0, "DOUBLE"),
		props.globals.initNode( "instrumentation/adf[1]/volume", 0.0, "DOUBLE"),
	],
};
var nav_loc = [
	props.globals.getNode("instrumentation/nav[0]/nav-loc"),
	props.globals.getNode("instrumentation/nav[1]/nav-loc"),
];
var atc = {
	active_code: [
		props.globals.getNode("instrumentation/transponder[0]/id-code"),
		props.globals.getNode("instrumentation/transponder[1]/id-code"),
	],
	standby_code: [
		props.globals.initNode("instrumentation/transponder[0]/stby-code", 0, "INT"),
		props.globals.initNode("instrumentation/transponder[1]/stby-code", 0, "INT"),
	],
	knob_mode: [
		props.globals.getNode("instrumentation/transponder[0]/inputs/knob-mode"),
		props.globals.getNode("instrumentation/transponder[1]/inputs/knob-mode"),
	],
};

var volts = props.globals.getNode("/systems/electrical/DC/lessential-bus/volts");	# temp; TODO: find better solution for volt handling: ARCDUs are powered by both the Left Essential as well as the Right Main Bus
var volts_essential_bus_left = props.globals.getNode("/systems/electrical/DC/lessential-bus/volts");
var volts_main_bus_right = props.globals.getNode("/systems/electrical/DC/rmain-bus/volts");


var canvas_arcdu_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Regular.ttf";
		};

		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});
		
		var svg_keys = me.getKeys();
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
		}
		
		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var powered = ( volts_essential_bus_left.getDoubleValue() > 10 or volts_main_bus_right.getDoubleValue() > 10 );
		if ( powered and getprop("/instrumentation/arcdu/selftest")==0) {
			arcdu_first.page.show();
			arcdu_first.update();
			arcdu_selftest.page.hide();
		}else if( powered and getprop("/instrumentation/arcdu/selftest")==1){
			arcdu_selftest.page.show();
			arcdu_first.page.hide();
		} else {
			arcdu_first.page.hide();
			arcdu_selftest.page.hide();
		}
	},
};
var canvas_arcdu_selftest = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_arcdu_selftest,canvas_arcdu_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
	},
};

var selected_previous = -1;
var nav_loc_previous = [ -1, -1 ];

var canvas_arcdu_first = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_arcdu_first,canvas_arcdu_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["vhf1.act","vhf1.prst","vhf1.box","vhf1.vol.bar","vhf2.vol.bar","atc1.act","atc1.text","atc1.box","atc1.prst","vhf2.vol.bar","vor1.flag","vor1.act","vor1.prst","vor1.box","vor2.flag","vor2.act","vor2.prst","vor1.vol.bar","vor2.vol.bar","vhf2.prst","vhf2.act","vhf2.box","vor2.box","ils1.flag","ils2.flag","adf1.act","adf1.prst","adf2.act","adf2.prst","adf1.vol.bar","adf2.vol.bar","adf1.box","adf2.box","dimbrt"];
	},
	update: func() {		
		var selected_field=getprop("/instrumentation/arcdu/lh-selected") or 0;
		if( selected_field != selected_previous ){
			selected_previous = selected_field;
			if(selected_field==1){
				me["vhf1.box"].show();
				me["vhf1.prst"].setColor(0,0,0);
				me["vhf2.box"].hide();
				me["vhf2.prst"].setColor(0,1,0);
				me["vor1.box"].hide();
				me["vor1.prst"].setColor(0,1,0);
				me["vor2.box"].hide();
				me["vor2.prst"].setColor(0,1,0);
				me["adf1.box"].hide();
				me["adf1.prst"].setColor(0,1,0);
				me["adf2.box"].hide();
				me["adf2.prst"].setColor(0,1,0);
				me["dimbrt"].hide();
				me["atc1.box"].hide();
				me["atc1.prst"].setColor(0,1,1);
			}else if(selected_field==2){
				me["vhf1.box"].hide();
				me["vhf1.prst"].setColor(0,1,0);
				me["vhf2.box"].show();
				me["vhf2.prst"].setColor(0,0,0);
				me["vor1.box"].hide();
				me["vor1.prst"].setColor(0,1,0);
				me["vor2.box"].hide();
				me["vor2.prst"].setColor(0,1,0);
				me["adf1.box"].hide();
				me["adf1.prst"].setColor(0,1,0);
				me["adf2.box"].hide();
				me["adf2.prst"].setColor(0,1,0);
				me["dimbrt"].hide();
				me["atc1.box"].hide();
				me["atc1.prst"].setColor(0,1,1);
			}else if(selected_field==3){
				me["vhf1.box"].hide();
				me["vhf1.prst"].setColor(0,1,0);
				me["vhf2.box"].hide();
				me["vhf2.prst"].setColor(0,1,0);
				me["vor1.box"].show();
				me["vor1.prst"].setColor(0,0,0);
				me["vor2.box"].hide();
				me["vor2.prst"].setColor(0,1,0);
				me["adf1.box"].hide();
				me["adf1.prst"].setColor(0,1,0);
				me["adf2.box"].hide();
				me["adf2.prst"].setColor(0,1,0);
				me["dimbrt"].hide();
				me["atc1.box"].hide();
				me["atc1.prst"].setColor(0,1,1);
			}else if(selected_field==4){
				me["vhf1.box"].hide();
				me["vhf1.prst"].setColor(0,1,0);
				me["vhf2.box"].hide();
				me["vhf2.prst"].setColor(0,1,0);
				me["vor1.box"].hide();
				me["vor1.prst"].setColor(0,1,0);
				me["vor2.box"].show();
				me["vor2.prst"].setColor(0,0,0);
				me["adf1.box"].hide();
				me["adf1.prst"].setColor(0,1,0);
				me["adf2.box"].hide();
				me["adf2.prst"].setColor(0,1,0);
				me["dimbrt"].hide();
				me["atc1.box"].hide();
				me["atc1.prst"].setColor(0,1,1);
			}else if(selected_field==5){
				me["vhf1.box"].hide();
				me["vhf1.prst"].setColor(0,1,0);
				me["vhf2.box"].hide();
				me["vhf2.prst"].setColor(0,1,0);
				me["vor1.box"].hide();
				me["vor1.prst"].setColor(0,1,0);
				me["vor2.box"].hide();
				me["vor2.prst"].setColor(0,1,0);
				me["adf1.box"].show();
				me["adf1.prst"].setColor(0,0,0);
				me["adf2.box"].hide();
				me["adf2.prst"].setColor(0,1,0);
				me["dimbrt"].hide();
				me["atc1.box"].hide();
				me["atc1.prst"].setColor(0,1,1);
			}else if(selected_field==6){
				me["vhf1.box"].hide();
				me["vhf1.prst"].setColor(0,1,0);
				me["vhf2.box"].hide();
				me["vhf2.prst"].setColor(0,1,0);
				me["vor1.box"].hide();
				me["vor1.prst"].setColor(0,1,0);
				me["vor2.box"].hide();
				me["vor2.prst"].setColor(0,1,0);
				me["adf1.box"].hide();
				me["adf1.prst"].setColor(0,1,0);
				me["adf2.box"].show();
				me["adf2.prst"].setColor(0,0,0);
				me["dimbrt"].hide();
				me["atc1.box"].hide();
				me["atc1.prst"].setColor(0,1,1);
			}else if(selected_field==7){
				me["vhf1.box"].hide();
				me["vhf1.prst"].setColor(0,1,0);
				me["vhf2.box"].hide();
				me["vhf2.prst"].setColor(0,1,0);
				me["vor1.box"].hide();
				me["vor1.prst"].setColor(0,1,0);
				me["vor2.box"].hide();
				me["vor2.prst"].setColor(0,1,0);
				me["adf1.box"].hide();
				me["adf1.prst"].setColor(0,1,0);
				me["adf2.box"].hide();
				me["adf2.prst"].setColor(0,1,0);
				me["dimbrt"].show();
				me["atc1.box"].hide();
				me["atc1.prst"].setColor(0,1,1);
			}else if(selected_field==8){
				me["vhf1.box"].hide();
				me["vhf1.prst"].setColor(0,1,0);
				me["vhf2.box"].hide();
				me["vhf2.prst"].setColor(0,1,0);
				me["vor1.box"].hide();
				me["vor1.prst"].setColor(0,1,0);
				me["vor2.box"].hide();
				me["vor2.prst"].setColor(0,1,0);
				me["adf1.box"].hide();
				me["adf1.prst"].setColor(0,1,0);
				me["adf2.box"].hide();
				me["adf2.prst"].setColor(0,1,0);
				me["dimbrt"].hide();
				me["atc1.box"].show();
				me["atc1.prst"].setColor(0,0,0);
			}else{
				me["vhf1.box"].hide();
				me["vhf1.prst"].setColor(0,1,0);
				me["vhf2.box"].hide();
				me["vhf2.prst"].setColor(0,1,0);
				me["vor1.box"].hide();
				me["vor1.prst"].setColor(0,1,0);
				me["vor2.box"].hide();
				me["vor2.prst"].setColor(0,1,0);
				me["adf1.box"].hide();
				me["adf1.prst"].setColor(0,1,0);
				me["adf2.box"].hide();
				me["adf2.prst"].setColor(0,1,0);
				me["dimbrt"].hide();
				me["atc1.box"].hide();
				me["atc1.prst"].setColor(0,1,1);
			}
		}
			
		#VHF1
		me["vhf1.act"].setText(		sprintf("%3.3f", frequencies.comm[0].active.getDoubleValue() ));
		me["vhf1.prst"].setText(	sprintf("%3.3f", frequencies.comm[0].standby.getDoubleValue() ));
		me["vhf1.vol.bar"].setTranslation(0, volumes.comm[0].getDoubleValue() * (-133) );
		#VHF2
		me["vhf2.act"].setText(		sprintf("%3.3f", frequencies.comm[1].active.getDoubleValue() ));
		me["vhf2.prst"].setText(	sprintf("%3.3f", frequencies.comm[1].standby.getDoubleValue() ));
		me["vhf2.vol.bar"].setTranslation(0, volumes.comm[1].getDoubleValue() * (-133) );
		
		#VOR/ILS 1
		me["vor1.act"].setText(		sprintf("%3.3f", frequencies.nav[0].active.getDoubleValue() ));
		me["vor1.prst"].setText(	sprintf("%3.3f", frequencies.nav[0].standby.getDoubleValue() ));
		me["vor1.vol.bar"].setTranslation(0, volumes.nav[0].getDoubleValue() * (-133) );
		var vor1_localizer = nav_loc[0].getIntValue();
		if( vor1_localizer != nav_loc_previous ){
			nav_loc_previous = vor1_localizer;
			if( vor1_localizer == 1 ){
				me["vor1.flag"].hide();
				me["ils1.flag"].show();
			}else{	
				me["vor1.flag"].show();
				me["ils1.flag"].hide();
			}
		}
		#VOR/ILS 2
		me["vor2.act"].setText(		sprintf("%3.3f", frequencies.nav[1].active.getDoubleValue() ));
		me["vor2.prst"].setText(	sprintf("%3.3f", frequencies.nav[1].standby.getDoubleValue() ));
		me["vor2.vol.bar"].setTranslation(0, volumes.nav[1].getDoubleValue() * (-133) );
		var vor2_localizer = nav_loc[0].getIntValue();
		if( vor2_localizer != nav_loc_previous ){
			nav_loc_previous = vor2_localizer;
			if( vor2_localizer == 1 ){
				me["vor1.flag"].hide();
				me["ils1.flag"].show();
			}else{	
				me["vor1.flag"].show();
				me["ils1.flag"].hide();
			}
		}
		
		#ADF 1
		me["adf1.act"].setText(		sprintf("%3d", frequencies.adf[0].active.getDoubleValue() ));
		me["adf1.prst"].setText(	sprintf("%3d", frequencies.adf[0].standby.getDoubleValue() ));
		me["adf1.vol.bar"].setTranslation(0, volumes.adf[0].getDoubleValue() * (-133) );
		#ADF 2
		me["adf2.act"].setText(		sprintf("%3d", frequencies.adf[1].active.getDoubleValue() ));
		me["adf2.prst"].setText(	sprintf("%3d", frequencies.adf[1].standby.getDoubleValue() ));
		me["adf2.vol.bar"].setTranslation(0, volumes.adf[1].getDoubleValue() * (-133) );
		
		#ATC1 (TRANSPONDER)
		me["atc1.act"].setText(sprintf("%04d", atc.active_code[0].getIntValue() ) );
		var transponder_mode = atc.knob_mode[0].getIntValue();
		if(transponder_mode==0){
			me["atc1.text"].setText("OFF");
		}else if(transponder_mode==1){
			me["atc1.text"].setText("STBY");
		}else if(transponder_mode==2){
			me["atc1.text"].setText("TEST");
		}else if(transponder_mode==3){
			me["atc1.text"].setText("GND");
		}else if(transponder_mode==4){
			me["atc1.text"].setText("ON");
		}else if(transponder_mode==5){
			me["atc1.text"].setText("ON ALT");
		}else{
			me["atc1.text"].setText("XXXX");
		}
		me["atc1.prst"].setText(sprintf("%04d", atc.standby_code[0].getIntValue() ) );
	},
};

var arcdu_update = maketimer( 0.1, func() { canvas_arcdu_base.update() } );
arcdu_update.simulatedTime = 1;

setlistener("sim/signals/fdm-initialized", func {
	arcdu_display = canvas.new({
		"name": "arcdu",
		"size": [512, 512],
		"view": [512, 512],
		"mipmapping": 1
	});
	arcdu_display.addPlacement({"node": "arcdu1.display"});
	arcdu_display.addPlacement({"node": "arcdu2.display"});
	var grouparcdufirst = arcdu_display.createGroup();
	var grouparcduselftest = arcdu_display.createGroup();

	arcdu_first = canvas_arcdu_first.new(grouparcdufirst, "Aircraft/QSeries/Models/Cockpit/Instruments/ARCDU/ARCDU.svg");
	arcdu_selftest = canvas_arcdu_selftest.new(grouparcduselftest, "Aircraft/QSeries/Models/Cockpit/Instruments/ARCDU/ARCDU.selftest.svg");

	arcdu_update.start();
});

var showarcdu = func {
	var dlg = canvas.Window.new([512, 512], "dialog").set("resize", 1);
	dlg.setCanvas(arcdu_display);
}

setlistener(volts, func (i){
	if( volts.getDoubleValue() == 0 and getprop("/instrumentation/arcdu/was_0")!=1){
		setprop("/instrumentation/arcdu/was_0", 1);
	}
	if( volts.getDoubleValue() != 0 and getprop("/instrumentation/arcdu/was_0")==1){
		setprop("/instrumentation/arcdu/was_0", 0);
		setprop("/instrumentation/arcdu/selftest", 1);
		settimer( func(){ setprop("/instrumentation/arcdu/selftest", 0); }, 5);
	}
});
	
