#		COMMON.NAS: Common Functions for all DHC8 models

#gui.menuBind("fuel-and-payload", "dialogs.fuelPayload.toggle();");


#	HackCanvas - based on work by Octal450 for the MD-11

canvas.Text._lastText = canvas.Text["_lastText"];
canvas.Text.setText = func(text) {
	if (text == me._lastText and text != nil and size(text) == size(me._lastText)) {
		return me;
	}
	me._lastText = text;
	me.set("text", typeof(text) == "scalar" ? text : "");
};
canvas.Element._lastVisible = nil;
canvas.Element.show = func() {
	if (1 == me._lastVisible) {
		return me;
	}
	me._lastVisible = 1;
	me.setBool("visible", 1);
};
canvas.Element.hide = func() {
	if (0 == me._lastVisible) {
		return me;
	}
	me._lastVisible = 0;
	me.setBool("visible", 0);
};
canvas.Element.setVisible = func(vis) {
	if (vis == me._lastVisible) {
		return me;
	}
	me._lastVisible = vis;
	me.setBool("visible", vis);
};

#	Livery Setup

aircraft.livery.init("Aircraft/QSeries/Models/Liveries/"~ getprop("/sim/aero") );


#	Doors

var doors = {
	passengerF:		aircraft.door.new("/sim/model/door-positions/passengerF",  5, 0 ),
	passengerLH:	aircraft.door.new("/sim/model/door-positions/passengerLH", 5, 0 ),
	cargo:		aircraft.door.new("/sim/model/door-positions/cargo",       5, 0 ),
	passengerRH:	aircraft.door.new("/sim/model/door-positions/passengerRH", 5, 0 ),
	passengerRF:	aircraft.door.new("/sim/model/door-positions/passengerRF", 5, 0 ),
	flightdeck:		aircraft.door.new("/sim/model/door-positions/fd",          5, 0 ),
};


#	Visual Effects

# Tyre Smoke
aircraft.tyresmoke_system.new(0, 1, 2);
# Rain
aircraft.rain.init();
var raintimer = maketimer(0, func(){ aircraft.rain.update(); } );
raintimer.start();


#	Common Listeners

setlistener("/controls/engines/engine[0]/condition-lever-state", func (x) {
	if(x.getValue()==0){ #CUTOFF
		setprop("/controls/engines/engine[0]/cutoff-cmd", 1);
		setprop("/controls/engines/engine[0]/condition", 0);
		setprop("/controls/engines/engine[0]/propeller-feather", 0);
	}else if(x.getValue()==1){ #START&FEATHER
		setprop("/controls/engines/engine[0]/cutoff-cmd", 0);
		setprop("/controls/engines/engine[0]/condition", 0.5);
		setprop("/controls/engines/engine[0]/propeller-feather", 1);
	}else if(x.getValue()==2){ #free movement from min (900) to max (1020)
		setprop("/controls/engines/engine[0]/cutoff-cmd", 0);
		setprop("/controls/engines/engine[0]/condition", 1);
		setprop("/controls/engines/engine[0]/propeller-feather", 0);
	}
});

setlistener("/controls/engines/engine[1]/condition-lever-state", func (i) {
	if(i.getValue()==0){ #CUTOFF
		setprop("/controls/engines/engine[1]/cutoff-cmd", 1);
		setprop("/controls/engines/engine[1]/condition", 0);
		setprop("/controls/engines/engine[1]/propeller-feather", 0);
	}else if(i.getValue()==1){ #START&FEATHER
		setprop("/controls/engines/engine[1]/cutoff-cmd", 0);
		setprop("/controls/engines/engine[1]/condition", 0.5);
		setprop("/controls/engines/engine[1]/propeller-feather", 1);
	}else if(i.getValue()==2){ #free movement from min (900) to max (1020)
		setprop("/controls/engines/engine[1]/cutoff-cmd", 0);
		setprop("/controls/engines/engine[1]/condition", 1);
		setprop("/controls/engines/engine[1]/propeller-feather", 0);
	}
});

var gear_selector = props.globals.getNode("/controls/gear/gear-down");
var no_smoking_sw = props.globals.getNode("/controls/cabin/no-smoking-sw");
var no_smoking = props.globals.initNode("/controls/cabin/no-smoking", 0, "BOOL");

setlistener( gear_selector, func{
	if( gear_selector.getBoolValue() or no_smoking_sw.getBoolValue() ){
		no_smoking.setBoolValue( 1 );
	} else {
		no_smoking.setBoolValue( 0 );
	}
});
setlistener( no_smoking_sw, func{
	if( gear_selector.getBoolValue() or no_smoking_sw.getBoolValue() ){
		no_smoking.setBoolValue( 1 );
	} else {
		no_smoking.setBoolValue( 0 );
	}
});

var gear_pos_front = props.globals.getNode("/gear/gear[0]/position-norm");
var taxi_light_sw = props.globals.getNode("/controls/lighting/taxi-light-sw");
var taxi_light = props.globals.getNode("/controls/lighting/taxi-light");

setlistener( gear_pos_front, func{
	if( taxi_light_sw.getBoolValue() and gear_pos_front.getDoubleValue() > 0.99 ){
		taxi_light.setBoolValue( 1 );
	} else {
		taxi_light.setBoolValue( 0 );
	}
});
setlistener( taxi_light_sw, func{
	if( taxi_light_sw.getBoolValue() and gear_pos_front.getDoubleValue() > 0.99 ){
		taxi_light.setBoolValue( 1 );
	} else {
		taxi_light.setBoolValue( 0 );
	}
});

# Parking/Emergency Brake interpolation
setlistener("/controls/gear/brake-parking", func(v) {
	if(v.getValue()){
		interpolate("/controls/gear/brake-parking-position", 1, 0.5);
	}else{
		interpolate("/controls/gear/brake-parking-position", 0, 0.5);
	}
});

# Throttle lock interpolation
setlistener("/controls/engines/throttle-lock", func(v) {
	if(v.getValue()){
		interpolate("/controls/engines/throttle-lock-position", 1, 0.5);
	}else{
		interpolate("/controls/engines/throttle-lock-position", 0, 0.5);
	}
});

# Reverser interpolation
setlistener("/controls/engines/engine[0]/reverser", func(v) {
	if(v.getValue()){
		interpolate("/controls/engines/engine[0]/reverser-position", 1, 0.5);
	}else{
		interpolate("/controls/engines/engine[0]/reverser-position", 0, 0.5);
	}
});
setlistener("/controls/engines/engine[1]/reverser", func(v) {
	if(v.getValue()){
		interpolate("/controls/engines/engine[1]/reverser-position", 1, 0.5);
	}else{
		interpolate("/controls/engines/engine[1]/reverser-position", 0, 0.5);
	}
});

# Condition Lever State Information Popup
setlistener("/controls/engines/engine[0]/condition-lever-state", func(i){
	condStateInfo();
	if(i.getValue() != 2){
		setprop("/controls/engines/engine[0]/condition-lever-set", 0);
	}
});

setlistener("/controls/engines/engine[1]/condition-lever-state", func(i){
	condStateInfo();
	if(i.getValue() != 2){
		setprop("/controls/engines/engine[1]/condition-lever-set", 0);
	}
});

var condStateInfo = func{
	if(getprop("/sim/q400/popups-enabled")==1){
		var condstateL=getprop("/controls/engines/engine[0]/condition-lever-state");
		if(condstateL==0){
			var condstateL2="FUEL OFF";
		}else if(condstateL==1){
			var condstateL2="START AND FEATHER";
		}else if(condstateL==2){
			var condstateL2="NORMAL";
		}else{
			var condstateL2="INVALID";
		}
		var condstateR=getprop("/controls/engines/engine[1]/condition-lever-state");
		if(condstateR==0){
			var condstateR2="FUEL OFF";
		}else if(condstateR==1){
			var condstateR2="START AND FEATHER";
		}else if(condstateR==2){
			var condstateR2="NORMAL";
		}else{
			var condstateR2="INVALID";
		}
		gui.popupTip("CONDITION L: "~condstateL2~"\nCONDITION R: "~condstateR2);
	}
}

# Starter Switch Logic

var starter_internal_sel	= props.globals.getNode("/controls/engines/internal-engine-starter-selector", 1);
var starter_internal		= props.globals.getNode("/controls/engines/internal-engine-starter", 1);
var starter_sel			= props.globals.getNode("/controls/engines/start-select", 1);
var starter_sel_btn		= props.globals.getNode("/controls/engines/start-select-btn", 1);

var eng_running = [
	props.globals.getNode("/engines/engine[0]/running", 1),
	props.globals.getNode("/engines/engine[1]/running", 1),
];

var check_starter_status = func{
	
	if( starter_internal_sel.getIntValue() == 0 ){
		starter_internal.setIntValue( 0 );
		starter_sel_btn.setIntValue( 0 );
	} else {
		if( starter_internal.getIntValue() == 0 ){
			starter_sel_btn.setIntValue( 1 );
		} else {
			starter_sel_btn.setIntValue( 2 );
		}
	}
	
}

setlistener( starter_internal_sel, func{
	check_starter_status();
});
setlistener( starter_internal, func{
	check_starter_status();
});

var check_eng_running = func{
	if( eng_running[0].getBoolValue() and starter_internal.getIntValue() == 1 ){
		starter_internal_sel.setIntValue( 0 );
	}
	if( eng_running[1].getBoolValue() and starter_internal.getIntValue() == -1 ){
		starter_internal_sel.setIntValue( 0 );
	}
}
var check_eng_running_loop = maketimer( 0.5, check_eng_running );
check_eng_running_loop.simulatedTime = 1;
check_eng_running_loop.start();

setlistener(starter_sel, func{
	if( getprop("/systems/electrical/DC/lmain-bus/volts") > 20 ){
		starter_internal.setIntValue( starter_internal_sel.getIntValue() );
	}
});
