#	Reference: https://www.elektro-ul.de/display-3-5.html

var eng_display_main = nil;
var eng_display_display = nil;

var indicators = {
	voltage:	props.globals.getNode("/systems/electrical/engine-bus/volts", 1),
	current:	props.globals.getNode("/systems/electrical/engine-bus/amps", 1),
	rpm:		props.globals.getNode("/engines/engine[0]/rpm", 1),
	power:		props.globals.getNode("/fdm/jsbsim/propulsion/engine[0]/power-hp", 1),
	reg_temp:	props.globals.initNode("/engines/engine[0]/regulator-temp-degc", 15.0, "DOUBLE"),
	eng_temp:	props.globals.initNode("/engines/engine[0]/engine-temp-degc", 15.0, "DOUBLE"),
};

var volts = props.globals.getNode("systems/electrical/outputs/eng_display", 1);

var instrument_dir = "Aircraft/Song-120/Models/Instruments/eng_display/";

var status = 0;		# 0 = off; 1 = starting; 2 = on

var starting = maketimer( 1.5, func() { status = 2 } );
starting.singleShot = 1;

var canvas_eng_display_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			if( find( "Liberation Mono", family ) != -1 ){
				if (weight == "bold"){
					return "LiberationFonts/LiberationMono-Bold.ttf";
				}elsif(weight == "normal"){
					return "LiberationFonts/LiberationMono-Regular.ttf";
				}
			}elsif( family == "'Liberation Sans'" ){
				if (weight == "bold"){
					return "LiberationFonts/LiberationSans-Bold.ttf";
				}elsif(weight == "normal"){
					return "LiberationFonts/LiberationSans-Regular.ttf";
				}
			}elsif( family == "'Liberation Serif'" ){
				if (weight == "bold"){
					return "LiberationFonts/LiberationSerif-Bold.ttf";
				}elsif(weight == "normal"){
					return "LiberationFonts/LiberationSerif-Regular.ttf";
				}
			} else {
				print( "No matching Font found: " );
				debug.dump( caller(0) );
				debug.dump( caller(1) );
				debug.dump( caller(2) );
				debug.dump( caller(3) );
				print( family );
				print( weight );
				return "LiberationFonts/LiberationSans-Regular.ttf";
			}
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if ( volts.getDoubleValue() > 9.0 ){
			if( status == 0 ){
				status = 1;
				starting.start();
				page = 0;
			}
		} elsif( status != 0 ){
			status = 0;
			page = 0;
		}
		
		if ( status > 0 ) {
			eng_display_main.page.show();
			eng_display_main.update();
		} else{
			eng_display_main.page.hide();
		}
	},
};

var canvas_eng_display_main = 	{
	new: func(canvas_group, file) {
		var m = { parents: [canvas_eng_display_main , canvas_eng_display_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["voltage", "current", "rpm", "power", "reg_temp", "eng_temp", "capacity", "capacity.green", "capacity.yellow", "capacity.red"];
	},
	update: func() {
		me["voltage"].setText( sprintf("%3.1f", indicators.voltage.getDoubleValue() ) ~ " V" );
		me["current"].setText( sprintf("%3.1f", indicators.current.getDoubleValue() ) ~ " A" );
		me["rpm"].setText( sprintf("%4d", math.round( indicators.rpm.getDoubleValue() ) ) );
		me["power"].setText( sprintf("%3d", math.round( 100 * ( indicators.power.getDoubleValue() / 26.82 ) ) ) ~ " %" );
		me["reg_temp"].setText( sprintf("%3d", math.round( indicators.reg_temp.getDoubleValue() ) ) ~ " C" );
		me["eng_temp"].setText( sprintf("%3d", math.round( indicators.eng_temp.getDoubleValue() ) ) ~ " C" );
		var cap = song_120.battery_main.charge;
		me["capacity"].setText( sprintf("%3d", math.round( 100 * cap ) ) ~ " %" );
		if( cap < 0.1 ){
			me["capacity.red"].setTranslation( ( 0.1 - cap ) * -460, 0 );
		}
		if( cap < 0.2 ){
			me["capacity.yellow"].setTranslation( ( 0.2 - cap ) * -460, 0 );
		}
		me["capacity.green"].setTranslation( ( 1 - cap ) * -460, 0 );
	}
};

var base_updater = maketimer( 0.02, canvas_eng_display_base.update );
base_updater.simulatedTime = 1;

setlistener("sim/signals/fdm-initialized", func {
	eng_display_display = canvas.new({
		"name": "Engine Display",
		"size": [480, 320],
		"view": [480, 320],
		"mipmapping": 1
	});
	eng_display_display.addPlacement({"node": "eng_display.display"});

	eng_display_main = canvas_eng_display_main.new(eng_display_display.createGroup(), instrument_dir~"eng_display.svg");

	base_updater.start();
});
