var config = io.read_properties("Models/FlightDeck/Instruments/kfc225/kfc225-config.xml");

var kfc225_ap   = props.globals.initNode("autopilot/kfc225/event/button-ap" ,  0, "BOOL");
var kfc225_hdg  = props.globals.initNode("autopilot/kfc225/event/button-hdg",  0, "BOOL");
var kfc225_nav  = props.globals.initNode("autopilot/kfc225/event/button-nav",  0, "BOOL");
var kfc225_apr  = props.globals.initNode("autopilot/kfc225/event/button-apr",  0, "BOOL");
var kfc225_rev  = props.globals.initNode("autopilot/kfc225/event/button-rev",  0, "BOOL");
var kfc225_alt  = props.globals.initNode("autopilot/kfc225/event/button-alt",  0, "BOOL");
var kfc225_down = props.globals.initNode("autopilot/kfc225/event/button-down", 0, "BOOL");
var kfc225_up   = props.globals.initNode("autopilot/kfc225/event/button-up",   0, "BOOL");
var kfc225_arm  = props.globals.initNode("autopilot/kfc225/event/button-arm",  0, "BOOL");
var kfc225_vs   = props.globals.initNode("autopilot/kfc225/event/button-vs",   0, "BOOL");
var kfc225_fd   = props.globals.initNode("autopilot/kfc225/event/button-fd",   0, "BOOL");
var kfc225_yd   = props.globals.initNode("autopilot/kfc225/event/button-yd",   0, "BOOL");
var kfc225_ga   = props.globals.initNode("autopilot/kfc225/event/button-ga",   0, "BOOL"); # located off-device, typically on throttle lever
var kfc225_outer= props.globals.initNode("autopilot/kfc225/event/knob-outer",  0, "INT");
var kfc225_inner= props.globals.initNode("autopilot/kfc225/event/knob-inner",  0, "INT");

var kfc225_vert_mode = props.globals.getNode("autopilot/kfc225/settings/vertical-mode", 1);
var kfc225_vert_arm  = props.globals.getNode("autopilot/kfc225/settings/vertical-arm",  1);
var kfc225_lat_mode  = props.globals.getNode("autopilot/kfc225/settings/lateral-mode",  1);
var kfc225_lat_arm   = props.globals.getNode("autopilot/kfc225/settings/lateral-arm",   1);

var kfc225_state	= props.globals.getNode("autopilot/kfc225/panel/state", 1);

setlistener( kfc225_state, func{
	var x = kfc225_state.getIntValue();
	# print( "AP State Changed to"~ x );
	
	if( x == 5 ){	# Active
		if( kfc225_vert_mode.getIntValue() == 0 ){
			kfc225_vert_mode.setIntValue( 1 );	# set default mode PIT
		}
	} else {	# Standby: Reset Modes
		kfc225_lat_arm.setIntValue( 0 );
		kfc225_lat_mode.setIntValue( 0 );
		kfc225_vert_arm.setIntValue( 0 );
		kfc225_vert_mode.setIntValue( 0 );
		setprop( "autopilot/internal/target-climb-rate", 0 );
		setprop( "autopilot/internal/target-pitch-deg", 0 );
		setprop( "autopilot/internal/target-intercept-angle", 0 );
		setprop( "autopilot/internal/target-roll-deg", 0 );
		setprop( "autopilot/internal/target-pressure", 0 );
	}
	
});

setlistener( kfc225_vert_arm, func{
	var x = kfc225_vert_arm.getIntValue();
	if( x == -1 ){	# ALT Capture Signal (kfc225-proprules.xml, filter "capture ALT")
		kfc225_vert_mode.setIntValue( 3 );	# Engage ALT Mode
	}
});

setlistener( kfc225_vert_mode, func{
	var x = kfc225_vert_mode.getIntValue();
	# print( "Vert Mode Changed to "~ x );
	
	
	if( x == 3 ){	# ALT Mode Engaged
		if( kfc225_vert_arm.getIntValue() == -1 ){
			kfc225_vert_arm.setIntValue( 0 );	# cancel ALT ARM
		}
		setprop( "autopilot/kfc225/panel/fpm-timer", 0 );	# Reset FPM Timer
	}
});

setlistener( kfc225_lat_mode, func{
	var x = kfc225_lat_mode.getIntValue();
	
	if( x < 3 ){
		if( getprop("autopilot/kfc225/panel/nav-timer") > 1 ){	# cancel nav-timer in ROL or HDG mode
			setprop("autopilot/kfc225/panel/nav-timer", 0);
		}
	}
});

setlistener(kfc225_ap, func(ap) {
	if (ap.getBoolValue()) {
		setprop("autopilot/kfc225/panel/button-ap",     getprop("sim/time/elapsed-sec"));
		setprop("autopilot/kfc225/panel/state-old",     getprop("autopilot/kfc225/panel/state"));
		setprop("autopilot/internal/target-climb-rate", getprop("autopilot/internal/vert-speed-fpm"));
		setprop("autopilot/internal/target-pitch-deg",  getprop("autopilot/internal/pitch-deg"));
	}
	else
	{
		setprop("autopilot/kfc225/panel/button-ap", 0);
	}
},0,0);

setlistener(kfc225_hdg, func(hdg) {
	if (hdg.getBoolValue()) {
		setprop("autopilot/kfc225/panel/button-hdg", getprop("sim/time/elapsed-sec"));
		if (getprop("autopilot/kfc225/panel/state") == 5) {
			if (
				getprop("autopilot/kfc225/settings/lateral-mode") < 3 and
				getprop("autopilot/kfc225/settings/lateral-arm") < 3
			) {
				if (getprop("autopilot/kfc225/settings/lateral-mode") == 1)
				{
					setprop("autopilot/kfc225/settings/lateral-mode", 2);
				}
				else if (getprop("autopilot/kfc225/settings/lateral-mode") == 2)
				{
					setprop("autopilot/kfc225/settings/lateral-mode", 1);
				}
			}
			if (
				getprop("autopilot/kfc225/settings/lateral-mode") > 2 and
				getprop("autopilot/kfc225/settings/lateral-mode") < 6
			) {
				if (getprop("autopilot/kfc225/settings/from-hdg"))
				{
					setprop("autopilot/kfc225/settings/lateral-mode", 2);
				}
				else
				{
					setprop("autopilot/kfc225/settings/lateral-mode", 1);
				}
			}
			if (getprop("autopilot/kfc225/settings/lateral-mode") < 3)
			{
				setprop("autopilot/kfc225/settings/from-hdg", 0);
			}
		}
	}
	else
	{
		setprop("autopilot/kfc225/panel/button-hdg", 0);
	}
	setprop("autopilot/kfc225/settings/lateral-arm", 0);
	setprop("autopilot/internal/target-roll-deg", 0);
	setprop("autopilot/internal/target-intercept-angle", 0);
	setprop("autopilot/kfc225/panel/hdg-timer", 0);
	setprop("autopilot/kfc225/panel/nav-timer", 0);
},0,0);

setlistener(kfc225_nav, func(nav) {
	if (nav.getBoolValue()) {
		setprop("autopilot/kfc225/panel/button-nav", getprop("sim/time/elapsed-sec"));
		if (getprop("autopilot/kfc225/panel/state") == 5) {
			if (getprop("autopilot/kfc225/settings/lateral-mode") != 3) {
				if (getprop("autopilot/kfc225/settings/lateral-arm") == 3) {
					setprop("autopilot/kfc225/settings/lateral-arm", 0);
				}
				else
				{
					setprop("autopilot/kfc225/settings/lateral-arm", 3);
				}
			}
		}
	}
	else
	{
		setprop("autopilot/kfc225/panel/button-nav", 0);
	}
	setprop("autopilot/kfc225/panel/nav-timer", 0);
},0,0);

setlistener(kfc225_apr, func(apr) {
	if (apr.getBoolValue()) {
		setprop("autopilot/kfc225/panel/button-apr", getprop("sim/time/elapsed-sec"));
		if (getprop("autopilot/kfc225/panel/state") == 5) {
			if (getprop("autopilot/kfc225/settings/lateral-mode") != 4) {
				if (getprop("autopilot/kfc225/settings/lateral-arm") == 4) {
					setprop("autopilot/kfc225/settings/lateral-arm", 0);
				}
				else
				{
					setprop("autopilot/kfc225/settings/lateral-arm", 4);
				}
			}
		}
	}
	else
	{
		setprop("autopilot/kfc225/panel/button-apr", 0);
	}
	setprop("autopilot/kfc225/panel/nav-timer", 0);
},0,0);

setlistener(kfc225_rev, func(rev) {
	if (rev.getBoolValue()) {
		setprop("autopilot/kfc225/panel/button-rev", getprop("sim/time/elapsed-sec"));
		if (getprop("autopilot/kfc225/panel/state") == 5) {
			if (getprop("autopilot/kfc225/settings/lateral-mode") != 5) {
				if (getprop("autopilot/kfc225/settings/lateral-arm") == 5) {
					setprop("autopilot/kfc225/settings/lateral-arm", 0);
				}
				else
				{
					setprop("autopilot/kfc225/settings/lateral-arm", 5);
				}
			}
		}
	}
	else
	{
		setprop("autopilot/kfc225/panel/button-rev", 0);
	}
	setprop("autopilot/kfc225/panel/nav-timer", 0);
},0,0);

setlistener(kfc225_alt, func(alt) {
	if (alt.getBoolValue()) {
		setprop("autopilot/kfc225/panel/button-alt", getprop("sim/time/elapsed-sec"));
		if (getprop("autopilot/kfc225/panel/state") == 5) {
			var pressure_source = config.getValue("params/pressure-source");
			if ( kfc225_vert_mode.getIntValue() == 3 ) {
				kfc225_vert_mode.setIntValue( 1 );
				setprop("autopilot/internal/target-pressure", 0.0);
			} else {
				kfc225_vert_mode.setIntValue( 3 );
				setprop("autopilot/internal/target-pressure", getprop(pressure_source));
			}
			setprop("autopilot/kfc225/panel/gs-timer", 0);
		}
	}
	else
	{
		setprop("autopilot/kfc225/panel/button-alt", 0);
	}
},0,0);

setlistener(kfc225_down, func(down) {
	if (down.getBoolValue()) {
		setprop("autopilot/kfc225/panel/button-down", getprop("sim/time/elapsed-sec"));
		if (getprop("autopilot/kfc225/panel/state") == 5) {
			if (getprop("autopilot/kfc225/settings/vertical-mode") == 1 ){	# PITCH
				setprop("autopilot/internal/target-pitch-deg", math.max( getprop("autopilot/internal/target-pitch-deg") - 1, -10 ) );
			}
			if (getprop("autopilot/kfc225/settings/vertical-mode") == 2 and	# VERTICAL SPEED
				getprop("autopilot/kfc225/panel/fpm-timer") > 0)
			{
				var climb = getprop("autopilot/internal/target-climb-rate") - 100;
				if (climb < -2000) climb = -2000;
				setprop("autopilot/internal/target-climb-rate", climb);
			}
			if (getprop("autopilot/kfc225/settings/vertical-mode") == 3)	# ALTITUDE
			{
				var pressure = getprop("autopilot/internal/target-pressure") + .022;
				if (pressure > 35.0) pressure = 35.0;
				setprop("autopilot/internal/target-pressure", pressure);
			}
			setprop("autopilot/kfc225/panel/fpm-old", getprop("autopilot/internal/target-climb-rate"));
		}
	}
	else
	{
		if (getprop("autopilot/kfc225/panel/state") == 5 and
			getprop("autopilot/kfc225/settings/vertical-mode") == 3 and
			getprop("sim/time/elapsed-sec") > getprop("autopilot/kfc225/panel/button-down") + 1
		)
		{
			var pressure_source = config.getValue("params/pressure-source");
			setprop("autopilot/internal/target-pressure", getprop(pressure_source));
		}
		setprop("autopilot/kfc225/panel/button-down", 0);
	}
},0,0);

setlistener(kfc225_up, func(up) {
	if (up.getBoolValue()) {
		setprop("autopilot/kfc225/panel/button-up", getprop("sim/time/elapsed-sec"));
		if (getprop("autopilot/kfc225/panel/state") == 5) {
			if (getprop("autopilot/kfc225/settings/vertical-mode") == 1 ){	# PITCH
				setprop("autopilot/internal/target-pitch-deg", math.min( getprop("autopilot/internal/target-pitch-deg") + 1, 10 ) );
			}
			if (getprop("autopilot/kfc225/settings/vertical-mode") == 2 and	# VERTICAL SPEED
				getprop("autopilot/kfc225/panel/fpm-timer") > 0)
			{
				var climb = getprop("autopilot/internal/target-climb-rate") + 100;
				if (climb > 2000) climb = 2000;
				setprop("autopilot/internal/target-climb-rate", climb);
			}
			if (getprop("autopilot/kfc225/settings/vertical-mode") == 3)	# ALTITUDE
			{
				var pressure = getprop("autopilot/internal/target-pressure") - .022;
				if (pressure < 5.0) pressure = 5.0;
				setprop("autopilot/internal/target-pressure", pressure);
			}
			setprop("autopilot/kfc225/panel/fpm-old", getprop("autopilot/internal/target-climb-rate"));
		}
	}
	else
	{
		if (getprop("autopilot/kfc225/panel/state") == 5 and
			getprop("autopilot/kfc225/settings/vertical-mode") == 3 and
			getprop("sim/time/elapsed-sec") > getprop("autopilot/kfc225/panel/button-up") + 1
		)
		{
			var pressure_source = config.getValue("params/pressure-source");
			setprop("autopilot/internal/target-pressure", getprop(pressure_source));
		}
		setprop("autopilot/kfc225/panel/button-up", 0);
	}
},0,0);

setlistener(kfc225_arm, func(arm) {
	if (arm.getBoolValue()) {
		setprop("autopilot/kfc225/panel/button-arm", getprop("sim/time/elapsed-sec"));
		if (getprop("autopilot/kfc225/panel/state") == 5) {
			if( kfc225_vert_arm.getIntValue() == 3 ){
				kfc225_vert_arm.setIntValue( 0 );
			} else {
				kfc225_vert_arm.setIntValue( 3 );
			}
		}
	}
	else
	{
		setprop("autopilot/kfc225/panel/button-arm", 0);
	}
},0,0);

setlistener(kfc225_vs, func(vs) {
	if (vs.getBoolValue()) {
		setprop("autopilot/kfc225/panel/button-vs", getprop("sim/time/elapsed-sec"));
		if (getprop("autopilot/kfc225/panel/state") == 5) {
			if ( kfc225_vert_mode.getIntValue() != 2 ) {
				kfc225_vert_mode.setIntValue( 2 );
			} else {
				kfc225_vert_mode.setIntValue( 1 );
			}
			setprop("autopilot/kfc225/panel/gs-timer", 0);
		}
	}
	else
	{
		setprop("autopilot/kfc225/panel/button-vs", 0);
	}
},0,0);

setlistener(kfc225_ga, func(ga) {
	if (ga.getBoolValue()) {
		setprop("autopilot/kfc225/panel/button-ga", getprop("sim/time/elapsed-sec"));
		if (getprop("autopilot/kfc225/panel/state") == 5) {
			kfc225_lat_mode.setIntValue( 1 ); # ROLL HOLD
			kfc225_vert_mode.setIntValue( 5 ); # Go-Around Mode
			# Cancel Armed Modes
			kfc225_lat_arm.setIntValue( 0 );
			kfc225_vert_arm.setIntValue( 0 );
			setprop("autopilot/kfc225/panel/gs-timer", 0);
		}
	}
	else
	{
		setprop("autopilot/kfc225/panel/button-ga", 0);
	}
},0,0);

setlistener(kfc225_outer, func(outer) {
	if (outer.getValue()) {
		
		if (getprop("autopilot/kfc225/panel/state") > 3 and
			getprop("autopilot/kfc225/panel/digit-mode") == 1)
		{
			var altitude = getprop("autopilot/internal/target-altitude") + outer.getValue() * 1000;
			if (altitude < -1000) altitude = -1000;
			if (altitude > 35000) altitude = 35000;
			setprop("autopilot/internal/target-altitude", altitude);
			
			if (getprop("autopilot/kfc225/panel/state") > 3) {
				kfc225_vert_arm.setIntValue( 3 );
			}
		}
		
		setprop("autopilot/kfc225/panel/knob-outer-pos", getprop("autopilot/kfc225/panel/knob-outer-pos") + outer.getValue());
		setprop("autopilot/kfc225/event/knob-outer", 0);
	}
},0,0);


setlistener(kfc225_inner, func(inner) {
	if (inner.getValue()) {
		
		if (getprop("autopilot/kfc225/panel/state") > 3 and
			getprop("autopilot/kfc225/panel/digit-mode") == 1)
		{
			var altitude = getprop("autopilot/internal/target-altitude") + inner.getValue() * 100;
			if (altitude < -1000) altitude = -1000;
			if (altitude > 35000) altitude = 35000;
			setprop("autopilot/internal/target-altitude", altitude);
			
			if (getprop("autopilot/kfc225/panel/state") > 3) {
				kfc225_vert_arm.setIntValue( 3 );
			}
		}
		
		setprop("autopilot/kfc225/panel/knob-inner-pos", getprop("autopilot/kfc225/panel/knob-inner-pos") + inner.getValue());
		setprop("autopilot/kfc225/event/knob-inner", 0);
	}
},0,0);

